/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.acc;

import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import net.sf.apptools.plugin.AbstractParameterPlugIn;
import org.moltools.apps.probemaker.design.ProbeAcceptor;
import org.moltools.apps.probemaker.ext.Messages;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.data.Candidate;
import org.moltools.design.properties.PropertyHolder;

public class MaxNumberAcceptor
extends AbstractParameterPlugIn
implements ProbeAcceptor {
    public static final String KEY_MAX_CANDIDATES = "MAX_CANDIDATES";
    static final DataDescriptor[] dataDescriptors = new DataDescriptor[]{new IntegerDescriptor(Messages.getString("MaxNumberAcceptor.MAX_NAME"), Messages.getString("MaxNumberAcceptor.MAX_DESCRIPTION"), "MAX_CANDIDATES", 0, Integer.MAX_VALUE)};
    int count = 0;
    Probe lastProbe = null;

    public MaxNumberAcceptor() {
        super(dataDescriptors);
        this.setData(KEY_MAX_CANDIDATES, new Integer(50));
    }

    public static String getBriefDescription() {
        return Messages.getString("MaxNumberAcceptor.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return Messages.getString("MaxNumberAcceptor.LONG_DESCRIPTION");
    }

    public byte accept(Candidate p) {
        switch (ProbeMakerPropertyUtils.getRank((PropertyHolder)p)) {
            case 3: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public byte acceptArms(Probe p) {
        return ProbeMakerPropertyUtils.getRank((PropertyHolder)p) >= 3 ? (byte)2 : 0;
    }

    public byte acceptPrimary(Probe p) {
        if (this.lastProbe == null) {
            this.lastProbe = p;
            this.count = 1;
        } else if (this.lastProbe.getID().equals(p.getID())) {
            ++this.count;
        } else {
            this.lastProbe = p;
            this.count = 1;
        }
        if (this.count > (Integer)this.getData(KEY_MAX_CANDIDATES)) {
            return -1;
        }
        return ProbeMakerPropertyUtils.getRank((PropertyHolder)p) >= 2 ? (byte)2 : 0;
    }

    public boolean overridesTSSDecision() {
        return false;
    }

    public boolean overridesCandidateDecision() {
        return true;
    }
}

