/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import net.sf.apptools.data.BooleanDescriptor;
import net.sf.apptools.data.DataDescriptor;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSSLengthAndTmModule
extends AbstractProbeModule {
    public static final MessageType FIVE_PRIME_HYBRIDIZATION_TEMPERATURE = new MessageType("FIVE_PRIME_HYBRIDIZATION_TEMPERATURE", "5' hybridization temperature");
    public static final MessageType THREE_PRIME_HYBRIDIZATION_TEMPERATURE = new MessageType("THREE_PRIME_HYBRIDIZATION_TEMPERATURE", "3' hybridization temperature");
    public static final MessageType PROBE_ARM_LENGTH = new MessageType("PROBE_ARM_LENGTH", "TSS lengths");
    public static final String PROP_USE_CUTOFF_MODE = "USE_CUTOFF_MODE";
    transient double preftemp3;
    transient double tempspan3;
    transient double preftemp5;
    transient double tempspan5;
    transient int minlength3;
    transient int maxlength3;
    transient int minlength5;
    transient int maxlength5;
    transient boolean cutoffMode;

    public static String getBriefDescription() {
        return "TSS length and temperature module";
    }

    public static String getLongDescription() {
        return "<html>Determines whether the target-specific sequences are within the set limits of length and temperature. <br>If temperature is outside of the allowed span, but inside twice that span, a warning is given, if outside twice the span, an error message is given. If length is outside of the allowed range, an error message is given.<br>If the cutoff mode is used, only the lower temperature limit is considered.</html>";
    }

    public TSSLengthAndTmModule() {
        super(new TestDescriptor[]{new TestDescriptor("5' hybridization temparature"), new TestDescriptor("3' hybridization temperature"), new TestDescriptor("5' TSS length"), new TestDescriptor("3' TSS length")}, new DataDescriptor[]{new BooleanDescriptor("Use cutoff mode", "Give warning and error messages only for values below the preferred Tm. Allow all values above the limit.", PROP_USE_CUTOFF_MODE)});
        this.setData(PROP_USE_CUTOFF_MODE, new Boolean(false));
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        this.preftemp3 = Double.parseDouble((String)pd.getParameters().get("PREFERRED_3_PRIME_ARM_HYBRIDIZATION_TEMPERATURE"));
        this.tempspan3 = Double.parseDouble((String)pd.getParameters().get("3_PRIME_ARM_HYBRIDIZATION_TEMPERATURE_SPAN"));
        this.minlength3 = Integer.parseInt((String)pd.getParameters().get("MIN_3_PRIME_ARM_LENGTH"));
        this.maxlength3 = Integer.parseInt((String)pd.getParameters().get("MAX_3_PRIME_ARM_LENGTH"));
        this.preftemp5 = Double.parseDouble((String)pd.getParameters().get("PREFERRED_5_PRIME_ARM_HYBRIDIZATION_TEMPERATURE"));
        this.tempspan5 = Double.parseDouble((String)pd.getParameters().get("5_PRIME_ARM_HYBRIDIZATION_TEMPERATURE_SPAN"));
        this.minlength5 = Integer.parseInt((String)pd.getParameters().get("MIN_5_PRIME_ARM_LENGTH"));
        this.maxlength5 = Integer.parseInt((String)pd.getParameters().get("MAX_5_PRIME_ARM_LENGTH"));
        try {
            this.check5PrimeArm((PropertyAcceptorNucleotideSequence)p.getTSSPair().getSequence("FIVE_PRIME"));
        }
        catch (ClusterException e) {
            // empty catch block
        }
        try {
            this.check3PrimeArm((PropertyAcceptorNucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME"));
        }
        catch (ClusterException e) {
            // empty catch block
        }
    }

    protected void check3PrimeArm(PropertyAcceptorNucleotideSequence pa) {
        float Tm = ProbeMakerPropertyUtils.getHybridizationTemp((PropertyHolder)pa);
        if (this.tests[1].perform()) {
            if ((double)Tm < this.preftemp3 - 2.0 * this.tempspan3) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("3' arm hybridization temperature very low", THREE_PRIME_HYBRIDIZATION_TEMPERATURE, 2));
            } else if ((double)Tm < this.preftemp3 - this.tempspan3) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("3' arm hybridization temperature low", THREE_PRIME_HYBRIDIZATION_TEMPERATURE, 1));
            }
            if (!((Boolean)this.getData(PROP_USE_CUTOFF_MODE)).booleanValue()) {
                if ((double)Tm > this.preftemp3 + 2.0 * this.tempspan3) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("3' arm hybridization temperature very high", THREE_PRIME_HYBRIDIZATION_TEMPERATURE, 2));
                } else if ((double)Tm > this.preftemp3 + this.tempspan3) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("3' arm hybridization temperature high", THREE_PRIME_HYBRIDIZATION_TEMPERATURE, 1));
                }
            }
        }
        if (this.tests[3].perform()) {
            if (pa.length() < this.minlength3) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("3' arm shorter than minimum length", THREE_PRIME_HYBRIDIZATION_TEMPERATURE, 1));
            }
            if (pa.length() > this.maxlength3) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("3' arm longer than maximum size", THREE_PRIME_HYBRIDIZATION_TEMPERATURE, 1));
            }
        }
    }

    protected void check5PrimeArm(PropertyAcceptorNucleotideSequence pa) {
        double Tm = ProbeMakerPropertyUtils.getHybridizationTemp((PropertyHolder)pa);
        if (this.tests[0].perform()) {
            if (Tm < this.preftemp5 - 2.0 * this.tempspan5) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("5' arm hybridization temperature very low", FIVE_PRIME_HYBRIDIZATION_TEMPERATURE, 2));
            } else if (Tm < this.preftemp5 - this.tempspan5) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("5' arm hybridization temperature low", FIVE_PRIME_HYBRIDIZATION_TEMPERATURE, 1));
            }
            if (!((Boolean)this.getData(PROP_USE_CUTOFF_MODE)).booleanValue()) {
                if (Tm > this.preftemp5 + 2.0 * this.tempspan5) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("5' arm hybridization temperature very high", FIVE_PRIME_HYBRIDIZATION_TEMPERATURE, 2));
                } else if (Tm > this.preftemp5 + this.tempspan5) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("5' arm hybridization temperature high", FIVE_PRIME_HYBRIDIZATION_TEMPERATURE, 1));
                }
            }
        }
        if (this.tests[2].perform()) {
            if (pa.length() < this.minlength5) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("5' arm shorter than minimum length", PROBE_ARM_LENGTH, 1));
            }
            if (pa.length() > this.maxlength5) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)pa, (Message)new Message("5' arm longer than maximum size", PROBE_ARM_LENGTH, 1));
            }
        }
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> probes) {
        return true;
    }

    public void reset() {
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> otherProbes) {
    }
}

