/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.pof;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.sf.apptools.plugin.PlugIn;
import net.sf.apptools.textio.impl.SimpleDelimitedOutput;
import org.moltools.apps.probemaker.io.SimpleProbeDBOutputFormat;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.design.data.Target;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.io.SequenceWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockTextTablePOF<T extends Probe>
extends SimpleProbeDBOutputFormat<T>
implements PlugIn {
    static SimpleDelimitedOutput output = new SimpleDelimitedOutput("\t");

    public static String getBriefDescription() {
        return "Text table with all blocks";
    }

    public static String getLongDescription() {
        return "Text table format with an ID and a sequence column for each sequence block";
    }

    public BlockTextTablePOF() {
        super(new SequenceWriter<T>(){

            public void writeSequence(PrintWriter ps, T p) {
                ArrayList<String> record = new ArrayList<String>();
                Target t = p.getTarget();
                record.add(p.getID());
                record.add(p.getName());
                record.add(p.seqString());
                for (NucleotideSequence s : p.getSequences()) {
                    record.add(s.getID());
                    record.add(s.seqString());
                }
                ps.println(output.getLine(record.toArray(new String[record.size()])));
            }
        });
    }
}

