/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.properties.Property;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.services.impl.GCAnalysis;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCContentModule
extends AbstractProbeModule {
    private int maxGC;
    private int minGC;
    static MessageType GC_CONTENT = new MessageType("GC_CONTENT", "Target GC content");
    protected GCAnalysis gcanalysis = new GCAnalysis();

    public static String getBriefDescription() {
        return "%GC content";
    }

    public static String getLongDescription() {
        return "<html>This module restricts %GC content in the target sequence.</html>";
    }

    public GCContentModule() {
        super(new TestDescriptor[]{new TestDescriptor("%GC Content")}, new DataDescriptor[]{new IntegerDescriptor("Max %GC", "Max allowed GC content in per cent.", "MAX_GC", 0, 100), new IntegerDescriptor("Min %GC", "Min allowed GC content in per cent.", "MIN_GC", 0, 100)});
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> probes) {
        return true;
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (this.tests[0].perform()) {
            Sequence target = (Sequence)p.getTarget();
            Property prop = (Property)this.gcanalysis.analyze((Object)target).get(0);
            float percentGC = ((Float)prop.getValue()).floatValue();
            if (percentGC > (float)this.maxGC) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("%GC content in target is too high, " + Math.round(percentGC) + "% (Max set to " + this.maxGC + "%)", GC_CONTENT, 2));
            } else if (percentGC < (float)this.minGC) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("%GC content in target is too low, " + Math.round(percentGC) + "%  (Min set to " + this.minGC + "%)", GC_CONTENT, 2));
            }
        }
    }

    public void reset() {
        this.maxGC = (Integer)this.getData("MAX_GC");
        this.minGC = (Integer)this.getData("MIN_GC");
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> otherProbes) {
    }
}

