/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import java.util.Collection;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.IncludeTypesFilter;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.data.Candidate;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringHeteroDimerModule
extends AbstractProbeModule {
    public static final MessageType PROBE_HETERODIMER_FORMATION = new MessageType("PROBE_HETERODIMER_FORMATION", "Probe heterodimer formation");
    static final String KEY_WINDOW = "WINDOW";
    static final String KEY_STRINGENCY = "STRINGENCY";
    static final DataDescriptor[] descriptors = new DataDescriptor[]{new IntegerDescriptor("Window", "Length of window for hairpin scanning", "WINDOW", 1, Integer.MAX_VALUE), new IntegerDescriptor("Stringency", "Number of basepairs within window to call a hairpin", "STRINGENCY", 1, Integer.MAX_VALUE)};

    public static String getBriefDescription() {
        return "Sliding window heterodimer formation module";
    }

    public static String getLongDescription() {
        return "<html>Tests whether a probe will form a dimer with another probe by searching<br>for complementary substrings by a sliding window approach, according to YODA</html>";
    }

    public StringHeteroDimerModule() {
        super(new TestDescriptor[]{new TestDescriptor("Probe-probe heterodimer formation")}, descriptors);
        this.setData(KEY_WINDOW, new Integer(10));
        this.setData(KEY_STRINGENCY, new Integer(6));
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (!CollectionUtils.select((Collection)ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)p), (Predicate)new IncludeTypesFilter(new MessageType[]{PROBE_HETERODIMER_FORMATION})).isEmpty()) {
            for (Probe other : probes) {
                if (other == p || !other.tagsAllocated()) continue;
                boolean dimer = this.dimer((NucleotideSequence)p, (NucleotideSequence)other);
                if (dimer) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)other, (Message)new Message("High risk of hetero-dimer formation with " + other.getName(), PROBE_HETERODIMER_FORMATION, 2));
                }
                Analyzer.calculateAndSetQuality((Candidate)other);
            }
        }
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (this.tests[0].perform()) {
            for (Probe other : probes) {
                boolean dimer;
                if (other == p || !other.tagsAllocated() || !(dimer = this.dimer((NucleotideSequence)p, (NucleotideSequence)other))) continue;
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("High risk of hetero-dimer formation with " + other.getName(), PROBE_HETERODIMER_FORMATION, 2));
            }
        }
    }

    protected boolean dimer(NucleotideSequence seq1, NucleotideSequence seq2) {
        int window = (Integer)this.getData(KEY_WINDOW);
        int stringency = (Integer)this.getData(KEY_STRINGENCY);
        if (stringency > window || window > seq1.length() || window > seq2.length()) {
            return false;
        }
        byte[] seqbytes1 = NucleotideSequenceHandler.getSequenceByteArray((NucleotideSequence)seq1);
        byte[] seqbytes2 = NucleotideSequenceHandler.getSequenceByteArray((NucleotideSequence)seq2);
        int last2 = seqbytes2.length - 1;
        for (int i = 0; i < seqbytes1.length - window + 1; ++i) {
            for (int j = last2; j >= window - 1; --j) {
                int matches = 0;
                for (int k = 0; k < window; ++k) {
                    int sum = seqbytes1[i + k] + seqbytes2[j - k];
                    if (sum != 3 || ++matches != stringency) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void reset() {
    }
}

