/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import java.io.IOException;
import java.util.Collection;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DoubleDescriptor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.moltools.apps.probemaker.ProbeMakerConstants;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.IncludeTypesFilter;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.calc.FractionalMeltingPointCalculator;
import org.moltools.design.calc.FractionalNNParameters;
import org.moltools.design.calc.NNParameters;
import org.moltools.design.data.Candidate;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.struct.NAHybridStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TmProbeDimerModule
extends AbstractProbeModule {
    public static final MessageType PROBE_DIMER_FORMATION = new MessageType("PROBE_DIMER_FORMATION", "Probe dimer formation");
    FractionalMeltingPointCalculator fmpc;
    double span;
    double max;
    static final String KEY_ALLOWED_COMPLEMENTARITY_SCORE = "ALLOWED_COMPLEMENTARITY_SCORE";
    static final String KEY_COMPLEMENTARITY_SCORE_LIMIT = "COMPLEMENTARITY_SCORE_LIMIT";
    static byte NO_RISK = 0;
    static byte RISK = 1;
    static byte HI_RISK = (byte)2;

    public static String getBriefDescription() {
        return "Tm-based dimer formation module";
    }

    public static String getLongDescription() {
        return "<html>Tests whether a probe will form a dimer with another probe by performing a Tm calculation with the fractional programming approach described in<p>Leber <i>et al.</i> (2005) A fractional programming approach to efficient DNA melting temperature calculation. <i>Nucleic Acids Res.</i>, <b>31</b>, 1796-1802.<html>";
    }

    public TmProbeDimerModule() {
        super(new TestDescriptor[]{new TestDescriptor("Probe-probe hetero-dimer formation"), new TestDescriptor("Probe homo-dimer formation")}, new DataDescriptor[]{new DoubleDescriptor("Max Tm", "Maximum Tm for " + ProbeMakerConstants.qualityStrings[3] + " quality", KEY_ALLOWED_COMPLEMENTARITY_SCORE, 0.0, 100.0), new DoubleDescriptor("Allowed Tm range", "Allowed Tm above max for " + ProbeMakerConstants.qualityStrings[2] + " quality", KEY_COMPLEMENTARITY_SCORE_LIMIT, 0.0, 100.0)});
        this.setData(KEY_ALLOWED_COMPLEMENTARITY_SCORE, new Double(30.0));
        this.setData(KEY_COMPLEMENTARITY_SCORE_LIMIT, new Double(10.0));
        try {
            this.fmpc = new FractionalMeltingPointCalculator((NNParameters)new FractionalNNParameters());
        }
        catch (IOException e) {
            throw new RuntimeException("NN Parameters file could not be found/read", e);
        }
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (this.tests[0].perform()) {
            for (Probe other : probes) {
                if (other.equals(p) || !other.tagsAllocated()) continue;
                byte dimer = this.compare((NucleotideSequence)p, (NucleotideSequence)other);
                if (dimer == HI_RISK) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("High risk of hetero-dimer formation with " + other.getName(), PROBE_DIMER_FORMATION, 2));
                    continue;
                }
                if (dimer != RISK) continue;
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Risk of hetero-dimer formation with " + other.getName(), PROBE_DIMER_FORMATION, 1));
            }
        }
        if (this.tests[1].perform()) {
            byte dimer = this.compare((NucleotideSequence)p, (NucleotideSequence)p);
            if (dimer == HI_RISK) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("High risk of homo-dimer formation", PROBE_DIMER_FORMATION, 2));
            } else if (dimer == RISK) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Risk of homo-dimer formation", PROBE_DIMER_FORMATION, 1));
            }
        }
    }

    byte compare(NucleotideSequence p, NucleotideSequence other) {
        NAHybridStructure struct = this.fmpc.calculateHybridStructure(p, other);
        float Tm = struct == null ? -273.15f : this.fmpc.getMeltingPoint(p, other, struct);
        if ((double)Tm > this.max + this.span) {
            return HI_RISK;
        }
        if ((double)Tm > this.max) {
            return RISK;
        }
        return NO_RISK;
    }

    public void reset() {
        this.max = (Double)this.getData(KEY_ALLOWED_COMPLEMENTARITY_SCORE);
        this.span = (Double)this.getData(KEY_COMPLEMENTARITY_SCORE_LIMIT);
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> otherProbes) {
        if (this.tests[0].perform() && !CollectionUtils.select((Collection)ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)p), (Predicate)new IncludeTypesFilter(new MessageType[]{PROBE_DIMER_FORMATION})).isEmpty()) {
            for (Probe other : otherProbes) {
                if (other.equals(p) || !other.tagsAllocated()) continue;
                byte dimer = this.compare((NucleotideSequence)p, (NucleotideSequence)other);
                if (dimer == HI_RISK) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)other, (Message)new Message("High risk of hetero-dimer formation with " + other.getName(), PROBE_DIMER_FORMATION, 2));
                } else if (dimer == RISK) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)other, (Message)new Message("Risk of hetero-dimer formation with " + other.getName(), PROBE_DIMER_FORMATION, 1));
                }
                Analyzer.calculateAndSetQuality((Candidate)other);
            }
        }
    }
}

