/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.ta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.moltools.apps.probemaker.design.ProbeGroup;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.ext.ta.GreedyTagAllocator;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;

public class PairwiseTagAllocator
extends GreedyTagAllocator {
    public boolean allocateTagsToGroup(ProbeGroup pg) {
        if (pg.getMembers().size() == 2) {
            int i;
            int i2;
            this.htmllog.printLineAndHeader("Allocating tags to next group");
            log.info((Object)"Allocating tags to next group");
            if (this.tagSelector == null) {
                throw new UnsupportedOperationException("No TagSelector has been set");
            }
            Probe[] groupprobes = new Probe[pg.getMembers().size()];
            Iterator pi = pg.getMembers().iterator();
            for (i2 = 0; i2 < groupprobes.length; ++i2) {
                groupprobes[i2] = (Probe)pi.next();
            }
            this.badTagsCurrent = new List[this.taglibraries.length];
            for (i2 = 0; i2 < this.badTagsCurrent.length; ++i2) {
                this.badTagsCurrent[i2] = new ArrayList(this.badTagsAll[i2]);
            }
            log.debug((Object)"Using pairwise acceptation");
            byte acceptFirst = this.analyzer.analyzeTSSPair(groupprobes[0], (TagAllocator)this, this.probes);
            byte acceptSecond = this.analyzer.analyzeTSSPair(groupprobes[1], (TagAllocator)this, this.probes);
            if (acceptFirst != 2 || acceptSecond != 2) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)groupprobes[0], (Message)new Message("Skipped probe because of problems with TSS pair in group", TAG_ALLOCATION, 3));
                this.htmllog.printLine("Problem with TSS pair in group - Skipping probe");
                this.htmllog.printList(ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)groupprobes[0]));
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)groupprobes[1], (Message)new Message("Skipped probe because of problems with TSS pair in group", TAG_ALLOCATION, 3));
                this.htmllog.printLine("Problem with TSS pair in group - Skipping probe");
                this.htmllog.printList(ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)groupprobes[1]));
                return false;
            }
            int[][] indices = new int[groupprobes.length][this.taglibraries.length];
            if (this.taglibraries.length > 0) {
                indices[0][this.taglibraries.length - 1] = -1;
                indices[1][this.taglibraries.length - 1] = -1;
            }
            int firstcombination = 1;
            boolean done = false;
            List[] tempbadTags = new List[this.badTagsCurrent.length];
            for (i = 0; i < tempbadTags.length; ++i) {
                tempbadTags[i] = new ArrayList(this.badTagsAll[i]);
            }
            while (!done) {
                if (this.canceled) {
                    this.htmllog.printError("Aborted - exiting");
                    return false;
                }
                this.tagSelector.setTagIndices(indices[0]);
                this.badTagsCurrent = new List[tempbadTags.length];
                for (i = 0; i < this.badTagsCurrent.length; ++i) {
                    this.badTagsCurrent[i] = new ArrayList(tempbadTags[i]);
                }
                this.currentTagCombination = firstcombination;
                boolean foundfirst = this.allocateTags(groupprobes[0]);
                if (!foundfirst) {
                    done = true;
                    break;
                }
                log.debug((Object)("Found first: " + foundfirst));
                firstcombination = this.currentTagCombination;
                tempbadTags = new List[this.badTagsCurrent.length];
                for (int i3 = 0; i3 < this.badTagsCurrent.length; ++i3) {
                    tempbadTags[i3] = new ArrayList(this.badTagsCurrent[i3]);
                }
                int[] tempInd = this.tagSelector.getTagIndices();
                if (tempInd != null) {
                    System.arraycopy(tempInd, 0, indices[0], 0, tempInd.length);
                } else {
                    indices[0] = null;
                }
                this.reserve(groupprobes[0]);
                this.tagSelector.setTagIndices(indices[1]);
                this.currentTagCombination = 0;
                boolean foundsecond = this.allocateTags(groupprobes[1]);
                this.reserve(groupprobes[1]);
                if (foundfirst && foundsecond) {
                    log.info((Object)"Found two good probes");
                    return true;
                }
                this.clear(groupprobes[0]);
                this.clear(groupprobes[1]);
                if (indices[0] == null) {
                    done = true;
                }
                if (foundfirst || this.taglibraries.length != 0) continue;
                done = true;
            }
            log.info((Object)"No acceptable pair of probes found");
            this.htmllog.printLine("No acceptable pair of probes found");
            this.badProbe(groupprobes[0]);
            this.badProbe(groupprobes[1]);
            return false;
        }
        return super.allocateTagsToGroup(pg);
    }
}

