/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.data;

import java.io.File;
import net.sf.apptools.data.AbstractDataDescriptor;
import net.sf.apptools.data.ConvertibleDataDescriptor;
import org.apache.commons.beanutils.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDataDescriptor
extends AbstractDataDescriptor
implements ConvertibleDataDescriptor {
    private Converter fileToStringConverter = new Converter(){

        public Object convert(Class type, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof File) {
                return ((File)value).getAbsolutePath();
            }
            throw new IllegalArgumentException("File to String converter cannot convert from " + value.getClass());
        }
    };

    public FileDataDescriptor(String name, String description, String propertyName, boolean required) {
        super(name, description, propertyName, required);
    }

    @Override
    public Class<?> getDataType() {
        return File.class;
    }

    public Object getValue(Object valueRepr) {
        if (valueRepr instanceof File) {
            return valueRepr;
        }
        if (valueRepr == null) {
            return null;
        }
        if (valueRepr.equals("")) {
            return null;
        }
        return new File(valueRepr.toString());
    }

    protected String getString(Object value) {
        if (value instanceof File) {
            return ((File)value).getAbsolutePath();
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Converter getToValueConverter() {
        return null;
    }

    @Override
    public Converter getToStringConverter() {
        return this.fileToStringConverter;
    }
}

