/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.calc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.moltools.design.calc.AbstractNNParameters;

public class FractionalNNParameters
extends AbstractNNParameters {
    public FractionalNNParameters(InputStream in) throws IOException {
        this.dH = new float[6][6][6][6];
        this.dS = new float[6][6][6][6];
        this.initParameters(in);
    }

    public FractionalNNParameters() throws IOException {
        this.dH = new float[6][6][6][6];
        this.dS = new float[6][6][6][6];
        this.initParameters(this.getClass().getResourceAsStream("params/FractionalNNParameters.txt"));
    }

    void initParameters(InputStream in) throws IOException {
        int y;
        int x;
        if (in == null) {
            throw new UnsupportedOperationException("Cannot load paramaters from null stream");
        }
        this.dHInit = 0.0f;
        this.dSInit = -5.9f;
        this.dHInitAT = 0.0f;
        this.dHInitGC = 0.0f;
        this.dSInitAT = 0.0f;
        this.dSInitGC = 0.0f;
        for (int x2 = 1; x2 <= 4; ++x2) {
            this.dH[x2][4][4][4] = Float.MAX_VALUE;
            this.dS[x2][4][4][4] = Float.MAX_VALUE;
            this.dH[4][4][4][x2] = Float.MAX_VALUE;
            this.dS[4][4][4][x2] = Float.MAX_VALUE;
            this.dH[x2][4][4][5] = Float.MAX_VALUE;
            this.dS[x2][4][4][5] = Float.MAX_VALUE;
            this.dH[5][4][4][x2] = Float.MAX_VALUE;
            this.dS[5][4][4][x2] = Float.MAX_VALUE;
            this.dH[4][5][x2][4] = Float.MAX_VALUE;
            this.dS[x2][4][4][5] = Float.MAX_VALUE;
            this.dH[4][x2][5][4] = Float.MAX_VALUE;
            this.dS[4][x2][5][4] = Float.MAX_VALUE;
            for (int y2 = 1; y2 <= 4; ++y2) {
                this.dH[4][x2][y2][4] = Float.MAX_VALUE;
                this.dS[4][x2][y2][4] = Float.MAX_VALUE;
                this.dH[x2][4][4][y2] = Float.MAX_VALUE;
                this.dS[x2][4][4][y2] = Float.MAX_VALUE;
                this.dH[x2][4][y2][4] = Float.MAX_VALUE;
                this.dS[x2][4][y2][4] = Float.MAX_VALUE;
                this.dH[x2][5][y2][4] = Float.MAX_VALUE;
                this.dS[x2][5][y2][4] = Float.MAX_VALUE;
                this.dH[x2][4][y2][5] = Float.MAX_VALUE;
                this.dS[x2][4][y2][5] = Float.MAX_VALUE;
                this.dH[5][x2][4][y2] = Float.MAX_VALUE;
                this.dS[5][x2][4][y2] = Float.MAX_VALUE;
                this.dH[4][x2][5][y2] = Float.MAX_VALUE;
                this.dS[4][x2][5][y2] = Float.MAX_VALUE;
                this.dH[x2][5][4][y2] = Float.MAX_VALUE;
                this.dS[x2][5][4][y2] = Float.MAX_VALUE;
                this.dH[x2][4][5][y2] = Float.MAX_VALUE;
                this.dS[x2][4][5][y2] = Float.MAX_VALUE;
                this.dH[5][x2][y2][4] = Float.MAX_VALUE;
                this.dS[5][x2][y2][4] = Float.MAX_VALUE;
                this.dH[4][x2][y2][5] = Float.MAX_VALUE;
                this.dS[4][x2][y2][5] = Float.MAX_VALUE;
            }
        }
        this.dH[4][4][4][4] = Float.MAX_VALUE;
        this.dS[4][4][4][4] = Float.MAX_VALUE;
        this.dH[5][4][4][4] = Float.MAX_VALUE;
        this.dS[5][4][4][4] = Float.MAX_VALUE;
        this.dH[4][4][4][5] = Float.MAX_VALUE;
        this.dS[4][4][4][5] = Float.MAX_VALUE;
        this.dH[4][5][5][4] = Float.MAX_VALUE;
        this.dS[4][5][5][4] = Float.MAX_VALUE;
        float INTERIOR_LOOP_S = 0.0f;
        float INTERIOR_LOOP_H = 0.0f;
        float BULGE_LOOP_S = 0.0f;
        float BULGE_LOOP_H = 0.0f;
        float BULGE_OPEN_MATCH_H = 0.0f;
        float BULGE_OPEN_MATCH_S = 0.0f;
        float BULGE_CLOSE_MATCH_H = 0.0f;
        float BULGE_CLOSE_MATCH_S = 0.0f;
        float BULGE_OPEN_MISMATCH_H = 0.0f;
        float BULGE_OPEN_MISMATCH_S = 0.0f;
        float BULGE_CLOSE_MISMATCH_H = 0.0f;
        float BULGE_CLOSE_MISMATCH_S = 0.0f;
        float dHin = 0.0f;
        float dSin = 0.0f;
        byte[] doubletCode = new byte[4];
        String line = "";
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        while ((line = r.readLine()) != null) {
            String[] substrings;
            if (line.startsWith("#") || (substrings = line.split("\t")).length <= 0) continue;
            String doubletText = substrings[0];
            if (substrings.length > 1) {
                dHin = Float.parseFloat(substrings[1]);
                dSin = Float.parseFloat(substrings[2]);
            }
            if (doubletText.equals("INTERIOR_LOOP")) {
                INTERIOR_LOOP_H = dHin;
                INTERIOR_LOOP_S = dSin;
                continue;
            }
            if (doubletText.equals("BULGE_LOOP")) {
                BULGE_LOOP_H = dHin;
                BULGE_LOOP_S = dSin;
                continue;
            }
            if (doubletText.equals("BULGE_OPEN_MATCH")) {
                BULGE_OPEN_MATCH_H = dHin;
                BULGE_OPEN_MATCH_S = dSin;
                continue;
            }
            if (doubletText.equals("BULGE_OPEN_MISMATCH")) {
                BULGE_OPEN_MISMATCH_H = dHin;
                BULGE_OPEN_MISMATCH_S = dSin;
                continue;
            }
            if (doubletText.equals("BULGE_CLOSE_MATCH")) {
                BULGE_CLOSE_MATCH_H = dHin;
                BULGE_CLOSE_MATCH_S = dSin;
                continue;
            }
            if (doubletText.equals("BULGE_CLOSE_MISMATCH")) {
                BULGE_CLOSE_MISMATCH_H = dHin;
                BULGE_CLOSE_MISMATCH_S = dSin;
                continue;
            }
            doubletCode = this.getByteCode(doubletText);
            this.dH[doubletCode[0]][doubletCode[1]][doubletCode[2]][doubletCode[3]] = dHin;
            this.dS[doubletCode[0]][doubletCode[1]][doubletCode[2]][doubletCode[3]] = dSin;
        }
        r.close();
        for (int x1 = 0; x1 <= 3; ++x1) {
            for (int x2 = 0; x2 <= 3; ++x2) {
                for (int y1 = 0; y1 <= 3; ++y1) {
                    for (int y2 = 0; y2 <= 3; ++y2) {
                        if (x1 + y1 == 3 || x2 + y2 == 3) continue;
                        this.dH[x1][x2][y1][y2] = INTERIOR_LOOP_H;
                        this.dS[x1][x2][y1][y2] = INTERIOR_LOOP_S;
                    }
                }
            }
        }
        for (x = 0; x <= 3; ++x) {
            for (y = 0; y <= 3; ++y) {
                this.dH[x][y][4][4] = BULGE_LOOP_H;
                this.dS[x][y][4][4] = BULGE_LOOP_S;
                this.dH[4][4][x][y] = BULGE_LOOP_H;
                this.dS[4][4][x][y] = BULGE_LOOP_S;
            }
        }
        for (x = 0; x <= 3; ++x) {
            for (y = 0; y <= 3; ++y) {
                for (int a = 0; a <= 3; ++a) {
                    if (x + y == 3) {
                        this.dH[x][4][y][a] = BULGE_OPEN_MATCH_H;
                        this.dS[x][4][y][a] = BULGE_OPEN_MATCH_S;
                        this.dH[x][a][y][4] = BULGE_OPEN_MATCH_H;
                        this.dS[x][a][y][4] = BULGE_OPEN_MATCH_S;
                        this.dH[4][x][a][y] = BULGE_CLOSE_MATCH_H;
                        this.dS[4][x][a][y] = BULGE_CLOSE_MATCH_S;
                        this.dH[a][x][4][y] = BULGE_CLOSE_MATCH_H;
                        this.dS[a][x][4][y] = BULGE_CLOSE_MATCH_S;
                        continue;
                    }
                    this.dH[x][4][y][a] = BULGE_OPEN_MISMATCH_H;
                    this.dS[x][4][y][a] = BULGE_OPEN_MISMATCH_S;
                    this.dH[x][a][y][4] = BULGE_OPEN_MISMATCH_H;
                    this.dS[x][a][y][4] = BULGE_OPEN_MISMATCH_S;
                    this.dH[4][x][a][y] = BULGE_CLOSE_MISMATCH_H;
                    this.dS[4][x][a][y] = BULGE_CLOSE_MISMATCH_S;
                    this.dH[a][x][4][y] = BULGE_CLOSE_MISMATCH_H;
                    this.dS[a][x][4][y] = BULGE_CLOSE_MISMATCH_S;
                }
            }
        }
    }
}

