/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.design.calc;

import java.util.HashMap;
import java.util.Map;
import org.moltools.design.calc.Aligner;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.alignment.Alignment;
import org.moltools.lib.alignment.SimpleAlignment;
import org.moltools.lib.seq.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeedlemanWunchCalculator
extends AbstractParameterHolder
implements Aligner {
    protected static final byte F_GAP = 2;
    protected static final byte S_GAP = 3;
    protected static final byte EXTEND = 4;
    protected transient short[][] scoringTable;
    protected transient short[] gapPenaltyTable;
    protected transient short gapOpenPenalty;
    protected transient short gapExtensionPenalty;
    public transient short[][] resultMatrix;
    protected transient byte[][] traceMatrix;
    protected transient int[] positions;
    protected transient String[] traces;
    protected transient byte[] firstB;
    protected transient byte[] secondB;

    public static char byteToBase(byte b) {
        return (char)b;
    }

    public static final byte basecode(char c) {
        return (byte)c;
    }

    @Override
    public Map<String, String> getDefaultParameters() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("AA", "2");
        p.put("AC", "-1");
        p.put("AG", "-1");
        p.put("AT", "-1");
        p.put("AU", "-1");
        p.put("CA", "-1");
        p.put("CC", "2");
        p.put("CG", "-1");
        p.put("CT", "-1");
        p.put("CU", "-1");
        p.put("GA", "-1");
        p.put("GC", "-1");
        p.put("GG", "2");
        p.put("GT", "-1");
        p.put("GU", "-1");
        p.put("TA", "-1");
        p.put("TC", "-1");
        p.put("TG", "-1");
        p.put("TT", "2");
        p.put("TU", "2");
        p.put("UA", "-1");
        p.put("UC", "-1");
        p.put("UG", "-1");
        p.put("UT", "2");
        p.put("UU", "2");
        p.put("GAP_OPEN_PENALTY", "2");
        p.put("GAP_EXTENSION_PENALTY", "2");
        return p;
    }

    public NeedlemanWunchCalculator() {
        this.parameters = this.getDefaultParameters();
        this.scoringTable = new short[127][127];
        this.traces = new String[2];
        this.positions = new int[4];
        this.gapPenaltyTable = new short[0];
        this.readScores();
    }

    @Override
    public void addParameters(Map<String, String> p) {
        super.addParameters(p);
        this.readScores();
    }

    @Override
    public void setParameters(Map<String, String> p) {
        super.setParameters(p);
        this.readScores();
    }

    protected void readScores() {
        for (byte i = 0; i < this.scoringTable.length; i = (byte)(i + 1)) {
            for (byte j = 0; j < this.scoringTable[i].length; j = (byte)(j + 1)) {
                String s = String.valueOf(NeedlemanWunchCalculator.byteToBase(i)) + String.valueOf(NeedlemanWunchCalculator.byteToBase(j));
                String p = (String)this.parameters.get(s);
                this.scoringTable[i][j] = p == null ? (short)0 : Short.parseShort(p);
            }
        }
        this.gapOpenPenalty = Short.parseShort((String)this.parameters.get("GAP_OPEN_PENALTY"));
        this.gapExtensionPenalty = Short.parseShort((String)this.parameters.get("GAP_EXTENSION_PENALTY"));
    }

    public int getScore(String str1, String str2) {
        int score = 0;
        for (int i = 0; i < str1.length(); ++i) {
            score += this.getMatchScore(NeedlemanWunchCalculator.basecode(str1.charAt(i)), NeedlemanWunchCalculator.basecode(str2.charAt(i)));
        }
        return score;
    }

    public int getHighestCell(int[] pos) {
        if (this.resultMatrix == null) {
            return 0;
        }
        int i = this.resultMatrix.length - 1;
        int j = this.resultMatrix[i].length - 1;
        short maxvalue = this.resultMatrix[i][j];
        pos[0] = i;
        pos[1] = j;
        return maxvalue;
    }

    public short getMatchScore(byte f, byte s) {
        return this.scoringTable[f][s];
    }

    protected int getNWScore(int i, int j, byte[] first, byte[] second) {
        int k;
        short matchscore = this.scoringTable[first[i - 1]][second[j - 1]];
        short extend = i == 0 || j == 0 ? (short)(matchscore - Math.max(i, j)) : (short)(this.resultMatrix[i - 1][j - 1] + matchscore);
        short maxf = -32767;
        for (k = 1; k <= j; ++k) {
            maxf = (short)Math.max(maxf, this.resultMatrix[i][j - k] - this.gapPenaltyTable[k]);
        }
        short gapfirst = maxf;
        short maxs = -32767;
        for (k = 1; k <= i; ++k) {
            maxs = (short)Math.max(maxs, this.resultMatrix[i - k][j] - this.gapPenaltyTable[k]);
        }
        short gapsecond = maxs;
        short max = (short)Math.max(extend, Math.max(gapfirst, gapsecond));
        if (max == extend) {
            this.traceMatrix[i][j] = 4;
        } else if (max == gapfirst) {
            this.traceMatrix[i][j] = 2;
        } else if (max == gapsecond) {
            this.traceMatrix[i][j] = 3;
        }
        return max;
    }

    public static byte[] getByteArray(String seq) {
        byte[] array = new byte[seq.length()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = NeedlemanWunchCalculator.basecode(seq.charAt(i));
        }
        return array;
    }

    public int traceBack() {
        int[] pos = new int[2];
        int length = 0;
        this.getHighestCell(pos);
        int row = pos[0];
        int col = pos[1];
        this.resultMatrix[row][col] = -1;
        int firstend = row;
        int secondend = col;
        String firsttrace = "";
        String secondtrace = "";
        boolean done = false;
        while (!done) {
            switch (this.traceMatrix[row][col]) {
                case 2: {
                    secondtrace = NeedlemanWunchCalculator.byteToBase(this.secondB[col - 1]) + secondtrace;
                    firsttrace = "-" + firsttrace;
                    ++length;
                    --col;
                    break;
                }
                case 3: {
                    firsttrace = NeedlemanWunchCalculator.byteToBase(this.firstB[row - 1]) + firsttrace;
                    secondtrace = "-" + secondtrace;
                    ++length;
                    --row;
                    break;
                }
                case 4: {
                    firsttrace = NeedlemanWunchCalculator.byteToBase(this.firstB[row - 1]) + firsttrace;
                    secondtrace = NeedlemanWunchCalculator.byteToBase(this.secondB[col - 1]) + secondtrace;
                    ++length;
                    --col;
                    --row;
                }
            }
            if (col != 0 || row != 0) continue;
        }
        int firststart = row;
        int secondstart = col;
        this.positions[0] = firststart;
        this.positions[1] = firstend;
        this.positions[2] = secondstart;
        this.positions[3] = secondend;
        this.traces[0] = firsttrace;
        this.traces[1] = secondtrace;
        return length;
    }

    protected void doNeedlemanWunch() {
        int i;
        int longest = Math.max(this.firstB.length, this.secondB.length) + 1;
        if (longest > this.gapPenaltyTable.length) {
            this.gapPenaltyTable = new short[longest];
            for (i = 0; i < this.gapPenaltyTable.length; ++i) {
                this.gapPenaltyTable[i] = i == 0 ? (short)0 : (short)(this.gapOpenPenalty + (i - 1) * this.gapExtensionPenalty);
            }
        }
        this.traceMatrix = new byte[this.firstB.length + 1][this.secondB.length + 1];
        this.resultMatrix = new short[this.firstB.length + 1][this.secondB.length + 1];
        for (i = 0; i < this.resultMatrix.length; ++i) {
            this.resultMatrix[i][0] = -this.gapPenaltyTable[i];
            this.traceMatrix[i][0] = 3;
        }
        for (int j = 0; j < this.resultMatrix[0].length; ++j) {
            this.resultMatrix[0][j] = -this.gapPenaltyTable[j];
            this.traceMatrix[0][j] = 2;
        }
        for (i = 1; i < this.resultMatrix.length; ++i) {
            for (int j = 1; j < this.resultMatrix[i].length; ++j) {
                this.resultMatrix[i][j] = (short)this.getNWScore(i, j, this.firstB, this.secondB);
            }
        }
    }

    @Override
    public void doAlignment(Sequence seq1, Sequence seq2) {
        this.doAlignment(seq1.seqString(), seq2.seqString());
    }

    @Override
    public void doAlignment(String seq1, String seq2) {
        this.firstB = NeedlemanWunchCalculator.getByteArray(seq1);
        this.secondB = NeedlemanWunchCalculator.getByteArray(seq2);
        this.doNeedlemanWunch();
    }

    @Override
    public Alignment getNextAlignment() {
        int length = this.traceBack();
        if (length < 0) {
            throw new UnsupportedOperationException("Length below zero in traceBack()");
        }
        if (length == 0) {
            return null;
        }
        return new SimpleAlignment(this.positions[0] + 1, this.positions[1] + 1, this.traces[0], this.positions[2] + 1, this.positions[3] + 1, this.traces[1]);
    }

    public void printTraceMatrix() {
        System.out.println("Trace:");
        for (int i = 0; i < this.traceMatrix.length; ++i) {
            for (int j = 0; j < this.traceMatrix[i].length; ++j) {
                System.out.print("\t" + this.traceMatrix[i][j]);
            }
            System.out.println();
        }
    }

    public void printResultMatrix() {
        System.out.println("Score:");
        for (int i = 0; i < this.resultMatrix.length; ++i) {
            for (int j = 0; j < this.resultMatrix[i].length; ++j) {
                System.out.print("\t" + this.resultMatrix[i][j]);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        String s2 = "TTGGAATTCAGTTA";
        String s1 = "GGATCGA";
        NeedlemanWunchCalculator nwc = new NeedlemanWunchCalculator();
        nwc.doAlignment(s1, s2);
        nwc.printResultMatrix();
        nwc.printTraceMatrix();
        Alignment la = nwc.getNextAlignment();
        System.out.println(la.getFirstString());
        System.out.println(la.getSecondString());
    }
}

