/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.console;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.apptools.console.Command;

public class DefaultCommand
implements Command {
    protected String command;
    protected String brief;
    protected Command.Option[] options;

    public DefaultCommand(String command, String brief) {
        this(command, brief, new Option[0]);
    }

    public DefaultCommand(String command, String brief, Command.Option[] options) {
        this.command = command;
        this.brief = brief;
        this.options = options;
    }

    public String getName() {
        return this.command;
    }

    public String getBrief() {
        return this.brief;
    }

    public Command.Option[] getOptions() {
        return this.options;
    }

    public Command.Option getOption(String id) {
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].getName().equals(id)) continue;
            return this.options[i];
        }
        return null;
    }

    public void addOption(Command.Option opt) {
        ArrayList<Command.Option> old = new ArrayList<Command.Option>(Arrays.asList(this.options));
        old.add(opt);
        this.options = old.toArray(new Command.Option[old.size()]);
    }

    public void removeOption(Command.Option opt) {
        ArrayList<Command.Option> old = new ArrayList<Command.Option>(Arrays.asList(this.options));
        old.remove(opt);
        this.options = old.toArray(new Command.Option[old.size()]);
    }

    public static class Option
    implements Command.Option {
        protected String name;
        protected String brief;
        protected Command.Option[] options;
        protected boolean strict;

        public Option(String name, String brief, boolean strict) {
            this.name = name;
            this.brief = brief;
            this.strict = strict;
            this.options = new Command.Option[0];
        }

        public Option(String name, String brief, Command.Option[] options) {
            this.name = name;
            this.brief = brief;
            this.strict = true;
            this.options = options;
        }

        public String getName() {
            return this.name;
        }

        public String getBrief() {
            return this.brief;
        }

        public Command.Option[] getOptions() {
            return this.options;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public void addOption(Command.Option opt) {
            ArrayList<Command.Option> old = new ArrayList<Command.Option>(Arrays.asList(this.options));
            old.add(opt);
            this.options = old.toArray(new Command.Option[old.size()]);
        }

        public void removeOption(Command.Option opt) {
            ArrayList<Command.Option> old = new ArrayList<Command.Option>(Arrays.asList(this.options));
            old.remove(opt);
            this.options = old.toArray(new Command.Option[old.size()]);
        }

        public Command.Option getOption(String id) {
            for (int i = 0; i < this.options.length; ++i) {
                if (!this.options[i].getName().equals(id)) continue;
                return this.options[i];
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

