/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AnyPredicate;
import org.moltools.lib.seq.Region;
import org.moltools.lib.seq.impl.SimpleRegion;
import org.moltools.lib.seq.utils.AdjacentRegionPredicate;
import org.moltools.lib.seq.utils.OverlapsRegionPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionUtils {
    public static final Comparator<Region> regionComparator = new Comparator<Region>(){

        @Override
        public int compare(Region o1, Region o2) {
            if (o1.getStart() < o2.getStart()) {
                return -1;
            }
            if (o1.getStart() > o2.getStart()) {
                return 1;
            }
            if (o1.getEnd() < o2.getEnd()) {
                return -1;
            }
            if (o1.getEnd() > o2.getEnd()) {
                return 1;
            }
            return 0;
        }
    };

    public static void sort(List<? extends Region> regions) {
        Collections.sort(regions, regionComparator);
    }

    public static Collection<Region> mergeAdjacent(Collection<? extends Region> regions) {
        ArrayList<Region> merged = new ArrayList<Region>();
        for (Region region : regions) {
            RegionUtils.addRegionWithMerge(merged, region);
        }
        return merged;
    }

    public static Region mergeUnchecked(Collection<? extends Region> merges) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (Region region : merges) {
            min = Math.min(min, region.getStart());
            max = Math.max(max, region.getEnd());
        }
        return new SimpleRegion(min, max);
    }

    public static void addRegionWithMerge(Collection<Region> regions, Region newRegion) {
        Collection merges = CollectionUtils.select(regions, (Predicate)new AnyPredicate(new Predicate[]{new AdjacentRegionPredicate(newRegion), new OverlapsRegionPredicate(newRegion)}));
        regions.removeAll(merges);
        merges.add(newRegion);
        regions.add(RegionUtils.mergeUnchecked(merges));
    }

    public static int getTotalSize(Collection<? extends Region> regions) {
        Collection<Region> merged = RegionUtils.mergeAdjacent(regions);
        int size = 0;
        for (Region r : merged) {
            size += r.length();
        }
        return size;
    }

    public static boolean contains(Region region, int pos) {
        if (region == null) {
            return false;
        }
        return region.getStart() <= pos && pos <= region.getEnd();
    }

    public static boolean equal(Collection<? extends Region> allRegs, Collection<? extends Region> selRegs) {
        if (allRegs.size() != selRegs.size()) {
            return false;
        }
        for (Region region : allRegs) {
            boolean found = false;
            for (Region region2 : selRegs) {
                if (region2.getStart() != region.getStart() || region2.getEnd() != region.getEnd()) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static Region intersection(Region r1, Region r2) {
        int start = Math.max(r1.getStart(), r2.getStart());
        int end = Math.min(r1.getEnd(), r2.getEnd());
        if (end >= start) {
            return new SimpleRegion(start, end);
        }
        return null;
    }

    public static List<Region> getDifference(Region r1, Region r2) {
        Region intersection = RegionUtils.intersection(r1, r2);
        ArrayList<Region> diff = new ArrayList<Region>();
        if (intersection != null && intersection.length() > 0) {
            int s1 = r1.getStart();
            int e1 = intersection.getStart() - 1;
            int s2 = intersection.getEnd() + 1;
            int e2 = r1.getEnd();
            if (s1 <= e1) {
                diff.add(new SimpleRegion(s1, e1));
            }
            if (s2 <= e2) {
                diff.add(new SimpleRegion(s2, e2));
            }
        }
        return diff;
    }

    public static List<Region> getDifference(List<? extends Region> regions1, List<? extends Region> regions2) {
        ArrayList<Region> difference = new ArrayList<Region>();
        for (Region region : regions1) {
            Collection<Region> diff = new ArrayList<Region>();
            Collection<Object> overlaps = new ArrayList(CollectionUtils.select(regions2, (Predicate)new OverlapsRegionPredicate(region)));
            if ((overlaps = RegionUtils.getIntersection(overlaps, Collections.singletonList(region))).isEmpty()) {
                diff.add(region);
            }
            for (Region region2 : overlaps) {
                List<Region> d = RegionUtils.getDifference(region, region2);
                if (diff.isEmpty()) {
                    diff.addAll(d);
                    continue;
                }
                Collection<Region> inter = RegionUtils.getIntersection(diff, d);
                diff = inter;
            }
            difference.addAll(diff);
        }
        return difference;
    }

    public static Map<String, List<Region>> getDifference(Map<String, List<Region>> map1, Map<String, List<Region>> map2) {
        HashMap<String, List<Region>> difference = new HashMap<String, List<Region>>();
        for (String key1 : map1.keySet()) {
            List<Region> l1 = map1.get(key1);
            List<Region> l2 = map2.get(key1);
            if (l2 != null) {
                difference.put(key1, RegionUtils.getDifference(l1, l2));
                continue;
            }
            difference.put(key1, l1);
        }
        return difference;
    }

    public static Collection<Region> getIntersection(Collection<? extends Region> regions1, Collection<? extends Region> regions2) {
        ArrayList<Region> intersection = new ArrayList<Region>();
        for (Region region : regions1) {
            for (Region region2 : regions2) {
                Region i = RegionUtils.intersection(region, region2);
                if (i == null || i.length() <= 0) continue;
                RegionUtils.addRegionWithMerge(intersection, i);
            }
        }
        return intersection;
    }

    public static Map<String, Collection<Region>> getIntersection(Map<String, Collection<? extends Region>> map1, Map<String, Collection<? extends Region>> map2) {
        HashMap<String, Collection<Region>> inter = new HashMap<String, Collection<Region>>();
        for (String key1 : map1.keySet()) {
            Collection<? extends Region> l1 = map1.get(key1);
            Collection<? extends Region> l2 = map2.get(key1);
            if (l2 == null) continue;
            inter.put(key1, RegionUtils.getIntersection(l1, l2));
        }
        return inter;
    }
}

