/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.apptools.textio.DataMapBuilder;
import net.sf.apptools.textio.DataMapInput;
import net.sf.apptools.textio.DataMapOutput;
import net.sf.apptools.textio.ObjectBuilder;
import net.sf.apptools.textio.RecordBuilder;
import net.sf.apptools.textio.StringArrayOutput;
import net.sf.apptools.textio.TextIOUtils;
import net.sf.apptools.textio.TextInputUtils;
import net.sf.apptools.textio.TextOutputUtils;
import org.apache.commons.collections.Transformer;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.SequenceDBBuilder;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.seq.io.SequenceDBDataReader;
import org.moltools.lib.seq.io.SequenceDBInputFormat;
import org.moltools.lib.seq.io.SequenceDBWriter;
import org.moltools.lib.seq.io.SequenceDataReader;
import org.moltools.lib.seq.io.SequenceWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceIO {
    public static final SequenceDBBuilder defaultDBBuilder = ListSequenceDB.getDefaultBuilder();

    public static <S extends Sequence> List<S> readSequences(Reader in, SequenceDBDataReader reader, ObjectBuilder<S> builder) throws IOException, SequenceFormatException {
        List<Map<String, String>> dataMaps = reader.getDataMaps(in);
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (Map<String, String> dataMap : dataMaps) {
            Sequence sequence = (Sequence)builder.buildObject(dataMap);
            sequences.add(sequence);
        }
        return sequences;
    }

    public static <T extends Sequence> List<? extends T> readSequences(Reader in, DataMapInput input, ObjectBuilder<T> builder) throws IOException {
        return TextInputUtils.readObjects((Reader)in, (DataMapInput)input, builder);
    }

    public static <S extends Sequence> DefiniteSequenceDB<S> readSequenceDB(Reader in, SequenceDBDataReader reader, Map<String, Transformer> transforms, SequenceDBBuilder dbBuilder, ObjectBuilder<S> builder) throws IOException, DuplicateIDException, SequenceFormatException {
        SequenceDBBuilder dbbuilder = dbBuilder;
        if (dbbuilder == null) {
            dbbuilder = defaultDBBuilder;
        }
        List<Map<String, String>> maps = reader.getDataMaps(in);
        Collection transformed = TextIOUtils.transformDataMaps(maps, transforms);
        DefiniteSequenceDB<S> db = dbbuilder.buildDB(transformed, builder);
        return db;
    }

    public static <S extends Sequence> DefiniteSequenceDB<S> readSequenceDB(Reader in, SequenceDBDataReader reader, SequenceDBBuilder dbBuilder, ObjectBuilder<S> builder) throws IOException, DuplicateIDException, SequenceFormatException {
        return SequenceIO.readSequenceDB(in, reader, null, dbBuilder, builder);
    }

    public static <S extends Sequence> DefiniteSequenceDB<S> readSequenceDB(Reader in, SequenceDBInputFormat<S> format) throws IOException, DuplicateIDException, SequenceFormatException {
        return SequenceIO.readSequenceDB(in, format.getSequenceDBDataReader(), format.getTransforms(), format.getDBBuilder(), format.getSequenceBuilder());
    }

    public static <S extends Sequence> List<S> readSequences(Reader in, SequenceDataReader formatter, Map<String, Transformer> transforms, ObjectBuilder<S> seqBuilder) throws IOException, SequenceFormatException {
        ArrayList<Object> sequences = new ArrayList<Object>();
        BufferedReader br = new BufferedReader(in);
        Map<String, String> map = null;
        while ((map = formatter.readNextFormattedSequence(br)) != null) {
            Map t = TextIOUtils.transformDataMap(map, transforms);
            sequences.add(seqBuilder.buildObject(t));
        }
        return sequences;
    }

    public static <T extends Sequence> List<T> readSequences(Reader in, SequenceDataReader formatter, ObjectBuilder<T> seqBuilder) throws IOException, SequenceFormatException {
        return SequenceIO.readSequences(in, formatter, null, seqBuilder);
    }

    public static <T extends Sequence> void writeSequences(Writer out, Collection<? extends T> sequences, SequenceWriter<T> formatter) {
        PrintWriter pw = new PrintWriter(out);
        Iterator<T> i = sequences.iterator();
        while (i.hasNext()) {
            formatter.writeSequence(pw, (Sequence)i.next());
        }
        pw.flush();
    }

    public static <T extends Sequence> void writeSequences(Writer out, Collection<? extends T> sequences, StringArrayOutput output, RecordBuilder<T> recordBuilder) {
        TextOutputUtils.writeObjects(sequences, (Writer)out, (StringArrayOutput)output, recordBuilder);
    }

    public static <T extends Sequence> void writeSequences(Writer out, Collection<? extends T> sequences, DataMapOutput output, DataMapBuilder<T> dataMapBuilder) {
        SequenceIO.writeSequences(out, sequences, output, null, dataMapBuilder);
    }

    public static <T extends Sequence> void writeSequences(Writer out, Collection<? extends T> sequences, DataMapOutput output, Map<String, Transformer> transforms, DataMapBuilder<T> dataMapBuilder) {
        TextOutputUtils.writeObjects(sequences, (Writer)out, (DataMapOutput)output, transforms, dataMapBuilder);
    }

    public static <T extends Sequence> void writeSequenceDB(Writer out, DefiniteSequenceDB<? extends T> db, SequenceDBWriter<T> seqDBwriter, Map<?, ?> properties) throws IOException {
        seqDBwriter.putSequenceDB(out, db, properties);
        out.flush();
    }
}

