/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.design;

import java.util.List;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.VariantTarget;
import org.moltools.design.data.impl.TargetGroup;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.ChangeableSequenceDB;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetHandler {
    public static void expandTargets(ChangeableSequenceDB<ProbeMakerTarget> targets) {
        ListSequenceDB temp = new ListSequenceDB();
        for (ProbeMakerTarget target : targets) {
            if (target instanceof VariantTarget) {
                VariantTarget vt = (VariantTarget)target;
                TargetGroup tg = (TargetGroup)DesignUtils.getGroupWithType((PropertyHolder)vt, (String)"moltools.targetGroup");
                if (tg == null) {
                    tg = new TargetGroup(vt.getID());
                    List<? extends ProbeMakerTarget> nts = vt.expand();
                    if (nts.size() <= 1) {
                        try {
                            temp.addSequence((Sequence)vt);
                            continue;
                        }
                        catch (DuplicateIDException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    for (ProbeMakerTarget nt : nts) {
                        tg.addMember((Object)nt);
                        try {
                            temp.addSequence((Sequence)nt);
                        }
                        catch (DuplicateIDException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    continue;
                }
                try {
                    temp.addSequence((Sequence)target);
                    continue;
                }
                catch (DuplicateIDException e) {
                    throw new RuntimeException(e);
                }
            }
            if (target == null) continue;
            try {
                temp.addSequence((Sequence)target);
            }
            catch (DuplicateIDException e) {
                throw new RuntimeException(e);
            }
        }
        targets.clear();
        try {
            targets.addSequences((DefiniteSequenceDB)temp);
        }
        catch (DuplicateIDException e) {
            throw new RuntimeException(e);
        }
    }
}

