/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DataHolderUtils;
import org.apache.commons.beanutils.Converter;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.moltools.apps.probemaker.design.CandidateAnalysisModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.project.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsXMLHandler {
    static Namespace ns = Namespace.getNamespace((String)"pr", (String)"http://probemaker.sourceforge.net/");
    public static final String SETTINGS = "settings";
    public static final String PARAMETERS = "parameters";
    public static final String PARAM = "param";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String MODULES1 = "modulesStage1";
    public static final String MODULES2 = "modulesStage2";
    public static final String MODULES3 = "modulesStage3";
    public static final String MODULE = "module";
    public static final String CLASS = "class";
    public static final String NAME = "name";
    private static final String DATA_LIST = "dataList";
    private static final String TEST_LIST = "testList";
    private static final String TEST = "test";
    private static final String DO_TEST = "perform";

    public static Element getSettingsElement(String name, Settings s) {
        Element settingsE = new Element(name, ns);
        List<CandidateAnalysisModule> modules1 = s.getArmModules();
        List<CandidateAnalysisModule> modules2 = s.getCandidateModulesStage1();
        List<CandidateAnalysisModule> modules3 = s.getCandidateModulesStage2();
        Map<String, String> props = s.getDesignParameters();
        Element moduleList1 = new Element(MODULES1, ns);
        Element moduleList2 = new Element(MODULES2, ns);
        Element moduleList3 = new Element(MODULES3, ns);
        Element propsList = new Element(PARAMETERS, ns);
        Iterator<Object> i = modules1.iterator();
        while (i.hasNext()) {
            moduleList1.addContent((Content)SettingsXMLHandler.getModuleElement(i.next()));
        }
        i = modules2.iterator();
        while (i.hasNext()) {
            moduleList2.addContent((Content)SettingsXMLHandler.getModuleElement(i.next()));
        }
        i = modules3.iterator();
        while (i.hasNext()) {
            moduleList3.addContent((Content)SettingsXMLHandler.getModuleElement(i.next()));
        }
        for (String key : props.keySet()) {
            String value = props.get(key).toString();
            propsList.addContent((Content)new Element(PARAM, ns).setAttribute(KEY, key, ns).setAttribute(VALUE, value, ns));
        }
        settingsE.addContent((Content)moduleList1);
        settingsE.addContent((Content)moduleList2);
        settingsE.addContent((Content)moduleList3);
        settingsE.addContent((Content)propsList);
        return settingsE;
    }

    public static Settings getSettings(Element settingsE) {
        Settings s = new Settings();
        List mod1Es = settingsE.getChild(MODULES1, ns).getChildren();
        List mod2Es = settingsE.getChild(MODULES2, ns).getChildren();
        List mod3Es = settingsE.getChild(MODULES3, ns).getChildren();
        try {
            Collection<CandidateAnalysisModule> mod1s = SettingsXMLHandler.getModules(mod1Es);
            Collection<CandidateAnalysisModule> mod2s = SettingsXMLHandler.getModules(mod2Es);
            Collection<CandidateAnalysisModule> mod3s = SettingsXMLHandler.getModules(mod3Es);
            Iterator<CandidateAnalysisModule> i = mod1s.iterator();
            while (i.hasNext()) {
                s.addArmModule(i.next());
            }
            i = mod2s.iterator();
            while (i.hasNext()) {
                s.addCandidateModuleStage1(i.next());
            }
            i = mod3s.iterator();
            while (i.hasNext()) {
                s.addCandidateModuleStage2(i.next());
            }
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Could not find module class: " + ex.getMessage());
        }
        catch (InstantiationException ex) {
            System.err.println("Could not instantiate module class: " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            System.err.println("Could not access module class: " + ex.getMessage());
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Element paramE = settingsE.getChild(PARAMETERS, ns);
        for (Element e : paramE.getChildren(PARAM, ns)) {
            String key = e.getAttributeValue(KEY, ns);
            String value = e.getAttributeValue(VALUE, ns);
            parameters.put(key, value);
        }
        s.addDesignerProperties(parameters);
        return s;
    }

    static Collection<CandidateAnalysisModule> getModules(Collection<Element> modElements) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ArrayList<CandidateAnalysisModule> l = new ArrayList<CandidateAnalysisModule>();
        for (Element modE : modElements) {
            Class<?> c = Class.forName(modE.getAttributeValue(CLASS, ns));
            CandidateAnalysisModule am = (CandidateAnalysisModule)c.newInstance();
            for (Element parE : modE.getChild(DATA_LIST, ns).getChildren(PARAM, ns)) {
                String key = parE.getAttributeValue(KEY, ns);
                String valueString = parE.getAttributeValue(VALUE, ns);
                DataDescriptor dd = DataHolderUtils.getDescriptorForKey((DataHolder)am, (String)key);
                Converter toValueConverter = DataHolderUtils.getToValueConverter((DataDescriptor)dd);
                if (toValueConverter == null) {
                    throw new IllegalArgumentException("No converter found for " + dd.getClass());
                }
                am.setData(key, toValueConverter.convert(dd.getDataType(), (Object)valueString));
            }
            for (Element parE : modE.getChild(TEST_LIST, ns).getChildren(TEST, ns)) {
                String name = parE.getAttributeValue(NAME, ns);
                String perform = parE.getAttributeValue(DO_TEST, ns);
                TestDescriptor[] tests = am.getAllTests();
                for (int t = 0; t < tests.length; ++t) {
                    if (!tests[t].getBrief().equals(name)) continue;
                    tests[t].setPerform(Boolean.valueOf(perform));
                }
            }
            l.add(am);
        }
        return l;
    }

    static Element getModuleElement(CandidateAnalysisModule am) {
        Element e = new Element(MODULE, ns);
        e.setAttribute(CLASS, am.getClass().getName(), ns);
        Element dataList = new Element(DATA_LIST, ns);
        for (String key : am.getData().keySet()) {
            String value = am.getData(key).toString();
            dataList.addContent((Content)new Element(PARAM, ns).setAttribute(KEY, key, ns).setAttribute(VALUE, value, ns));
        }
        Element testList = new Element(TEST_LIST, ns);
        TestDescriptor[] tests = am.getAllTests();
        for (int i = 0; i < tests.length; ++i) {
            testList.addContent((Content)new Element(TEST, ns).setAttribute(NAME, tests[i].getBrief(), ns).setAttribute(DO_TEST, String.valueOf(tests[i].perform()), ns));
        }
        e.addContent((Content)dataList);
        e.addContent((Content)testList);
        return e;
    }
}

