/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.project;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.moltools.apps.probemaker.project.ProjectTemplate;
import org.moltools.apps.probemaker.project.TemplateIO;
import org.moltools.apps.probemaker.project.TemplateManagerListener;

public class TemplateManager {
    TemplateIO io;
    File store;
    List<ProjectTemplate> templates = new ArrayList<ProjectTemplate>();
    List<TemplateManagerListener> listeners = new ArrayList<TemplateManagerListener>();

    public void setFile(File store) {
        this.store = store;
    }

    public void setIO(TemplateIO io) {
        this.io = io;
    }

    public void loadTemplates() throws IOException, BackingStoreException {
        if (this.store == null) {
            this.templates = new ArrayList<ProjectTemplate>();
        } else {
            FileReader in = new FileReader(this.store);
            this.templates = this.io.loadProjectTemplates(in);
            ((Reader)in).close();
        }
    }

    public void saveTemplates() throws IOException, BackingStoreException {
        FileWriter out = new FileWriter(this.store);
        this.io.saveProjectTemplates(out, this.templates);
        ((Writer)out).close();
    }

    public int getTemplateCount() {
        return this.templates.size();
    }

    public ProjectTemplate[] getTemplateArray() {
        return this.templates.toArray(new ProjectTemplate[this.templates.size()]);
    }

    public ProjectTemplate getTemplate(int index) {
        return this.templates.get(index);
    }

    public void addTemplate(ProjectTemplate template) {
        this.templates.add(template);
        this.fireChange();
    }

    public void removeTemplate(int index) {
        this.templates.remove(index);
        this.fireChange();
    }

    void fireChange() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).templatesChanged();
        }
    }

    public void addListener(TemplateManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TemplateManagerListener listener) {
        this.listeners.remove(listener);
    }
}

