/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.project;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.moltools.apps.probemaker.project.ProjectTemplate;
import org.moltools.apps.probemaker.project.TemplateIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateXMLHandler
implements TemplateIO {
    static Namespace ns = Namespace.getNamespace((String)"pr", (String)"http://probemaker.sourceforge.net/");
    static final String TEMPLATE_LIST = "templateList";
    static final String TEMPLATE = "template";
    static final String NAME = "name";
    static final String CLASS = "class";
    static final String FILE = "file";
    static final String DESCRIPTION = "description";
    static final String TARGET = "target";
    static final String CONVERTER = "converter";
    static final String FORMAT = "format";
    static final String DBBUILDER = "dbBuilder";
    static final String SETTINGS = "settings";

    @Override
    public List<ProjectTemplate> loadProjectTemplates(Reader in) throws IOException {
        try {
            SAXBuilder sb = new SAXBuilder();
            sb.setValidation(false);
            Document doc = sb.build(in);
            return TemplateXMLHandler.getTemplateList(doc.getRootElement());
        }
        catch (JDOMException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public void saveProjectTemplates(Writer out, List<? extends ProjectTemplate> templates) throws IOException {
        Document doc = new Document();
        doc.setRootElement(TemplateXMLHandler.getTemplateListElement(TEMPLATE_LIST, templates));
        new XMLOutputter(Format.getPrettyFormat()).output(doc, out);
    }

    static Element getTemplateListElement(String name, List<? extends ProjectTemplate> templates) {
        Element e = new Element(name, ns);
        for (ProjectTemplate projectTemplate : templates) {
            e.addContent((Content)TemplateXMLHandler.getTemplateElement(projectTemplate));
        }
        return e;
    }

    static List<ProjectTemplate> getTemplateList(Element templateListE) {
        ArrayList<ProjectTemplate> templates = new ArrayList<ProjectTemplate>();
        for (Element e : templateListE.getChildren(TEMPLATE, ns)) {
            ProjectTemplate pt = TemplateXMLHandler.getTemplate(e);
            templates.add(pt);
        }
        return templates;
    }

    static Element getTemplateElement(ProjectTemplate template) {
        Element e = new Element(TEMPLATE, ns);
        e.setAttribute(NAME, template.getName(), ns);
        e.addContent((Content)new Element(DESCRIPTION, ns).setText(template.getDescription()));
        e.addContent((Content)new Element(TARGET, ns).setAttribute(CLASS, template.getTargetClassName(), ns));
        e.addContent((Content)new Element(CONVERTER, ns).setAttribute(CLASS, template.getConverterClassName(), ns));
        e.addContent((Content)new Element(FORMAT, ns).setAttribute(CLASS, template.getFormatClassName(), ns));
        e.addContent((Content)new Element(DBBUILDER, ns).setAttribute(CLASS, template.getDbBuilderClassName(), ns));
        e.addContent((Content)new Element(SETTINGS, ns).setAttribute(FILE, template.getSettingsFileName(), ns));
        return e;
    }

    static ProjectTemplate getTemplate(Element templateE) {
        ProjectTemplate temp = new ProjectTemplate();
        temp.setName(templateE.getAttributeValue(NAME, ns));
        temp.setDescription(templateE.getChildText(DESCRIPTION, ns));
        temp.setTargetClassName(templateE.getChild(TARGET, ns).getAttributeValue(CLASS, ns));
        temp.setConverterClassName(templateE.getChild(CONVERTER, ns).getAttributeValue(CLASS, ns));
        temp.setFormatClassName(templateE.getChild(FORMAT, ns).getAttributeValue(CLASS, ns));
        temp.setDbBuilderClassName(templateE.getChild(DBBUILDER, ns).getAttributeValue(CLASS, ns));
        String sFile = templateE.getChild(SETTINGS, ns).getAttributeValue(FILE, ns);
        temp.setSettingsFileName(sFile);
        return temp;
    }
}

