/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import javax.swing.table.AbstractTableModel;
import net.genefront.piecemaker.model.CutResults;
import net.genefront.piecemaker.model.FragmentSet;
import net.genefront.piecemaker.utils.CutResultsEvaluator;

public class CutResultsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private CutResults results;
    private byte mode;
    private boolean acceptedOnly = false;
    public static final byte ENZYME_MODE = 0;
    public static final byte TARGET_MODE = 1;
    protected String[] columnNames = new String[]{"Reaction", "Target"};

    public void setResults(CutResults cutResults, byte _mode, boolean acceptedonly) {
        this.results = cutResults;
        this.acceptedOnly = acceptedonly;
        this.mode = _mode;
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        if (this.results == null) {
            return 0;
        }
        switch (this.mode) {
            case 0: {
                return this.results.getReactionCount();
            }
            case 1: {
                return this.results.getTargetCount();
            }
        }
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return this.columnNames[this.mode];
        }
        return "Couples with " + (this.acceptedOnly ? "accepted" : "") + " fragments";
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range");
        }
        if (columnIndex < 0 || columnIndex > this.getColumnCount() - 1) {
            throw new IllegalArgumentException("Column index out of range");
        }
        if (columnIndex == 0) {
            return this.mode == 0 ? (this.results.getReactionNames()[rowIndex] == null ? null : this.results.getReactionNames()[rowIndex]) : (this.results.getTargetIDs()[rowIndex] == null ? null : this.results.getTargetIDs()[rowIndex]);
        }
        return new Integer(CutResultsEvaluator.getSetsWithFragments((FragmentSet[])(this.mode == 0 ? this.results.getReactionResults(rowIndex) : this.results.getTargetResults(rowIndex))).size());
    }

    public byte getMode() {
        return this.mode;
    }

    public void switchMode() {
        this.mode = this.mode == 1 ? (byte)0 : 1;
        this.fireTableStructureChanged();
    }
}

