/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.genefront.piecemaker.model.SelectorTarget;
import net.genefront.piecemaker.utils.PropertyUtils;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2807436623290246189L;
    protected String[] columns = new String[]{"Name", "ROI Start", "ROI End", "ROI Length"};
    protected List<SelectorTarget> targets = new ArrayList<SelectorTarget>();

    public void setTargets(List<SelectorTarget> targets) {
        this.targets = targets;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.targets.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.columns[col];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.targets.size() - 1) {
            throw new IllegalArgumentException("Row index out of range");
        }
        SelectorTarget ts = this.targets.get(rowIndex);
        Region targetRegion = PropertyUtils.getTargetRegion((PropertyHolder)ts);
        switch (columnIndex) {
            case 0: {
                return ts.getID();
            }
            case 1: {
                return new Integer(targetRegion.getStart());
            }
            case 2: {
                return new Integer(targetRegion.getEnd());
            }
            case 3: {
                return new Integer(targetRegion.length());
            }
        }
        throw new IllegalArgumentException("Column index out of range");
    }
}

