/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import javax.swing.table.AbstractTableModel;
import net.genefront.piecemaker.model.MutableFragmentSet;
import net.genefront.piecemaker.restriction.RestrictionEnzyme;

public class CutFragmentTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    MutableFragmentSet[] sets;
    RestrictionEnzyme[] enzymes;
    boolean acceptedOnly;
    byte mode;
    protected String[] columns = new String[]{"ID", "Fragment count"};

    public void setFragmentSets(MutableFragmentSet[] sets, byte mode, boolean acceptedOnly, RestrictionEnzyme[] enzymes) {
        this.sets = sets;
        this.enzymes = enzymes;
        this.acceptedOnly = acceptedOnly;
        this.mode = mode;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.sets.length;
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return this.mode == 0 ? "Target" : "Reaction";
        }
        return this.columns[col];
    }

    public MutableFragmentSet getMutableFragmentSet(int row) {
        return this.sets[row];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.sets.length - 1) {
            throw new IllegalArgumentException("Row index out of range");
        }
        MutableFragmentSet fs = this.sets[rowIndex];
        switch (columnIndex) {
            case 0: {
                return this.mode == 0 ? fs.getID() : this.enzymes[rowIndex].getName();
            }
            case 1: {
                return this.acceptedOnly ? new Integer(fs.size()) : new Integer(fs.size());
            }
        }
        throw new IllegalArgumentException("Column index out of range");
    }

    public boolean isAcceptedOnly() {
        return this.acceptedOnly;
    }
}

