/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import javax.swing.table.AbstractTableModel;
import net.genefront.piecemaker.model.FragmentSet;
import net.genefront.piecemaker.model.TargetFragment;
import net.genefront.piecemaker.utils.PropertyUtils;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.Region;

public class FragmentSetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected String[] columns = new String[]{"Fragment", "Polarity", "Start", "End", "Fragment length", "ROI start", "ROI end", "C(0)", "Last possible cut", "p", "C(p)"};
    protected FragmentSet model;

    public void setModel(FragmentSet set) {
        this.model = set;
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.model.size();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public String getColumnName(int col) {
        return this.columns[col];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex > this.getRowCount() - 1) {
            throw new IllegalArgumentException("Row index out of range");
        }
        TargetFragment tf = this.model.getFragment(rowIndex);
        Region targetRegion = PropertyUtils.getTargetRegion((PropertyHolder)tf);
        int endoPos = PropertyUtils.getEndoPosition((PropertyHolder)tf);
        switch (columnIndex) {
            case 0: {
                return tf.getID();
            }
            case 1: {
                return tf.getPolarity() == 1 ? "+" : "-";
            }
            case 2: {
                return new Integer(tf.getStart());
            }
            case 3: {
                return new Integer(tf.getEnd());
            }
            case 4: {
                return new Integer(tf.length());
            }
            case 5: {
                return new Integer(targetRegion.getStart());
            }
            case 6: {
                return new Integer(targetRegion.getEnd());
            }
            case 7: {
                return new Integer(targetRegion.length());
            }
            case 8: {
                return new Integer(PropertyUtils.getLastPossibleSite((PropertyHolder)tf));
            }
            case 9: {
                return new Integer(endoPos);
            }
            case 10: {
                return new Integer(endoPos < 0 ? 0 : PropertyUtils.getSelectableContent((TargetFragment)tf));
            }
        }
        throw new IllegalArgumentException("Column index out of range");
    }
}

