/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import net.genefront.piecemaker.gui.DisplayContext;
import net.genefront.piecemaker.gui.SequenceLineRenderer;
import net.genefront.piecemaker.model.TargetFragment;
import net.genefront.piecemaker.utils.PropertyUtils;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.Polar;
import org.moltools.lib.seq.impl.SimpleRegion;

public class TargetFragmentRenderer
implements SequenceLineRenderer {
    int height = 5;
    int top = 1;
    int bottom = 1;
    Color lineColor;
    Color fillColor;
    Color fillColor2;

    public TargetFragmentRenderer(int height, int top, int bottom, Color line, Color fill, Color fill2) {
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.lineColor = line;
        this.fillColor = fill;
        this.fillColor2 = fill2;
    }

    public int getHeight(DisplayContext dc, Object obj) {
        return this.height + this.top + this.bottom;
    }

    public int getRequestedHead(DisplayContext dc, Object obj) {
        return 0;
    }

    public int getRequestedTail(DisplayContext dc, Object obj) {
        return 0;
    }

    public void paint(Graphics g, DisplayContext dc, Object obj) {
        TargetFragment tf = (TargetFragment)obj;
        int cPos = PropertyUtils.getEndoPosition((PropertyHolder)tf);
        SimpleRegion sel = new SimpleRegion(Math.max(cPos, 1), tf.length());
        if (obj instanceof Polar && ((Polar)obj).getPolarity() == -1) {
            sel = new SimpleRegion(tf.length() - sel.getEnd() + 1, tf.length() - sel.getStart() + 1);
        }
        int x1 = dc.getPixel(tf.getStart());
        int x2 = dc.getPixel(tf.getEnd());
        int x3 = dc.getPixel(tf.getStart() + sel.getStart() - 1);
        int x4 = dc.getPixel(tf.getStart() + sel.getEnd() - 1);
        Color old = g.getColor();
        g.setColor(this.fillColor);
        g.fillRect(x1, this.top, x2 - x1, this.height - 1);
        g.setColor(this.fillColor2);
        g.fillRect(x3, this.top, x4 - x3, this.height - 1);
        g.setColor(this.lineColor);
        g.drawRect(x1, this.top, x2 - x1, this.height - 1);
        Polygon p = tf.getPolarity() == 1 ? new Polygon(new int[]{x2 + 1, x2 + this.height / 2 + 1, x2 + 1}, new int[]{this.top, this.top + this.height / 2, this.top + this.height - 1}, 3) : new Polygon(new int[]{x1 - 1, x1 - this.height / 2 - 1, x1 - 1}, new int[]{this.top, this.top + this.height / 2, this.top + this.height - 1}, 3);
        g.drawPolygon(p);
        g.fillPolygon(p);
        g.setColor(old);
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setTop(int top) {
        this.top = top;
    }
}

