/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.plugin.PlugInManager;
import net.sf.apptools.plugin.PlugInManagerListener;
import net.sf.apptools.ui.swing.SwingUITexts;
import net.sf.apptools.ui.swing.plugin.PlugInDescriptionMouseListener;
import net.sf.apptools.ui.swing.plugin.PlugInRenderer;

public class PlugInListView
extends JPanel
implements PlugInManagerListener {
    private static final long serialVersionUID = 1L;
    PlugInListModel model;
    String identifier;

    public PlugInListView(final PlugInManager manager, String id) {
        super(new BorderLayout());
        String description;
        ArrayList plugins;
        this.identifier = id;
        try {
            plugins = new ArrayList(manager.getPlugInList(this.identifier));
        }
        catch (PlugInException e) {
            plugins = new ArrayList();
        }
        try {
            description = manager.getPlugInDescription(this.identifier);
        }
        catch (PlugInException e) {
            description = SwingUITexts.getString("PlugInListView.NO_DESCRIPTION");
        }
        this.model = new PlugInListModel(plugins);
        manager.addListener((PlugInManagerListener)this);
        final JList<Object> list = new JList<Object>(this.model);
        list.setCellRenderer(new PlugInRenderer(SwingUITexts.getString("PlugInListView.TEXT_VIEW_PLUG_IN_DESCRIPTION")));
        list.addMouseListener(new PlugInDescriptionMouseListener(list));
        AbstractAction remove = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int[] rows = list.getSelectedIndices();
                Arrays.sort(rows);
                for (int i = rows.length - 1; i >= 0; --i) {
                    try {
                        Class c = (Class)PlugInListView.this.model.getElementAt(rows[i]);
                        manager.removePlugIn(PlugInListView.this.identifier, c);
                        continue;
                    }
                    catch (PlugInException ex) {
                        JOptionPane.showMessageDialog(list, (Object)ex);
                    }
                }
            }
        };
        list.getInputMap(1).put(KeyStroke.getKeyStroke("DELETE"), "remove");
        list.getActionMap().put("remove", remove);
        JLabel label = new JLabel(description);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        label.setFont(label.getFont().deriveFont(1));
        this.add((Component)label, "First");
        this.add((Component)new JScrollPane(list), "Center");
    }

    public void plugInsChanged(PlugInManager source) {
        try {
            Collection plugins = source.getPlugInList(this.identifier);
            this.model.data.clear();
            this.model.data.addAll(plugins);
            this.model.fireContentsChanged(this, 0, this.model.getSize() - 1);
        }
        catch (PlugInException plugInException) {
            // empty catch block
        }
    }

    public void plugInTypesChanged(PlugInManager pim) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PlugInListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        List<Class<?>> data;

        PlugInListModel(List<Class<?>> data) {
            this.data = data;
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(index);
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }
    }
}

