/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.utils.HTMLRenderer;

public class HTMLViewPanel
extends JPanel {
    protected JEditorPane e;
    protected String title;

    public HTMLViewPanel(File f) {
        this.title = f.getName();
        try {
            this.e = new JEditorPane("file:" + f.getAbsolutePath());
        }
        catch (IOException iox) {
            iox.printStackTrace();
            JOptionPane.showMessageDialog(this, iox.getMessage(), PlatformTexts.getString((String)"Common.TITLE_EXCEPTION"), 0);
            this.e = new JEditorPane("text/html", iox.toString());
        }
        this.setup();
    }

    public HTMLViewPanel(Object obj, HTMLRenderer f) {
        boolean can = f.canRenderHTML(obj);
        this.title = can ? f.getHTMLContainerTitle(obj) : "No renderer found";
        String header = "<html>\n<head title=\"" + this.title + "\"></head>\n<body>\n";
        String content = can ? f.renderHTML(obj) : "No renderer found";
        String footer = "</body>\n</html>";
        this.e = new JEditorPane("text/html", header + content + footer);
        this.setup();
    }

    public HTMLViewPanel(String title, String str) {
        this.title = title;
        this.e = new JEditorPane("text/html", str);
        this.setup();
    }

    private void setup() {
        this.e.setCaretPosition(0);
        this.e.setEditable(false);
        this.e.setBackground(this.getBackground());
        JScrollPane p = new JScrollPane(this.e);
        this.setLayout(new BorderLayout());
        this.add((Component)p, "Center");
    }

    public String getTitle() {
        return this.title;
    }
}

