/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.ui.swing.SwingUITexts;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import net.sf.apptools.ui.swing.utils.ListView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    Action okAction;
    Action cancelAction;
    JButton okButton;
    JButton cancelButton;
    protected JPanel buttonPane;
    protected ListView listView;
    protected JPanel mainPane;
    int selected;

    public ListSelectionDialog(Dialog owner, String title, String message, String tooltip, List<?> options, ListCellRenderer renderer) throws HeadlessException {
        super(owner, title, true);
        this.init(options, message, tooltip, renderer);
    }

    public ListSelectionDialog(Frame owner, String title, String message, String tooltip, List<?> options, ListCellRenderer renderer) throws HeadlessException {
        super(owner, title, true);
        this.init(options, message, tooltip, renderer);
    }

    void init(List<?> options, String message, String tooltip, ListCellRenderer renderer) {
        this.setDefaultCloseOperation(0);
        this.listView = new ListView(message, tooltip, options, renderer, false);
        final JList list = this.listView.getList();
        final ListSelectionDialog comp = this;
        this.okAction = new AbstractAction(PlatformTexts.getString((String)"Common.CAPTION_OK")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ListSelectionDialog.this.selected = list.getSelectedIndex();
                if (ListSelectionDialog.this.selected < 0) {
                    JOptionPane.showMessageDialog(comp, SwingUITexts.getString("ListSelectionDialog.MESSAGE_NO_SELECTION"), PlatformTexts.getString((String)"ListSelectionDialog.TITLE_NO_SELECTION"), -1);
                } else {
                    ListSelectionDialog.this.dispose();
                }
            }
        };
        this.cancelAction = new AbstractAction(PlatformTexts.getString((String)"Common.CAPTION_CANCEL")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ListSelectionDialog.this.selected = -1;
                ListSelectionDialog.this.dispose();
            }
        };
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ListSelectionDialog.this.selected = list.getSelectedIndex();
                    ListSelectionDialog.this.dispose();
                }
            }
        });
        this.okButton = new JButton(this.okAction);
        this.cancelButton = new JButton(this.cancelAction);
        this.buttonPane = new JPanel(new FlowLayout(2));
        this.buttonPane.add(this.okButton);
        this.buttonPane.add(this.cancelButton);
        this.mainPane = new JPanel(new BorderLayout());
        this.mainPane.add((Component)this.listView, "Center");
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buttonPane, "South");
        this.getContentPane().add((Component)this.mainPane, "Center");
        this.pack();
        this.setLocation(GUIUtils.suggestLocation(this, GUIUtils.getParentFrame(this)));
    }

    public int getSelectedIndex() {
        return this.selected;
    }
}

