/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench;

import java.text.MessageFormat;
import java.text.NumberFormat;
import net.sf.apptools.utils.AbstractDelegateHTMLRenderer;
import net.sf.apptools.utils.HTMLRenderer;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.moltools.lib.Identifiable;
import org.moltools.lib.Named;
import org.moltools.lib.seq.CompositeSequence;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.utils.SymbolContent;
import org.moltools.workbench.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceHTMLRenderer
extends AbstractDelegateHTMLRenderer {
    protected int width = 60;
    protected static NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private boolean showID = true;
    private boolean showName = true;
    private boolean showSeq = true;
    private boolean showLength = true;
    private boolean showPolys = true;
    private boolean showBlocks = true;
    private boolean showSymbolCount = true;

    public SequenceHTMLRenderer(HTMLRenderer delegateRenderer) {
        super(delegateRenderer);
    }

    protected boolean canRenderHTMLInternal(Object o) {
        return o instanceof Sequence;
    }

    protected String renderHTMLInternal(Object obj) {
        Element root = new Element("sequence");
        Sequence seq = (Sequence)obj;
        if (this.showID) {
            this.addIDHeader(root, (Identifiable)seq);
        }
        if (this.showName && seq instanceof Named) {
            this.addName(root, (Named)seq);
        }
        if (this.showSeq) {
            this.addSequenceString(root, seq);
        }
        if (this.showLength && seq instanceof NucleotideSequence) {
            this.addLengthData(root, (NucleotideSequence)seq);
        }
        if (this.showPolys && seq instanceof NucleotideSequence) {
            this.addPolyData(root, (NucleotideSequence)seq);
        }
        if (this.isShowBlocks() && seq instanceof CompositeSequence) {
            this.addBlocks(root, (CompositeSequence<? extends NucleotideSequence>)((CompositeSequence)seq));
        }
        if (this.showSymbolCount) {
            this.addSymbolCount(root, seq);
        }
        String str = new XMLOutputter(Format.getPrettyFormat()).outputString(root);
        return str;
    }

    protected void addBlocks(Element root, CompositeSequence<? extends NucleotideSequence> p) {
        Element h4 = new Element("h4");
        h4.addContent("Subsequences");
        Element table = new Element("table");
        table.setAttribute("border", "0");
        table.setAttribute("cellspacing", "0");
        table.setAttribute("cellpadding", "0");
        for (int i = 1; i <= p.getSequenceCount(); ++i) {
            NucleotideSequence block = (NucleotideSequence)p.getSequence(i);
            Element tr = new Element("tr");
            tr.setAttribute("align", "left");
            Element th = new Element("th");
            th.setAttribute("align", "left");
            th.addContent(block.getID() + ": ");
            Element td = new Element("td");
            Element tt = new Element("tt");
            tt.addContent(block.seqString());
            td.addContent((Content)tt);
            tr.addContent((Content)th);
            tr.addContent((Content)td);
            table.addContent((Content)tr);
        }
        root.addContent((Content)h4);
        root.addContent((Content)table);
    }

    protected String getHTMLContainerTitleInternal(Object obj) {
        return ((Sequence)obj).getID();
    }

    protected void addPolyData(Element root, NucleotideSequence seq) {
        Object[] args = new Object[]{new Integer(NucleotideSequenceHandler.countPolys((NucleotideSequence)seq))};
        String str = MessageFormat.format(Messages.getString("SequenceHTMLRenderer.TEXT_POLYMORPHISM_COUNT"), args);
        this.addParagraphText(root, str);
    }

    protected void addSymbolCount(Element root, Sequence seq) {
        Element h4 = new Element("h4");
        h4.addContent(Messages.getString("SequenceHTMLRenderer.TEXT_BASE_COMPOSITION"));
        SymbolContent.SymbolContentEntry[] bases = SymbolContent.getSymbolContent((Sequence)seq);
        Element table = new Element("table");
        table.setAttribute("border", "1");
        table.setAttribute("cellspacing", "0");
        table.setAttribute("cellpadding", "0");
        Element header = new Element("tr");
        for (int i = 0; i < bases.length; ++i) {
            Element th = new Element("th");
            th.addContent(bases[i].symbol);
            header.addContent((Content)th);
        }
        table.addContent((Content)header);
        Element content = new Element("tr");
        for (int i = 0; i < bases.length; ++i) {
            Element th = new Element("td");
            th.addContent(percentFormat.format(bases[i].fraction));
            content.addContent((Content)th);
        }
        table.addContent((Content)content);
        root.addContent((Content)h4);
        root.addContent((Content)table);
    }

    protected void addLengthData(Element root, NucleotideSequence ntseq) {
        Object[] args = new Object[]{new Integer(ntseq.length()), NucleotideSequenceHandler.getTypeString((byte)ntseq.getType())};
        String str = MessageFormat.format(Messages.getString("SequenceHTMLRenderer.TEXT_NUCLEOTIDES_LENGTH_TYPE"), args);
        this.addParagraphText(root, str);
    }

    protected void addName(Element root, Named named) {
        Element e = new Element("b");
        String name = named.getName();
        e.addContent(name == null || name == "" ? Messages.getString("SequenceHTMLRenderer.NO_ID") : name);
        root.addContent((Content)e);
    }

    protected void addIDHeader(Element root, Identifiable idd) {
        Element header = new Element("h3");
        String id = idd.getID();
        header.addContent(id == null || id == "" ? Messages.getString("SequenceHTMLRenderer.NO_NAME") : id);
        root.addContent((Content)header);
    }

    protected void addSequenceString(Element root, Sequence seq) {
        Element seqString = new Element("pre");
        String str = SequenceHTMLRenderer.getHardWrappedString(seq.seqString(), this.width);
        seqString.addContent(str);
        root.addContent((Content)seqString);
    }

    protected void addParagraphText(Element root, String text) {
        Element e = new Element("p");
        e.addContent(text);
        root.addContent((Content)e);
    }

    public static String getHardWrappedString(String s, int width) {
        StringBuffer wrap = new StringBuffer();
        int index = 0;
        while (index <= s.length() - width) {
            wrap.append(s.substring(index, index += width) + "\n");
        }
        wrap.append(s.substring(index));
        return wrap.toString();
    }

    public boolean isShowID() {
        return this.showID;
    }

    public void setShowID(boolean showID) {
        this.showID = showID;
    }

    public boolean isShowLength() {
        return this.showLength;
    }

    public void setShowLength(boolean showLength) {
        this.showLength = showLength;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public void setShowName(boolean showName) {
        this.showName = showName;
    }

    public boolean isShowPolys() {
        return this.showPolys;
    }

    public void setShowPolys(boolean showPolys) {
        this.showPolys = showPolys;
    }

    public boolean isShowSeq() {
        return this.showSeq;
    }

    public void setShowSeq(boolean showSeq) {
        this.showSeq = showSeq;
    }

    public boolean isShowSymbolCount() {
        return this.showSymbolCount;
    }

    public void setShowSymbolCount(boolean showSymbolCount) {
        this.showSymbolCount = showSymbolCount;
    }

    public boolean isShowBlocks() {
        return this.showBlocks;
    }

    public void setShowBlocks(boolean showBlocks) {
        this.showBlocks = showBlocks;
    }

    static {
        percentFormat.setMaximumFractionDigits(1);
    }
}

