/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.ext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.textio.ObjectBuilder;
import net.sf.apptools.ui.UIActivePlugIn;
import net.sf.apptools.ui.WorkbenchUI;
import net.sf.apptools.ui.swing.SwingUserAction;
import net.sf.apptools.ui.swing.SwingWorkbenchUI;
import net.sf.apptools.ui.swing.utils.DelegateAction;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import net.sf.apptools.utils.HTMLRenderer;
import org.apache.commons.collections.Transformer;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.seq.ChangeableNucleotideSequence;
import org.moltools.lib.seq.ChangeableSequence;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.db.ChangeableIndexedSequenceDB;
import org.moltools.lib.seq.db.ChangeableSequenceDB;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.SequenceDBBuilder;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.seq.impl.SimpleChangeableNucleotideSequence;
import org.moltools.lib.seq.io.SequenceDBDataReader;
import org.moltools.lib.seq.io.SequenceDBWriter;
import org.moltools.lib.seq.io.impl.FastaDBFormat;
import org.moltools.lib.seq.utils.DNASeqIO;
import org.moltools.lib.seq.utils.SequenceIO;
import org.moltools.workbench.MolToolsWorkbench;
import org.moltools.workbench.SequenceHTMLRenderer;
import org.moltools.workbench.ext.Messages;
import org.moltools.workbench.ext.SequenceOperation;
import org.moltools.workbench.ext.form.DefaultTextTableFormatPlugin;
import org.moltools.workbench.gui.DefaultSequenceTableModel;
import org.moltools.workbench.gui.NucleotideSequenceTableListener;
import org.moltools.workbench.gui.SequenceTable;
import org.moltools.workbench.gui.SequenceTableDropTargetListener;
import org.moltools.workbench.gui.SequenceTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqEditorPlugIn
implements UIActivePlugIn,
TableModelListener,
ActionListener {
    protected ChangeableIndexedSequenceDB<Sequence> lib = new ListSequenceDB();
    protected boolean dbChanged = false;
    protected JPanel mainPane;
    protected JPanel buttonPane;
    UserAction loadReplace;
    UserAction loadAppend;
    UserAction saveFasta;
    UserAction saveText;
    UserAction remove;
    UserAction add;
    UserAction operation;
    UserAction paste;
    SequenceTableModel libmodel;
    JTable seqTable;
    WorkbenchUI workbench;
    Platform platform;

    public void setup(Platform platform) throws PlugInException {
        this.platform = platform;
        this.workbench = (WorkbenchUI)platform.getPlugInInstance(SwingWorkbenchUI.class);
        if (this.workbench == null) {
            throw new PlugInException("Sequence Editor requires the workbench");
        }
        this.libmodel = new DefaultSequenceTableModel((DefiniteSequenceDB<?>)this.lib);
        this.libmodel.addTableModelListener(this);
        this.loadReplace = new DelegateAction(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_LOAD_SEQUENCES"), Messages.getString("SeqDBEditorFuncPlugIn.TOOLTIP_LOAD_SEQUENCES"), (ActionListener)this);
        this.loadAppend = new DelegateAction(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_APPEND_SEQUENCES"), Messages.getString("SeqDBEditorFuncPlugIn.TOOLTIP_APPEND_SEQUENCES"), (ActionListener)this);
        this.paste = new DelegateAction(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_PASTE_SEQUENCES"), Messages.getString("SeqDBEditorFuncPlugIn.TOOLTIP_PASTE_SEQUENCES"), (ActionListener)this);
        this.saveFasta = new DelegateAction(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_SAVE_FASTA"), Messages.getString("SeqDBEditorFuncPlugIn.TOOLTIP_SAVE_FASTA"), (ActionListener)this);
        this.saveText = new DelegateAction(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_SAVE_TEXT"), Messages.getString("SeqDBEditorFuncPlugIn.TOOLTIP_SAVE_TEXT"), (ActionListener)this);
        this.remove = new DelegateAction(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_REMOVE"), Messages.getString("SeqDBEditorFuncPlugIn.TOOLTIP_REMOVE"), (ActionListener)this);
        this.add = new DelegateAction(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_ADD"), Messages.getString("SeqDBEditorFuncPlugIn.TOOLTIP_ADD"), (ActionListener)this);
        this.operation = new DelegateAction(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_PERFORM_OP"), Messages.getString("SeqDBEditorFuncPlugIn.TOOLTIP_PERFORM_OP"), (ActionListener)this);
        platform.addActionSet(new ActionSet(new UserAction[]{this.loadReplace, this.loadAppend, this.saveFasta, this.saveText}, Messages.getString("SeqDBEditorFuncPlugIn.MENU_FILE"), (ActivePlugIn)this, 100));
        platform.addActionSet(new ActionSet(new UserAction[]{this.remove, this.add, this.operation}, Messages.getString("SeqDBEditorFuncPlugIn.MENU_EDIT"), (ActivePlugIn)this, 200));
    }

    public Component createFunctionalityUI() {
        this.mainPane = new JPanel(new BorderLayout());
        this.buttonPane = new JPanel(new FlowLayout(3));
        this.buttonPane.add(new JButton((Action)new SwingUserAction(this.loadReplace)));
        this.buttonPane.add(new JButton((Action)new SwingUserAction(this.loadAppend)));
        this.buttonPane.add(new JButton((Action)new SwingUserAction(this.paste)));
        this.buttonPane.add(new JButton((Action)new SwingUserAction(this.saveFasta)));
        this.buttonPane.add(new JButton((Action)new SwingUserAction(this.saveText)));
        this.buttonPane.add(new JButton((Action)new SwingUserAction(this.remove)));
        this.buttonPane.add(new JButton((Action)new SwingUserAction(this.add)));
        this.buttonPane.add(new JButton((Action)new SwingUserAction(this.operation)));
        this.seqTable = new SequenceTable(this.libmodel);
        JScrollPane seqScrollPane = new JScrollPane(this.seqTable);
        new NucleotideSequenceTableListener(this.seqTable, this.libmodel, (HTMLRenderer)new SequenceHTMLRenderer(null));
        SequenceTableDropTargetListener stdtl = new SequenceTableDropTargetListener((ChangeableSequenceDB<? extends Sequence>)this.lib);
        seqScrollPane.setDropTarget(new DropTarget(seqScrollPane, 1, stdtl, true));
        this.seqTable.setDropTarget(new DropTarget(this.seqTable, 1, stdtl, true));
        this.mainPane.add((Component)seqScrollPane, "Center");
        this.mainPane.add((Component)this.buttonPane, "North");
        return this.mainPane;
    }

    public static String getBriefDescription() {
        return Messages.getString("SeqDBEditorFuncPlugIn.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return Messages.getString("SeqDBEditorFuncPlugIn.LONG_DESCRIPTION");
    }

    public Icon getIcon() {
        return GUIUtils.getIcon(this.getClass(), (String)"icons/seqEditor.gif", (String)"Sequence editor");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object src = e.getSource();
            if (src == this.loadReplace) {
                this.loadlib(false);
            } else if (src == this.loadAppend) {
                this.loadlib(true);
            } else if (src == this.paste) {
                this.pastelib();
            } else if (src == this.saveText) {
                this.savelib((SequenceDBWriter<Sequence>)new DefaultTextTableFormatPlugin());
            } else if (src == this.saveFasta) {
                this.savelib((SequenceDBWriter<Sequence>)new FastaDBFormat());
            } else if (src == this.remove) {
                this.remove();
            } else if (src == this.add) {
                this.addSeq();
            } else if (src == this.operation) {
                this.operate();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(GUIUtils.getParentFrame((Component)this.mainPane), ex.toString(), Messages.getString("SeqDBEditorFuncPlugIn.TITLE_EXCEPTION"), 2);
            ex.printStackTrace();
        }
    }

    protected void pastelib() throws Exception {
        this.stopEdit();
        if (this.dbChanged) {
            switch (JOptionPane.showConfirmDialog(GUIUtils.getParentFrame((Component)this.mainPane), Messages.getString("SeqDBEditorFuncPlugIn.QUERY_SAVE_FASTA"), Messages.getString("SeqDBEditorFuncPlugIn.TITLE_SAVE_CHANGES"), 1, 3)) {
                case 0: {
                    this.savelib((SequenceDBWriter<Sequence>)new FastaDBFormat());
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        JTextArea pa = new JTextArea(50, 50);
        final JDialog d = new JDialog(GUIUtils.getParentFrame((Component)this.mainPane), Messages.getString("SeqDBEditorFuncPlugIn.TITLE_PASTE_SEQUENCE_DATA"), true);
        d.getContentPane().setLayout(new BorderLayout());
        d.getContentPane().add((Component)new JScrollPane(pa), "Center");
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton(Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_OK"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                d.dispose();
            }
        });
        buttonPanel.add(okButton);
        d.getContentPane().add((Component)buttonPanel, "Last");
        d.pack();
        GUIUtils.checkSize((JDialog)d);
        d.setLocation(GUIUtils.suggestLocation((Window)d, (Frame)GUIUtils.getParentFrame((Component)this.mainPane)));
        d.setVisible(true);
        SequenceDBDataReader f = (SequenceDBDataReader)this.platform.getUI().selectPlugIn(Messages.getString("SeqDBEditorFuncPlugIn.TITLE_SELECT_FORMAT"), "INPUT_FORMATS");
        if (f == null) {
            return;
        }
        StringReader in = new StringReader(pa.getText());
        this.loadlib(in, f, null, null, false);
        this.updateTable();
    }

    protected void loadlib(boolean append) throws IOException, SequenceFormatException, DuplicateIDException {
        File[] files;
        this.stopEdit();
        if (!append && this.dbChanged) {
            switch (JOptionPane.showConfirmDialog(GUIUtils.getParentFrame((Component)this.mainPane), Messages.getString("SeqDBEditorFuncPlugIn.QUERY_SAVE_FASTA"), Messages.getString("SeqDBEditorFuncPlugIn.TITLE_SAVE_CHANGES"), 1, 3)) {
                case 0: {
                    this.savelib((SequenceDBWriter<Sequence>)new FastaDBFormat());
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        if ((files = this.platform.getUI().selectFiles(null, Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_OPEN_SEQ_FILES"))) != null) {
            SequenceDBDataReader dbFormat;
            if (!append) {
                this.lib.clear();
            }
            if ((dbFormat = (SequenceDBDataReader)this.platform.getUI().selectPlugIn(Messages.getString("SeqDBEditorFuncPlugIn.MESSAGE_SELECT_FILEFORMAT"), "INPUT_FORMATS")) == null) {
                return;
            }
            Transformer conv = (Transformer)this.platform.getUI().selectPlugIn(Messages.getString("SeqDBEditorFuncPlugIn.MESSAGE_SELECT_CONVERTER"), "CONVERTERS");
            SequenceDBBuilder dbBuilder = (SequenceDBBuilder)this.platform.getUI().selectPlugIn(Messages.getString("SeqDBEditorFuncPlugIn.MESSAGE_SELECT_MOFIFIER"), "DB_BUILDERS");
            for (int i = 0; i < files.length; ++i) {
                this.loadlib(new FileReader(files[i]), dbFormat, conv, dbBuilder, true);
            }
            this.updateTable();
        }
    }

    protected void savelib(SequenceDBWriter<Sequence> dbFormat) throws IOException {
        this.stopEdit();
        File f = this.platform.getUI().selectSaveFile(null, null, Messages.getString("SeqDBEditorFuncPlugIn.CAPTION_SAVE_SEQUENCE_FASTA"), null);
        if (f != null) {
            this.savelib(f, dbFormat);
        }
    }

    protected void remove() {
        if (this.seqTable.getSelectedRowCount() >= 0) {
            this.stopEdit();
            int[] rows = this.seqTable.getSelectedRows();
            this.remove(rows);
            this.updateTable();
        }
    }

    protected void addSeq() throws DuplicateIDException {
        this.stopEdit();
        this.addSeq((NucleotideSequence)new SimpleChangeableNucleotideSequence("", "", Messages.getString("SeqDBEditorFuncPlugIn.NAME_NEW_SEQUENCE")));
        this.updateTable();
    }

    protected void operate() throws SequenceFormatException {
        SequenceOperation op = (SequenceOperation)this.platform.getUI().selectPlugIn("Select an operation to perform on the selected sequences", "SEQUENCE_OPERATIONS");
        if (op != null) {
            int[] rows = this.seqTable.getSelectedRows();
            this.operate(op, rows);
            this.updateTable();
        }
    }

    public void stopEdit() {
        if (this.seqTable.isEditing()) {
            this.seqTable.getCellEditor(this.seqTable.getEditingRow(), this.seqTable.getEditingColumn()).stopCellEditing();
        }
    }

    protected void updateTable() {
        this.seqTable.tableChanged(new TableModelEvent(this.seqTable.getModel()));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getSource() == this.libmodel) {
            this.dbChanged = true;
        }
    }

    protected void loadlib(Reader in, SequenceDBDataReader dbFormat, Transformer conv, SequenceDBBuilder dbBuilder, boolean append) throws IOException, SequenceFormatException, DuplicateIDException {
        if (!append) {
            this.lib.clear();
        }
        Map<String, Transformer> trans = Collections.singletonMap("sequence.seqstring", conv);
        DefiniteSequenceDB db = SequenceIO.readSequenceDB((Reader)in, (SequenceDBDataReader)dbFormat, trans, (SequenceDBBuilder)dbBuilder, (ObjectBuilder)DNASeqIO.getDefaultChangeableBuilder());
        this.lib.addSequences(db);
        in.close();
        this.dbChanged = false;
    }

    protected void savelib(File f, SequenceDBWriter<Sequence> format) throws IOException {
        FileWriter o = new FileWriter(f);
        SequenceIO.writeSequenceDB((Writer)o, this.lib, format, null);
        ((Writer)o).close();
        this.dbChanged = false;
    }

    protected void remove(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            this.lib.removeSequenceAt(rows[i]);
        }
        this.dbChanged = true;
    }

    protected void addSeq(NucleotideSequence seq) throws DuplicateIDException {
        this.lib.addSequence((Sequence)seq);
        this.dbChanged = true;
    }

    public void operate(SequenceOperation op, int[] rows) throws SequenceFormatException {
        for (int i = 0; i < rows.length; ++i) {
            op.operate((ChangeableSequence)((ChangeableNucleotideSequence)this.lib.getSequenceAt(rows[i])));
        }
        this.dbChanged = true;
    }

    public boolean teardown() {
        this.platform.removeActionSets((ActivePlugIn)this);
        return true;
    }

    public Map<String, String> getPlugInRequirements() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(WorkbenchUI.class.getName(), "1.0.0");
        m.put(MolToolsWorkbench.class.getName(), "1.0.0");
        return m;
    }

    public String getVersion() {
        return "1.0.0";
    }
}

