/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.ext.ops;

import net.sf.apptools.plugin.PlugIn;
import org.moltools.lib.Renameable;
import org.moltools.lib.seq.ChangeableNucleotideSequence;
import org.moltools.lib.seq.ChangeableSequence;
import org.moltools.lib.seq.SequenceEdit;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.impl.SimpleSequenceEdit;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.workbench.ext.SequenceOperation;

public class UToTNAOperation
implements SequenceOperation,
PlugIn {
    boolean changename = true;

    public static String getBriefDescription() {
        return "U to T";
    }

    public static String getLongDescription() {
        return "Convert all U residues to T residues";
    }

    public void operate(ChangeableSequence s) throws SequenceFormatException {
        if (s instanceof ChangeableNucleotideSequence) {
            String newString = s.seqString().replace(NucleotideSequenceHandler.getNucleotide((char)'T', (byte)0).getChar(), NucleotideSequenceHandler.getNucleotide((char)'U', (byte)0).getChar());
            SimpleSequenceEdit edit = new SimpleSequenceEdit(1, s.length(), newString);
            s.edit((SequenceEdit)edit);
            String add = "|UtoT";
            if (this.changename) {
                s.setID(s.getID() + add);
                if (s instanceof Renameable) {
                    Renameable n = (Renameable)s;
                    n.setName(n.getName() + add);
                }
            }
        } else {
            throw new UnsupportedOperationException("UtoT only works on nucleic acid sequences");
        }
    }
}

