/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import javax.swing.table.AbstractTableModel;
import net.genefront.piecemaker.model.PieceMakerProject;
import net.genefront.piecemaker.model.ProjectChangeEvent;
import net.genefront.piecemaker.model.ProjectChangeListener;
import org.moltools.lib.Identifiable;

public class CombinationTableModel
extends AbstractTableModel
implements ProjectChangeListener {
    private static final long serialVersionUID = 1L;
    PieceMakerProject project;

    public void setProject(PieceMakerProject p) {
        this.project = p;
        p.addChangeListener((ProjectChangeListener)this);
        this.fireTableStructureChanged();
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Target";
        }
        if (column == this.getColumnCount() - 1) {
            return "Result";
        }
        if (this.project != null) {
            return this.project.getCombinationReaction(column - 1).getName();
        }
        return "";
    }

    public int getRowCount() {
        if (this.project == null) {
            return 0;
        }
        if (this.project.getTargetList() == null) {
            return 0;
        }
        return this.project.getTargetList().size();
    }

    public int getColumnCount() {
        if (this.project == null) {
            return 1;
        }
        return this.project.getCombinationReactionCount() + 2;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.project == null) {
            return null;
        }
        if (columnIndex == 0) {
            return ((Identifiable)this.project.getTargetList().get(rowIndex)).getID();
        }
        if (columnIndex == this.getColumnCount() - 1) {
            return this.project.getCombinationMessages()[rowIndex];
        }
        if (columnIndex - 1 < this.project.getCombinationReactionCount()) {
            return new Integer(this.project.getCombinationForTarget(rowIndex)[columnIndex - 1].size());
        }
        return null;
    }

    public int getSuccesses() {
        if (this.project == null) {
            return 0;
        }
        return this.project.getSuccesses();
    }

    public void projectChanged(ProjectChangeEvent e) {
        if (e.getEventType() == ProjectChangeEvent.ALL_CHANGED || e.getEventType() == ProjectChangeEvent.COMBINATION_CHANGED) {
            this.fireTableStructureChanged();
        }
    }

    public void projectClosing(PieceMakerProject oldProject) {
        oldProject.removeChangeListener((ProjectChangeListener)this);
    }

    public void projectOpened(PieceMakerProject newProject) {
        this.setProject(newProject);
    }
}

