/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.awt.Color;
import java.awt.Graphics;
import net.genefront.piecemaker.gui.DisplayContext;
import net.genefront.piecemaker.gui.SequenceLineRenderer;

public class CoverageRenderer
implements SequenceLineRenderer {
    int height = 3;
    int top = 1;
    int bottom = 1;
    Color lineColor;
    int offsetPos = 0;

    public CoverageRenderer(int height, int top, int bottom, Color lineColor, int offsetPos) {
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.lineColor = lineColor;
        this.offsetPos = offsetPos;
    }

    public int getHeight(DisplayContext dc, Object obj) {
        return this.height + this.top + this.bottom;
    }

    public int getRequestedHead(DisplayContext dc, Object obj) {
        return 0;
    }

    public int getRequestedTail(DisplayContext dc, Object obj) {
        return 0;
    }

    public void paint(Graphics g, DisplayContext dc, Object obj) {
        Color old = g.getColor();
        g.setColor(this.lineColor);
        int[] coverage = (int[])obj;
        int width = (int)Math.ceil(1.0f / dc.getScale());
        int i = 0;
        while (i < coverage.length) {
            int seqPos = 1 + i + this.offsetPos;
            int pixelPos = dc.getPixel(seqPos);
            int lineHeight = Math.min(coverage[i], this.height);
            if (lineHeight > 0) {
                g.fillRect(pixelPos, this.top, width, lineHeight);
            }
            ++i;
        }
        g.setColor(old);
    }

    public void setColor(Color color) {
        this.lineColor = color;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setOffset(int offset) {
        this.offsetPos = offset;
    }
}

