/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.genefront.piecemaker.gui.CutResultsTableModel;

public class CutResultsTableSorter
extends AbstractTableModel
implements TableModelListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    Map<Integer, Integer> sortedIndices;
    CutResultsTableModel model;
    MouseListener mouseListener;
    byte[] sortModes;
    public static final byte SORT_NONE = 0;
    public static final byte SORT_DESCENDING = 1;
    public static final byte SORT_ASCENDING = 2;

    public CutResultsTableSorter(CutResultsTableModel _model) {
        this.model = _model;
        this.model.addTableModelListener(this);
        this.sortModes = new byte[this.model.getColumnCount()];
        this.sortedIndices = new TreeMap<Integer, Integer>();
        this.populateMap();
    }

    public void setTableHeader(JTableHeader th) {
        th.addMouseListener(this);
    }

    protected void sort(int column) {
        int i;
        this.sortModes[column] = (byte)(this.sortModes[column] == 2 ? 0 : this.sortModes[column] + 1);
        int[] indices = new int[this.model.getRowCount()];
        int i2 = 0;
        while (i2 < indices.length) {
            indices[i2] = i2;
            ++i2;
        }
        boolean changed = true;
        switch (this.sortModes[column]) {
            case 0: {
                break;
            }
            case 2: {
                int temp;
                while (changed) {
                    changed = false;
                    i = 0;
                    while (i < indices.length - 1) {
                        if (((Comparable)this.model.getValueAt(indices[i], column)).compareTo(this.model.getValueAt(indices[i + 1], column)) < 0) {
                            changed = true;
                            temp = indices[i];
                            indices[i] = indices[i + 1];
                            indices[i + 1] = temp;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 1: {
                int temp;
                while (changed) {
                    changed = false;
                    i = 0;
                    while (i < indices.length - 1) {
                        if (((Comparable)this.model.getValueAt(indices[i], column)).compareTo(this.model.getValueAt(indices[i + 1], column)) > 0) {
                            changed = true;
                            temp = indices[i];
                            indices[i] = indices[i + 1];
                            indices[i + 1] = temp;
                        }
                        ++i;
                    }
                }
                break;
            }
        }
        i = 0;
        while (i < indices.length) {
            this.sortedIndices.put(new Integer(i), new Integer(indices[i]));
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void populateMap() {
        int i = 0;
        while (i < this.model.getRowCount()) {
            this.sortedIndices.put(new Integer(i), new Integer(i));
            ++i;
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.fireTableChanged(e);
        this.populateMap();
    }

    public String getColumnName(int col) {
        return this.model.getColumnName(col);
    }

    public Object getValueAt(int row, int col) {
        return this.model.getValueAt(this.sortedIndices.get(new Integer(row)), col);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public int getModelRow(int tableRow) {
        return this.sortedIndices.get(new Integer(tableRow));
    }

    public void mouseClicked(MouseEvent e) {
        JTableHeader th = (JTableHeader)e.getSource();
        TableColumnModel columnModel = th.getColumnModel();
        int viewColumn = columnModel.getColumnIndexAtX(e.getX());
        int column = columnModel.getColumn(viewColumn).getModelIndex();
        if (e.getButton() == 1) {
            this.sort(column);
        } else {
            this.populateMap();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

