/*
 * Decompiled with CFR 0.152.
 */
package net.genefront.piecemaker.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import net.genefront.piecemaker.gui.CombinationTableModel;
import net.genefront.piecemaker.gui.FragmentSetDialog_fragmentTable_keyAdapter;
import net.genefront.piecemaker.gui.FragmentSetDialog_fragmentTable_mouseAdapter;
import net.genefront.piecemaker.gui.FragmentSetTableModel;
import net.genefront.piecemaker.model.FragmentSet;
import net.genefront.piecemaker.model.MutableFragmentSet;
import net.genefront.piecemaker.model.PieceMakerProject;
import net.genefront.piecemaker.model.SelectorTarget;
import net.genefront.piecemaker.model.TargetFragment;
import net.genefront.piecemaker.utils.PropertyUtils;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.NucleotideSequence;

public class FragmentSetDialog
extends JDialog
implements ActionListener {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    FragmentSet model;
    JPanel jPanel1 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JButton closeButton = new JButton();
    FragmentSetTableModel tableModel;
    JTable fragmentTable = new JTable();
    PieceMakerProject project;
    CombinationTableModel combModel;
    boolean acceptedOnly;

    public FragmentSetDialog(Frame frame, String title, FragmentSet set, PieceMakerProject _project, CombinationTableModel combinationModel, boolean acceptedOnly) {
        super(frame, title, false);
        this.combModel = combinationModel;
        this.setDefaultCloseOperation(2);
        this.model = set;
        this.project = _project;
        this.acceptedOnly = acceptedOnly;
        try {
            this.jbInit();
            this.closeButton.addActionListener(this);
            this.tableModel = new FragmentSetTableModel();
            this.tableModel.setModel(this.model);
            this.fragmentTable.setModel(this.tableModel);
            this.fragmentTable.addKeyListener(new FragmentSetDialog_fragmentTable_keyAdapter(this));
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.closeButton.setText("Close");
        this.fragmentTable.addMouseListener(new FragmentSetDialog_fragmentTable_mouseAdapter(this));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.closeButton, null);
        this.panel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.fragmentTable, null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.dispose();
        }
    }

    void fragmentTable_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.model instanceof MutableFragmentSet) {
            MutableFragmentSet mfs = (MutableFragmentSet)this.model;
            int row = this.fragmentTable.getSelectedRow();
            int tableSize = this.model.size();
            if (row >= 0 && row < tableSize) {
                mfs.remove(row);
                this.tableModel.setModel(this.model);
                this.tableModel.fireTableStructureChanged();
                this.project.updateCombinations();
                if (this.combModel != null) {
                    this.combModel.fireTableDataChanged();
                }
            }
        }
    }

    void fragmentTable_mouseClicked(MouseEvent e) {
        String targetID;
        SelectorTarget target;
        if (e.getButton() == 1 && e.getClickCount() == 2 && (target = this.project.getTargetByID(targetID = PropertyUtils.getTargetID((PropertyHolder)this.model))) != null) {
            int row = this.fragmentTable.rowAtPoint(e.getPoint());
            TargetFragment fragment = this.model.getFragment(row);
            String sequenceRepr = PropertyUtils.getEndoMarkedSequence((NucleotideSequence)target, (TargetFragment)fragment);
            JTextArea area = new JTextArea(sequenceRepr, 25, 60);
            area.setEditable(false);
            area.setLineWrap(true);
            JOptionPane.showMessageDialog(this, new JScrollPane(area));
        }
    }
}

