/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.calculators;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.moltools.apps.probemaker.calculators.LigationTemplateCalculator;
import org.moltools.apps.probemaker.ext.target.AlleleSpecificPadlockTarget;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.design.calc.FractionalMeltingPointCalculator;
import org.moltools.design.calc.FractionalNNParameters;
import org.moltools.design.calc.MeltingPointCalculator;
import org.moltools.design.calc.NNParameters;
import org.moltools.design.data.PropertyHolderNucleotideSequence;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.impl.SimpleChangeableNucleotideSequence;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.struct.NAHybridStructure;
import org.moltools.lib.struct.UnsupportedHybridStructureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PadlockLigationCalculator
extends AbstractParameterHolder
implements LigationTemplateCalculator {
    public static final String PROPERTY_PROBE_5_MATCH_LENGTH = "PROBE_TEMPLATING_FIVE_MIN_LENGTH";
    public static final String PROPERTY_PROBE_3_MATCH_LENGTH = "PROBE_TEMPLATING_THREE_MIN_LENGTH";
    public static final String PROPERTY_TARGET_5_MATCH_LENGTH = "TARGET_TEMPLATING_FIVE_MIN_LENGTH";
    public static final String PROPERTY_TARGET_3_MATCH_LENGTH = "TARGET_TEMPLATING_THREE_MIN_LENGTH";
    public static final String PROPERTY_USE_TM = "USE_TM";
    public static final String PROPERTY_TM_LIMIT = "TM_LIMIT";
    public static final MessageType TEMPLATE_FOR_OTHER_PROBE = new MessageType("TEMPLATE_FOR_OTHER_PROBE", "Probe is template for other probe");
    public static final MessageType TSS_IS_TEMPLATE_FOR_OTHER_PROBE = new MessageType("TSS_IS_TEMPLATE_FOR_OTHER_PROBE", "TSSs is template for other probe");
    public static final MessageType TSS_IS_TEMPLATE_FOR_PROBE = new MessageType("TSS_IS_TEMPLATE_FOR_PROBE", "TSSs is template for probe");
    public static final MessageType PROBE_IS_SELF_TEMPLATE = new MessageType("PROBE_IS_SELF_TEMPLATE", "Probe is template for itself");
    public static final MessageType OTHER_PROBE_IS_TEMPLATE = new MessageType("OTHER_PROBE_IS_TEMPLATE", "Other probe is template for probe");
    public static final MessageType OTHER_TARGET_IS_TEMPLATE = new MessageType("OTHER_TARGET_IS_TEMPLATE", "Other target is template for probe");
    public static final MessageType TARGET_IS_TEMPLATE_IN_OTHER_POS = new MessageType("TARGET_IS_TEMPLATE_IN_OTHER_POS", "Other position of target is template");
    public static final MessageType TARGET_IS_NOT_TEMPLATE = new MessageType("TARGET_IS_NOT_TEMPLATE", "Target is not template for probe");
    public static final MessageType NO_ANALYSIS = new MessageType("NO_ANALYSIS", "No analysis performed");
    int min5t;
    int min3t;
    int min5p;
    int min3p;
    boolean doTm = true;
    int limit = 0;
    MeltingPointCalculator fmpc;

    public Map<String, String> getDefaultParameters() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(PROPERTY_PROBE_5_MATCH_LENGTH, "4");
        p.put(PROPERTY_PROBE_3_MATCH_LENGTH, "4");
        p.put(PROPERTY_TARGET_5_MATCH_LENGTH, "8");
        p.put(PROPERTY_TARGET_3_MATCH_LENGTH, "8");
        p.put(PROPERTY_USE_TM, "true");
        p.put(PROPERTY_TM_LIMIT, "40");
        return p;
    }

    public PadlockLigationCalculator() {
        this.parameters = this.getDefaultParameters();
        try {
            this.fmpc = new FractionalMeltingPointCalculator((NNParameters)new FractionalNNParameters());
        }
        catch (IOException e) {
            throw new RuntimeException("NN parameters could not be found", e);
        }
    }

    public void setParameters(Map<String, String> params) {
        super.setParameters(params);
        this.readParameters();
    }

    public void addParameters(Map<String, String> params) {
        super.addParameters(params);
        this.readParameters();
    }

    void readParameters() {
        this.min5t = Integer.parseInt((String)this.parameters.get(PROPERTY_TARGET_5_MATCH_LENGTH));
        this.min3t = Integer.parseInt((String)this.parameters.get(PROPERTY_TARGET_3_MATCH_LENGTH));
        this.min5p = Integer.parseInt((String)this.parameters.get(PROPERTY_PROBE_5_MATCH_LENGTH));
        this.min3p = Integer.parseInt((String)this.parameters.get(PROPERTY_PROBE_3_MATCH_LENGTH));
        this.doTm = Boolean.valueOf((String)this.parameters.get(PROPERTY_USE_TM));
        this.limit = Integer.parseInt((String)this.parameters.get(PROPERTY_TM_LIMIT));
    }

    @Override
    public int[] isLigationTemplate(NucleotideSequence s, Probe p, boolean circular, boolean target) {
        int min3Length;
        int min5Length = target ? this.min5t : this.min5p;
        int n = min3Length = target ? this.min3t : this.min3p;
        if (min5Length < 1) {
            return null;
        }
        if (min3Length < 1) {
            return null;
        }
        int probeLength = p.length();
        if (min5Length + min3Length > probeLength) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Templating not properly calculated because minimum lengths are too great", PROBE_IS_SELF_TEMPLATE, 0));
            while (min5Length + min3Length > probeLength) {
                if (min5Length > min3Length) {
                    min5Length = probeLength - min3Length > 0 ? probeLength - min3Length : 1;
                    continue;
                }
                min3Length = probeLength - min5Length > 0 ? probeLength - min5Length : 1;
            }
        }
        try {
            NucleotideSequence tss5 = (NucleotideSequence)p.getTSSPair().getSequence("FIVE_PRIME");
            NucleotideSequence tss3 = (NucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME");
            String tssSeq = tss3.seqString() + tss5.seqString();
            SimpleNucleotideSequence fullTSS = new SimpleNucleotideSequence("TSS", tssSeq, p.getType());
            String threeseq = p.subsequence(p.length() - min3Length + 1, p.length());
            String fiveseq = p.subsequence(1, min5Length);
            String query = NucleotideSequenceHandler.getRevComp((String)(threeseq + fiveseq), (byte)p.getType(), (byte)s.getType());
            int TSSlen5 = tss5.length();
            int TSSlen3 = tss3.length();
            String sequence = s.seqString().replace('U', 'T');
            if (circular) {
                sequence = sequence + sequence.substring(0, min3Length + min5Length - 1);
            }
            Stack<Integer> results = new Stack<Integer>();
            int index = -1;
            while ((index = sequence.indexOf(query, index + 1)) > -1) {
                if (this.doTm) {
                    float maxTm = -3.4028235E38f;
                    int start = Math.max(0, index + min5Length - TSSlen5);
                    int end = Math.min(index + min5Length + TSSlen3, sequence.length());
                    String template = sequence.substring(start, end);
                    String[] sequences = NucleotideSequenceHandler.getPossibleSequences((String)template, (byte)s.getType());
                    for (int sc = 0; sc < sequences.length; ++sc) {
                        float Tm;
                        SimpleNucleotideSequence s2 = new SimpleNucleotideSequence("S2", sequences[sc], s.getType());
                        NAHybridStructure hs = ((FractionalMeltingPointCalculator)this.fmpc).calculateHybridStructure((NucleotideSequence)fullTSS, (NucleotideSequence)s2);
                        if (hs == null) continue;
                        try {
                            Tm = this.fmpc.getMeltingPoint((NucleotideSequence)fullTSS, (NucleotideSequence)s2, hs);
                        }
                        catch (UnsupportedHybridStructureException e) {
                            Tm = -273.15f;
                        }
                        if (!(Tm > maxTm)) continue;
                        maxTm = Tm;
                    }
                    if (!(maxTm >= (float)this.limit)) continue;
                    results.push(new Integer(index + min5Length));
                    continue;
                }
                results.push(new Integer(index + min5Length));
            }
            if (results.isEmpty()) {
                return null;
            }
            int[] res = new int[results.size()];
            for (int i = 0; i < res.length; ++i) {
                res[i] = (Integer)results.pop() + 1;
            }
            return res;
        }
        catch (ClusterException e1) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Padlock ligation analysis could not be performed: " + e1.toString(), NO_ANALYSIS, 0));
            return new int[0];
        }
    }

    @Override
    public boolean checkTemplatingByTarget(Probe p) {
        boolean found = false;
        ProbeMakerTarget t = (ProbeMakerTarget)p.getTarget();
        if (t != null) {
            boolean correct = false;
            int[] results = this.isLigationTemplate((NucleotideSequence)t, p, false, true);
            if (results != null) {
                for (int i = 0; i < results.length; ++i) {
                    if (results[i] != ((AlleleSpecificPadlockTarget)t).getTargetPosition()) {
                        ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("May be templated by target in other position (" + results[i] + ").", TARGET_IS_TEMPLATE_IN_OTHER_POS, 2));
                        found = true;
                        continue;
                    }
                    correct = true;
                }
            }
            if (!correct) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Target is not ligation template for probe", TARGET_IS_NOT_TEMPLATE, 2));
            }
            found = true;
        }
        return found;
    }

    @Override
    public boolean checkTemplatingByArms(Probe p) {
        NucleotideSequence tp;
        NucleotideSequence fp;
        boolean found = false;
        try {
            fp = (NucleotideSequence)p.getTSSPair().getSequence("FIVE_PRIME");
        }
        catch (ClusterException e) {
            fp = null;
        }
        try {
            tp = (NucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME");
        }
        catch (ClusterException e) {
            tp = null;
        }
        if (tp == null || fp == null) {
            throw new UnsupportedOperationException("Can't perform ligation calculations with missing TSSs");
        }
        int[] results = this.isLigationTemplate((NucleotideSequence)new SimpleChangeableNucleotideSequence("TSS|" + p.getName(), tp.seqString() + fp.seqString(), p.getType()), p, false, false);
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("Probe TSSs may template itself (position " + results[i] + ").", PROBE_IS_SELF_TEMPLATE, 2));
                found = true;
            }
        }
        return found;
    }

    @Override
    public boolean checkTemplatingBySelf(Probe p) {
        boolean found = false;
        int[] results = this.isLigationTemplate((NucleotideSequence)p, p, true, false);
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Probe may template itself (position " + results[i] + ").", PROBE_IS_SELF_TEMPLATE, 2));
                found = true;
            }
        }
        return found;
    }

    @Override
    public boolean checkTemplatingByOtherProbes(Probe p, DefiniteSequenceDB<? extends Probe> probes) {
        boolean found = false;
        for (Probe other : probes) {
            if (other == p) continue;
            if (other.tagsAllocated()) {
                if (this.isLigationTemplate((NucleotideSequence)other, p, true, false) == null) continue;
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("May be templated by " + other.getName(), OTHER_PROBE_IS_TEMPLATE, 2));
                found = true;
                continue;
            }
            try {
                if (this.isLigationTemplate((NucleotideSequence)new SimpleNucleotideSequence(((PropertyHolderNucleotideSequence)other.getTSSPair().getSequence("THREE_PRIME")).seqString() + ((PropertyHolderNucleotideSequence)other.getTSSPair().getSequence("FIVE_PRIME")).seqString(), "Arms of " + other.getName(), other.getType()), p, false, false) == null) continue;
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("May be templated by " + other.getName(), OTHER_PROBE_IS_TEMPLATE, 2));
                found = true;
            }
            catch (ClusterException e) {
                found = false;
            }
        }
        return found;
    }

    @Override
    public boolean checkTemplatingByOtherTargets(Probe p, DefiniteSequenceDB<? extends Probe> probes) {
        boolean found = false;
        for (Probe other : probes) {
            if (other == p || other.getTarget() == null || this.isLigationTemplate((NucleotideSequence)other.getTarget(), p, false, true) == null) continue;
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("May be templated by " + other.getTarget().getID(), OTHER_TARGET_IS_TEMPLATE, 2));
            found = true;
        }
        return found;
    }

    @Override
    public boolean checkArmsTemplatingOthers(Probe p, DefiniteSequenceDB<? extends Probe> probes) {
        boolean found = false;
        for (Probe other : probes) {
            NucleotideSequence tp;
            NucleotideSequence fp;
            if (other == p) continue;
            try {
                fp = (NucleotideSequence)p.getTSSPair().getSequence("FIVE_PRIME");
            }
            catch (ClusterException e) {
                fp = null;
            }
            try {
                tp = (NucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME");
            }
            catch (ClusterException e) {
                tp = null;
            }
            if (tp == null || fp == null) {
                throw new UnsupportedOperationException("Can't perform ligation calculations with missing TSSs");
            }
            if (this.isLigationTemplate((NucleotideSequence)new SimpleNucleotideSequence(tp.seqString() + fp.seqString(), "Arms of " + p.getName(), p.getType()), other, false, false) == null) continue;
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("May act as template for " + other.getName(), TSS_IS_TEMPLATE_FOR_OTHER_PROBE, 2));
            found = true;
        }
        return found;
    }

    @Override
    public boolean checkTemplatingOthers(Probe p, DefiniteSequenceDB<? extends Probe> probes) {
        boolean found = false;
        for (Probe other : probes) {
            if (other == p || this.isLigationTemplate((NucleotideSequence)p, other, true, false) == null) continue;
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("May act as template for " + other.getName(), TEMPLATE_FOR_OTHER_PROBE, 2));
            found = true;
        }
        return found;
    }
}

