/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.calculators;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.moltools.apps.probemaker.calculators.DefaultTagSimilarityCalculator;
import org.moltools.apps.probemaker.calculators.TagSimilarityCalculator;
import org.moltools.design.calc.HomologyCalculator;
import org.moltools.design.calc.SmithWatermanCalculator;
import org.moltools.design.utils.AbstractParameterHolder;
import org.moltools.lib.alignment.Alignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTagSimilarityCalculator
extends AbstractParameterHolder
implements TagSimilarityCalculator {
    SmithWatermanCalculator hc;
    TagSimilarityCalculator def;
    protected double sim;
    public static final String PROPERTY_PERCENT_SIMILARITY = "PERCENT_SIMILARITY";
    protected Collection<Integer> indices = new Stack<Integer>();

    public SWTagSimilarityCalculator() {
        this.parameters = this.getDefaultParameters();
        this.hc = new HomologyCalculator();
        this.def = new DefaultTagSimilarityCalculator();
        this.readParameters();
    }

    public Map<String, String> getDefaultParameters() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(PROPERTY_PERCENT_SIMILARITY, "90");
        return p;
    }

    public void addParameters(Map<String, String> p) {
        super.addParameters(p);
        this.readParameters();
    }

    public void setParameters(Map<String, String> p) {
        super.setParameters(p);
        this.readParameters();
    }

    protected void readParameters() {
        this.sim = Double.parseDouble((String)this.parameters.get(PROPERTY_PERCENT_SIMILARITY));
    }

    @Override
    public Integer[] getOccurrences(String tag, String probe, byte tagType, byte probeType, boolean circular) {
        if ((int)this.sim == 100) {
            return this.def.getOccurrences(tag, probe, tagType, probeType, circular);
        }
        int tagLength = tag.length();
        int subend = tagLength - 1;
        String probeSequence = new String(probe);
        if (circular && tagLength > 1) {
            probeSequence = probeSequence + probeSequence.substring(0, subend < probeSequence.length() ? subend : probeSequence.length() - 1);
        }
        int maxscore = this.hc.getScore(tag, tag);
        double limit = (double)maxscore * this.sim / 100.0;
        int[] pos = new int[2];
        this.indices.clear();
        this.hc.doAlignment(probeSequence, tag);
        int score = this.hc.getHighestCell(pos);
        Alignment la = this.hc.getNextAlignment();
        while ((double)score > limit) {
            String[] alignseqs = new String[]{la.getFirstString(), la.getSecondString()};
            int apos = la.getFirstStart();
            Integer i = new Integer(apos - 1);
            boolean valid = true;
            if (apos > probe.length() || apos < 0) {
                valid = false;
            }
            if (alignseqs[0].startsWith("-") || alignseqs[0].endsWith("-")) {
                valid = false;
            }
            if (alignseqs[1].startsWith("-") || alignseqs[1].endsWith("-")) {
                valid = false;
            }
            if (valid && !this.indices.contains(i)) {
                this.indices.add(i);
            }
            if (!((double)(score = this.hc.getHighestCell(pos)) > limit)) continue;
            la = this.hc.getNextAlignment();
        }
        Integer[] ret = new Integer[this.indices.size()];
        return this.indices.toArray(ret);
    }
}

