/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.dbb;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.apptools.plugin.PlugIn;
import net.sf.apptools.textio.ObjectBuilder;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.design.data.Target;
import org.moltools.design.data.impl.TargetGroup;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.SequenceDBBuilder;
import org.moltools.lib.seq.db.impl.ListSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorGroupSorter
implements SequenceDBBuilder,
PlugIn {
    public static String getBriefDescription() {
        return "Group/sort selector targets";
    }

    public static String getLongDescription() {
        return "Groups restriction fragments from the same targets and sorts the groups according to size, in ascending order";
    }

    public <S extends Sequence> DefiniteSequenceDB<S> buildDB(Collection<Map<String, String>> sequenceDataMaps, ObjectBuilder<S> sequenceBuilder) throws DuplicateIDException {
        ListSequenceDB targets = (ListSequenceDB)ListSequenceDB.getDefaultBuilder().buildDB(sequenceDataMaps, sequenceBuilder);
        HashMap<String, TargetGroup> targetGroups = new HashMap<String, TargetGroup>();
        for (int i = 0; i < targets.size(); ++i) {
            TargetGroup tg;
            ProbeMakerTarget t = (ProbeMakerTarget)targets.getSequenceAt(i);
            String groupName = t.getID().split(" ")[0];
            if (targetGroups.containsKey(groupName)) {
                tg = (TargetGroup)targetGroups.get(groupName);
                tg.addMember((Object)t);
                continue;
            }
            tg = new TargetGroup(t.getID());
            tg.addMember((Object)t);
            targetGroups.put(groupName, tg);
        }
        Collection values = targetGroups.values();
        TargetGroup[] groups = values.toArray(new TargetGroup[values.size()]);
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 1; i < groups.length; ++i) {
                if (groups[i - 1].getMembers().size() <= groups[i].getMembers().size()) continue;
                TargetGroup temp = groups[i - 1];
                groups[i - 1] = groups[i];
                groups[i] = temp;
                changed = true;
            }
        }
        ListSequenceDB sorted = new ListSequenceDB();
        for (int i = 0; i < groups.length; ++i) {
            for (Target o : groups[i].getMembers()) {
                sorted.addSequence((Sequence)o);
            }
        }
        return sorted;
    }

    public String getDescription() {
        return "Group targets on first word of name. Sort on increasing group size.";
    }
}

