/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.ext.target.MinisequencingTarget;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.design.calc.FractionalMeltingPointCalculator;
import org.moltools.design.calc.FractionalNNParameters;
import org.moltools.design.calc.NNParameters;
import org.moltools.design.data.Group;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.seq.utils.SequenceHandler;
import org.moltools.lib.struct.NAHybridStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FalsePrimingModule
extends AbstractProbeModule {
    static Log log = LogFactory.getLog(FalsePrimingModule.class);
    public static final MessageType FALSE_PRIME_ON_TARGET = new MessageType("FALSE_PRIME_ON_TARGET", "False priming on target sequence");
    public static final MessageType FALSE_PRIME_ON_PRIMER = new MessageType("FALSE_PRIME_ON_PRIMER", "False priming on primer sequence");
    List<ProbeMakerTarget> targetList;
    List<NucleotideSequence> primerList;
    int matchLength = 4;
    int limit;
    List<Float> tms = new ArrayList<Float>();
    FractionalMeltingPointCalculator fmpc;

    public static String getBriefDescription() {
        return "False priming";
    }

    public static String getLongDescription() {
        return "<html>False priming according to the algorithm described in:<p>Kaderali <i>et al.</i> (2003) Primer-design for multiplexed genotyping. <i>Nucleic Acids Res.</i>, <b>31</b>, 1796-1802.<p>The four 3'-terminal nucleotides of the primer/probe (3'TSS) are matched to each target sequence. If a match is found (except at the position of the intended priming site) an alignment is performed between the primer and the target at that position. If the Tm of the strongest alignment is above the limit, an error message is given.<br><b>Currently, use this module only for design of minisequencing primers</b><br>Tm is calculated as described in:<p>Leber <i>et al.</i> (2005) A fractional programming approach to efficient DNA melting temperature calculation. <i>Nucleic Acids Res.</i>, <b>31</b>, 1796-1802.</html>";
    }

    public FalsePrimingModule() {
        super(new TestDescriptor[]{new TestDescriptor("False priming on targets"), new TestDescriptor("False priming on primers")}, new DataDescriptor[]{new IntegerDescriptor("Max Tm for target priming", "Tm limit for target priming calculations", "MAX_TARGET_PRIMING_TEMP", 0, 100)});
        this.setData("MAX_TARGET_PRIMING_TEMP", new Integer(40));
        try {
            this.fmpc = new FractionalMeltingPointCalculator((NNParameters)new FractionalNNParameters());
        }
        catch (IOException iox) {
            throw new RuntimeException("Parameters file not found", iox);
        }
    }

    public void reset() {
        this.targetList = null;
        this.primerList = null;
        this.limit = (Integer)this.getData("MAX_TARGET_PRIMING_TEMP");
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        NucleotideSequence primer;
        if (this.targetList == null) {
            this.targetList = new ArrayList<ProbeMakerTarget>(probes.size());
            for (Probe probe : probes) {
                ProbeMakerTarget t = (ProbeMakerTarget)probe.getTarget();
                if (t == null) continue;
                this.targetList.add(t);
            }
        }
        if (this.primerList == null) {
            this.primerList = new ArrayList<NucleotideSequence>(probes.size());
            for (Probe probe : probes) {
                if (probe == null) continue;
                this.primerList.add((NucleotideSequence)probe);
            }
        }
        try {
            primer = (NucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME");
        }
        catch (ClusterException e) {
            primer = null;
        }
        log.debug((Object)("Checking probe " + p.getName()));
        if (this.tests[0].perform() && primer != null) {
            Group thisGroup = DesignUtils.getGroupWithType((PropertyHolder)((PropertyHolder)p.getTarget()), (String)"moltools.targetGroup");
            for (ProbeMakerTarget t : this.targetList) {
                Group otherGroup = DesignUtils.getGroupWithType((PropertyHolder)t, (String)"moltools.targetGroup");
                int[] results = this.getPrimingPositions(primer, (NucleotideSequence)t);
                if (results == null) continue;
                for (int i = 0; i < results.length; ++i) {
                    boolean err = true;
                    if (otherGroup != null && thisGroup == otherGroup && t instanceof MinisequencingTarget && results[i] == ((MinisequencingTarget)t).getTargetPosition()) {
                        err = false;
                    }
                    if (!err) continue;
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("May prime on " + t.getID() + " (pos. " + results[i] + ", Tm = " + Math.round(this.tms.get(i).floatValue()) + ").", FALSE_PRIME_ON_TARGET, 2));
                    log.debug((Object)(p.getName() + "/" + t.getID() + ": " + results[i] + ", " + Math.round(this.tms.get(i).floatValue()) + " \ufffdC"));
                }
            }
        }
        if (this.tests[1].perform()) {
            for (NucleotideSequence other : this.primerList) {
                int[] results = this.getPrimingPositions(primer, other);
                if (results == null) continue;
                for (int i = 0; i < results.length; ++i) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), (Message)new Message("May prime on " + other.getID() + " (pos. " + results[i] + ", Tm = " + Math.round(this.tms.get(i).floatValue()) + ").", FALSE_PRIME_ON_PRIMER, 2));
                    log.debug((Object)(p.getName() + "/" + other.getID() + ": " + results[i] + ", " + Math.round(this.tms.get(i).floatValue()) + " \ufffdC"));
                }
            }
        }
    }

    int[] getPrimingPositions(NucleotideSequence primer, NucleotideSequence target) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        this.tms.clear();
        int tlen = target.length();
        if (tlen < this.matchLength) {
            return null;
        }
        String primerEnd = primer.subsequence(primer.length() - this.matchLength + 1, primer.length());
        String sequence = target.seqString();
        Pattern p = Pattern.compile(NucleotideSequenceHandler.getRevComp((String)primerEnd, (byte)primer.getType(), (byte)primer.getType()));
        Matcher m = p.matcher(sequence);
        int index = -1;
        while (m.find(index + 1)) {
            index = m.start();
            log.debug((Object)("  Match: " + target.getID() + ", pos " + index));
            String[] sequences = NucleotideSequenceHandler.getPossibleSequences((String)sequence.substring(index, Math.min(index + primer.length(), sequence.length() - 1)), (byte)target.getType());
            float maxTm = -3.4028235E38f;
            NAHybridStructure top = null;
            SimpleNucleotideSequence s1 = new SimpleNucleotideSequence(primer.getID(), primer.seqString(), primer.getType());
            for (int s = 0; s < sequences.length; ++s) {
                SimpleNucleotideSequence s2 = new SimpleNucleotideSequence("S2", sequences[s], target.getType());
                log.debug((Object)(s + ":  " + s1.seqString()));
                log.debug((Object)("    " + SequenceHandler.getRev((Sequence)s2)));
                NAHybridStructure hs = this.fmpc.calculateHybridStructure((NucleotideSequence)s1, (NucleotideSequence)s2);
                if (hs == null) continue;
                log.debug((Object)("      " + hs.getFirstString()));
                log.debug((Object)("      " + SequenceHandler.getRev((String)hs.getSecondString())));
                float Tm = this.fmpc.getMeltingPoint((NucleotideSequence)s1, (NucleotideSequence)s2, hs);
                log.debug((Object)("Tm = " + String.valueOf(Tm - 273.15f)));
                if (!(Tm > maxTm)) continue;
                maxTm = Tm;
                top = hs;
            }
            if (top == null || !(maxTm >= (float)this.limit)) continue;
            this.tms.add(new Float(maxTm));
            positions.add(index);
            log.debug((Object)("    " + top.getFirstString()));
            log.debug((Object)("    " + SequenceHandler.getRev((String)top.getSecondString())));
        }
        int[] result = new int[positions.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)positions.get(i);
        }
        return result;
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
    }
}

