/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import java.util.Collection;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DataHolderUtils;
import net.sf.apptools.data.IntegerDescriptor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.moltools.apps.probemaker.calculators.GapLigationCalculator;
import org.moltools.apps.probemaker.calculators.LigationTemplateCalculator;
import org.moltools.apps.probemaker.calculators.PadlockLigationCalculator;
import org.moltools.apps.probemaker.design.Analyzer;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.IncludeTypesFilter;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.data.Candidate;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GapFillPadlockLigationModule
extends AbstractProbeModule {
    protected transient LigationTemplateCalculator ltc = new GapLigationCalculator();

    public static String getBriefDescription() {
        return "Gap-fill padlock probe ligation";
    }

    public static String getLongDescription() {
        return "<html>Checks if a gap-fill padlock probe will template the ligation of itself or of another probe in the set. This is done by checking the 5' and 3' terminal nucleotides of the probe and searching for the complement of this sequence in the other probe. The number of bases required to match on either side is speicified by two parameters.<br>An error message is given if a matching sequence is found. A gap of one base is allowed between the two 5' and 3' sequences.</html>";
    }

    public GapFillPadlockLigationModule() {
        super(new TestDescriptor[]{new TestDescriptor("Gap-fill padlock probe self-ligation"), new TestDescriptor("Template for other probe")}, new DataDescriptor[]{new IntegerDescriptor("Min. 5' match length", "Minimum number of matching bases on 5' end", "PROBE_TEMPLATING_FIVE_MIN_LENGTH", 1, 100), new IntegerDescriptor("Min. 3' match length", "Minimum number of matching bases on 3' end", "PROBE_TEMPLATING_THREE_MIN_LENGTH", 1, 100)});
        this.setData("PROBE_TEMPLATING_FIVE_MIN_LENGTH", new Integer(((String)this.ltc.getParameters().get("PROBE_TEMPLATING_FIVE_MIN_LENGTH")).toString()));
        this.setData("PROBE_TEMPLATING_THREE_MIN_LENGTH", new Integer(((String)this.ltc.getParameters().get("PROBE_TEMPLATING_THREE_MIN_LENGTH")).toString()));
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (this.tests[0].perform()) {
            this.ltc.checkTemplatingBySelf(p);
        }
        if (this.tests[1].perform()) {
            this.ltc.checkTemplatingOthers(p, probes);
        }
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> probes) {
        for (Probe p : probes) {
            if (this.ltc.isLigationTemplate(t, p, false, false) == null) continue;
            return false;
        }
        return true;
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (this.tests[1].perform() && !CollectionUtils.select((Collection)ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)p), (Predicate)new IncludeTypesFilter(new MessageType[]{PadlockLigationCalculator.TEMPLATE_FOR_OTHER_PROBE})).isEmpty()) {
            for (Probe other : probes) {
                if (other == p || !other.tagsAllocated() || this.ltc.isLigationTemplate((NucleotideSequence)p, other, true, false) == null) continue;
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)other, (Message)new Message("May be templated by " + p.getName(), PadlockLigationCalculator.OTHER_PROBE_IS_TEMPLATE, 2));
                Analyzer.calculateAndSetQuality((Candidate)other);
            }
        }
    }

    public void reset() {
        this.ltc.setParameters(DataHolderUtils.getProperties((DataHolder)this));
    }
}

