/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import net.sf.apptools.data.BooleanDescriptor;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DataHolderUtils;
import net.sf.apptools.data.IntegerDescriptor;
import org.moltools.apps.probemaker.calculators.LigationTemplateCalculator;
import org.moltools.apps.probemaker.calculators.PadlockLigationCalculator;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PadlockTSSLigationModule
extends AbstractProbeModule {
    protected transient LigationTemplateCalculator ltc = new PadlockLigationCalculator();

    public static String getBriefDescription() {
        return "Padlock TSS ligation";
    }

    public static String getLongDescription() {
        return "<html>Checks if a padlock probe will be templated for ligation by another target in the set or by another probe in the probe set. Also checks if the probe will be templated for ligation by another part of its own target.<br>This is done by checking the 5' and 3' terminal nucleotides of the probe and searching for the complement of this sequence in the other probe. The number of bases required to match on either side is speicified by two parameters.<br>An error message is given if a matching sequence is found.<br>Optionally, the Tm of the probe-target hybrid should also exceed a given limit. Tm is then calculated by the algorithm described in:<p>Kaderali <i>et al.</i> (2003) Primer-design for multiplexed genotyping. <i>Nucleic Acids Res.</i>, <b>31</b>, 1796-1802.</html>";
    }

    public PadlockTSSLigationModule() {
        super(new TestDescriptor[]{new TestDescriptor("Templating by own target"), new TestDescriptor("Templating by self"), new TestDescriptor("Templating by other targets"), new TestDescriptor("Templating by other probes"), new TestDescriptor("Template of other probes")}, new DataDescriptor[]{new IntegerDescriptor("Min. target 5' match length", "Minimum number of matching bases on 5' end for targets", "TARGET_TEMPLATING_FIVE_MIN_LENGTH", 1, 100), new IntegerDescriptor("Min. target 3' match length", "Minimum number of matching bases on 3' end for targets", "TARGET_TEMPLATING_THREE_MIN_LENGTH", 1, 100), new IntegerDescriptor("Min. probe 5' match length", "Minimum number of matching bases on 5' end for probes", "PROBE_TEMPLATING_FIVE_MIN_LENGTH", 1, 100), new IntegerDescriptor("Min. probe 3' match length", "Minimum number of matching bases on 3' end for probes", "PROBE_TEMPLATING_THREE_MIN_LENGTH", 1, 100), new BooleanDescriptor("Use Tm limit", "Use a limit for Tm of probe-target hybrid", "USE_TM"), new IntegerDescriptor("Max. Tm", "Maximum Tm of probe-target hybrid at site of match.", "TM_LIMIT", 0, 100)});
        this.setData("TARGET_TEMPLATING_FIVE_MIN_LENGTH", new Integer(((String)this.ltc.getParameters().get("TARGET_TEMPLATING_FIVE_MIN_LENGTH")).toString()));
        this.setData("TARGET_TEMPLATING_THREE_MIN_LENGTH", new Integer(((String)this.ltc.getParameters().get("TARGET_TEMPLATING_THREE_MIN_LENGTH")).toString()));
        this.setData("PROBE_TEMPLATING_FIVE_MIN_LENGTH", new Integer(((String)this.ltc.getParameters().get("PROBE_TEMPLATING_FIVE_MIN_LENGTH")).toString()));
        this.setData("PROBE_TEMPLATING_THREE_MIN_LENGTH", new Integer(((String)this.ltc.getParameters().get("PROBE_TEMPLATING_THREE_MIN_LENGTH")).toString()));
        this.setData("USE_TM", new Boolean(((String)this.ltc.getParameters().get("USE_TM")).toString()));
        this.setData("TM_LIMIT", new Integer(((String)this.ltc.getParameters().get("TM_LIMIT")).toString()));
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (this.tests[0].perform()) {
            this.ltc.checkTemplatingByTarget(p);
        }
        if (this.tests[1].perform()) {
            this.ltc.checkTemplatingByArms(p);
        }
        if (this.tests[2].perform()) {
            this.ltc.checkTemplatingByOtherProbes(p, probes);
        }
        if (this.tests[3].perform()) {
            this.ltc.checkTemplatingByOtherTargets(p, probes);
        }
        if (this.tests[4].perform()) {
            this.ltc.checkArmsTemplatingOthers(p, probes);
        }
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> probes) {
        return true;
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
    }

    public void reset() {
        this.ltc.setParameters(DataHolderUtils.getProperties((DataHolder)this));
    }
}

