/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import net.sf.apptools.data.DataDescriptor;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagAllocationModule
extends AbstractProbeModule {
    public static String getBriefDescription() {
        return "Tag allocation";
    }

    public static String getLongDescription() {
        return "<html>Checks if all tags have been allocated. If there are too few tags in one or more of the tag libraries, the allocation will fail.<br>If all tags have not been allocated, a fatal message is given.</html>";
    }

    public TagAllocationModule() {
        super(new TestDescriptor[]{new TestDescriptor("Tag allocation")}, new DataDescriptor[0]);
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> probes) {
        return true;
    }

    public void doAnalysis(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> probes) {
        if (this.tests[0].perform() && p.getTags().size() < pd.getTagLibraries().length) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Probe does not contain all tags", TagAllocator.TAG_ALLOCATION, 3));
        }
    }

    public void reset() {
    }

    public void doConfirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<? extends Probe> otherProbes) {
    }
}

