/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.target;

import java.util.ArrayList;
import java.util.List;
import net.sf.apptools.plugin.PlugIn;
import org.moltools.apps.probemaker.ext.Messages;
import org.moltools.apps.probemaker.seq.Polymorphism;
import org.moltools.apps.probemaker.seq.Variant;
import org.moltools.apps.probemaker.seq.impl.AbstractComplexTarget;
import org.moltools.apps.probemaker.seq.impl.InDel;
import org.moltools.apps.probemaker.seq.impl.SNP;
import org.moltools.design.data.impl.SimpleSubSequenceTemplate;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.SequenceElement;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.SequenceStringElement;
import org.moltools.lib.seq.SequenceView;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.alphabet.Symbol;
import org.moltools.lib.seq.utils.SequenceBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlleleSpecificPadlockTarget
extends AbstractComplexTarget
implements SequenceView,
PlugIn {
    static SequenceBuilder<AlleleSpecificPadlockTarget> builder = SequenceBuilderFactory.getDefaultBuilder(AlleleSpecificPadlockTarget.class);
    protected Variant[] variants;
    protected Variant variant;

    public static SequenceBuilder<? extends AlleleSpecificPadlockTarget> getSequenceBuilder() {
        return builder;
    }

    public static String getBriefDescription() {
        return Messages.getString("AlleleSpecificPadlockTarget.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return Messages.getString("AlleleSpecificPadlockTarget.LONG_DESCRIPTION");
    }

    public AlleleSpecificPadlockTarget() {
        this("", "", "");
    }

    public AlleleSpecificPadlockTarget(String id, String seq, String desc) {
        this(id, seq, desc, 0);
    }

    public AlleleSpecificPadlockTarget(String id, String seq, String desc, byte typ) {
        super(id, seq, desc, typ);
        if (this.targetPoly == 0 && this.variantIndex == 0) {
            this.targetPoly = -1;
            this.variantIndex = -1;
        }
    }

    public AlleleSpecificPadlockTarget(AlleleSpecificPadlockTarget vt) {
        this.description = vt.description;
        this.sequence = vt.sequence;
        this.type = vt.type;
        this.targetPoly = vt.targetPoly;
        this.variantIndex = vt.variantIndex;
        this.variants = vt.variants;
        this.variant = vt.variant;
        this.pat5 = vt.pat5;
        this.pat3 = vt.pat3;
        this.setSequenceRepr(vt.seqString());
    }

    public void setSequence(String str) throws SequenceFormatException {
        if (str == null) {
            this.setSequenceRepr("");
        } else if (str == "") {
            this.setSequenceRepr(str);
        } else {
            String newSequenceRepr = null;
            ArrayList newSequence = new ArrayList();
            newSequenceRepr = this.parse(str, this.getType(), newSequence);
            this.setSequenceRepr(newSequenceRepr);
            this.sequence.clear();
            this.sequence.addAll(newSequence);
            this.setProbeArmTemplates();
            this.createVariants();
            this.setVariant();
        }
    }

    protected void createVariants() {
        Polymorphism[] polys = this.getPolys();
        ArrayList<PadlockVariant> v = new ArrayList<PadlockVariant>();
        for (int polyno = 0; polyno < polys.length; ++polyno) {
            PadlockVariant[] variants1 = PadlockVariant.getVariants(polys[polyno], polyno);
            for (int varno = 0; varno < variants1.length; ++varno) {
                v.add(variants1[varno]);
            }
        }
        for (int pos = 1; pos < this.length(); ++pos) {
            v.add(new PadlockVariant(pos));
        }
        this.variants = v.toArray(new PadlockVariant[v.size()]);
    }

    protected int getPolyPosition(int poly) {
        int pos = 1;
        int polyno = 0;
        for (SequenceElement e : this.sequence) {
            if (e instanceof Polymorphism) {
                ++polyno;
            }
            if (polyno == poly) {
                return pos;
            }
            pos += e.length();
        }
        throw new UnsupportedOperationException("No such polymorphism found");
    }

    public int getTargetPosition() {
        Polymorphism[] polys = this.getPolys();
        if (this.targetPoly == -1) {
            throw new UnsupportedOperationException("Target position not set");
        }
        if (this.targetPoly == 0) {
            if (this.variantIndex < 1 || this.variantIndex > this.length() - 1) {
                throw new UnsupportedOperationException("Invalid target position");
            }
            return this.variantIndex + 1;
        }
        if (this.targetPoly <= polys.length) {
            return this.getPolyPosition(this.targetPoly);
        }
        throw new UnsupportedOperationException("No such polymorphism found");
    }

    protected void setTemplateForFivePrimeArm() {
        int pos = this.getTargetPosition();
        this.pat5 = new SimpleSubSequenceTemplate((NucleotideSequence)this, "Template for 5' arm", this.getType(), 1, pos - 1, this.getID());
    }

    protected void setTemplateForThreePrimeArm() {
        SimpleSubSequenceTemplate template;
        block6: {
            Polymorphism poly;
            block8: {
                String tempID;
                block7: {
                    block5: {
                        tempID = "TEMPLATE|3|" + this.getID();
                        if (this.targetPoly != 0) break block5;
                        template = new SimpleSubSequenceTemplate((NucleotideSequence)this, "Template for 3' arm", this.getType(), this.getTargetPosition(), this.length(), this.getID());
                        break block6;
                    }
                    poly = this.getPolys()[this.targetPoly - 1];
                    if (!(poly instanceof SNP)) break block7;
                    Nucleotide n = (Nucleotide)poly.getVariants()[this.variantIndex];
                    if (n == null) {
                        throw new UnsupportedOperationException("No target nucleotide found");
                    }
                    String seq = this.subsequence(this.getTargetPosition() + 1, this.length());
                    String nt = String.valueOf(n.getChar());
                    String full = nt + seq;
                    template = new SimpleSubSequenceTemplate(tempID, full, this.getType(), this.getTargetPosition(), this.length(), this.getID());
                    break block6;
                }
                if (!(poly instanceof InDel)) break block8;
                switch (this.variantIndex) {
                    case 0: {
                        template = new SimpleSubSequenceTemplate((NucleotideSequence)this, tempID, this.getType(), this.getTargetPosition(), this.length(), this.getID());
                        break block6;
                    }
                    case 1: {
                        template = new SimpleSubSequenceTemplate((NucleotideSequence)this, tempID, this.getType(), this.getTargetPosition() + poly.length(), this.length(), this.getID());
                        break block6;
                    }
                    default: {
                        throw new UnsupportedOperationException("Invalid InDel mode specified");
                    }
                }
            }
            throw new UnsupportedOperationException("Unsupported Polymorphism type: " + poly.getClass());
        }
        this.pat3 = template;
    }

    protected void setVariant() {
        if (this.targetPoly < 0) {
            this.setVariant(null);
        } else if (this.targetPoly == 0) {
            int v = 0;
            for (int i = 0; i < this.variants.length; ++i) {
                if (this.variants[i].getVariantGroup().length != 1) continue;
                if (this.variantIndex == v + 1) {
                    this.setVariant(this.variants[i]);
                    break;
                }
                ++v;
            }
        } else {
            int v = 0;
            for (int i = 0; i < this.variants.length; ++i) {
                if (this.variants[i].getVariantGroup().length <= 1) continue;
                if (this.targetPoly == v + 1) {
                    this.setVariant(this.variants[i]);
                    break;
                }
                ++v;
            }
        }
    }

    public void setVariant(Variant var) {
        this.setSequenceRepr(AlleleSpecificPadlockTarget.sequenceOf((List)this.sequence));
        if (var instanceof PadlockVariant) {
            this.variant = var;
            PadlockVariant pv = (PadlockVariant)this.variant;
            if (pv.polyNumber >= 0) {
                this.targetPoly = pv.polyNumber + 1;
                this.variantIndex = pv.index;
            } else {
                this.targetPoly = 0;
                this.variantIndex = pv.position;
            }
        } else if (var == null) {
            this.targetPoly = -1;
            this.variantIndex = -1;
            this.variant = null;
        } else {
            throw new IllegalArgumentException("Invalid variant type");
        }
        if (this.targetPoly > 0) {
            Polymorphism poly = this.getPolys()[this.targetPoly - 1];
            int pos = this.getPolyPosition(this.targetPoly);
            int length = poly.length();
            String f = this.seqString().substring(0, pos - 1);
            String t = this.seqString().substring(pos + length - 1);
            String p = "";
            if (poly instanceof SNP) {
                p = String.valueOf(((Nucleotide)((SNP)poly).getVariants()[this.variantIndex]).getChar());
            } else if (poly instanceof InDel) {
                p = this.variantIndex == 0 ? ((InDel)poly).seqString() : "";
            } else {
                throw new UnsupportedOperationException("Polymorphism type not accepted");
            }
            this.setSequenceRepr(f + p + t);
        }
        this.setProbeArmTemplates();
    }

    public Variant getVariant() {
        return this.variant;
    }

    public Variant[] getVariants() {
        return this.variants;
    }

    public List<AlleleSpecificPadlockTarget> expand() {
        ArrayList<AlleleSpecificPadlockTarget> l = new ArrayList<AlleleSpecificPadlockTarget>();
        Polymorphism[] polys = this.getPolys();
        int polyIndex = -1;
        if (polys.length == 1) {
            polyIndex = 0;
            this.setVariant(this.variants[0]);
        } else if (this.targetPoly < 1) {
            l.add(this);
        } else if (this.targetPoly <= polys.length) {
            polyIndex = this.targetPoly - 1;
        } else {
            l.add(this);
        }
        if (polyIndex >= 0) {
            Variant[] varGroup = this.getVariant().getVariantGroup();
            Polymorphism poly = polys[polyIndex];
            for (int varno = 0; varno < varGroup.length; ++varno) {
                AlleleSpecificPadlockTarget vt = new AlleleSpecificPadlockTarget(this);
                vt.setVariant(varGroup[varno]);
                Object var = poly.getVariants()[varno];
                String appendage = var instanceof Symbol ? String.valueOf(((Symbol)var).getChar()) : var.toString();
                vt.setID(this.getID() + "|" + appendage);
                vt.setName((this.getName() == null ? this.getID() : this.getName()) + "|" + appendage);
                l.add(vt);
            }
        }
        return l;
    }

    public Polymorphism getTargetPoly() {
        if (this.targetPoly > 0) {
            return this.getPolys()[this.targetPoly - 1];
        }
        return null;
    }

    public byte isValidTarget() {
        Polymorphism[] polys = this.getPolys();
        if (!this.isValidPoly()) {
            return 1;
        }
        if (this.targetPoly < 0 || this.targetPoly > polys.length) {
            return 2;
        }
        if (this.targetPoly == 0) {
            if (this.variantIndex < 0 || this.variantIndex >= this.length()) {
                return 2;
            }
            return 0;
        }
        if (this.variantIndex < 0 || this.variantIndex >= polys[this.targetPoly - 1].getVariants().length) {
            return 2;
        }
        return 0;
    }

    public String getViewSequence() {
        StringBuffer viewString = new StringBuffer("");
        int pos = this.targetPoly == 0 ? this.variantIndex : -1;
        int index = 0;
        List el = this.getElements();
        for (int i = 0; i < el.size(); ++i) {
            SequenceStringElement se = (SequenceStringElement)el.get(i);
            if (se instanceof InDel) {
                viewString.append('[' + se.seqString() + ']');
                index += se.length();
            } else {
                viewString.append(se.seqString());
                index += se.length();
            }
            if (index != pos) continue;
            viewString.append('|');
        }
        return viewString.toString();
    }

    public byte getFivePrimeFixedEnd() {
        return 1;
    }

    public byte getThreePrimeFixedEnd() {
        return 2;
    }

    public static class PadlockVariant
    implements Variant {
        public final String description;
        public final Variant[] group;
        public final int polyNumber;
        public final int position;
        public final int index;

        public static PadlockVariant[] getVariants(Polymorphism poly, int polyno) {
            Object[] variants = poly.getVariants();
            Variant[] group = new PadlockVariant[variants.length];
            for (int i = 0; i < group.length; ++i) {
                group[i] = new PadlockVariant(poly, polyno, i, group);
            }
            return group;
        }

        public PadlockVariant(Polymorphism poly, int polyno, int index, Variant[] group) {
            Object var = poly.getVariants()[index];
            this.description = "SNP " + (polyno + 1) + ": " + (var instanceof Symbol ? String.valueOf(((Symbol)var).getChar()) : var.toString());
            this.polyNumber = polyno;
            this.index = index;
            this.group = group;
            this.position = -1;
        }

        public PadlockVariant(int value) {
            this.position = value;
            this.description = String.valueOf(this.position);
            this.group = new PadlockVariant[]{this};
            this.index = -1;
            this.polyNumber = -1;
        }

        public String getName() {
            return this.description;
        }

        public String toString() {
            return this.getName();
        }

        public Variant[] getVariantGroup() {
            return this.group;
        }
    }
}

