/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.target;

import java.util.ArrayList;
import java.util.List;
import net.sf.apptools.plugin.PlugIn;
import org.moltools.apps.probemaker.ext.Messages;
import org.moltools.apps.probemaker.ext.target.AlleleSpecificPadlockTarget;
import org.moltools.apps.probemaker.ext.target.GapFillPadlockTarget;
import org.moltools.apps.probemaker.seq.Polymorphism;
import org.moltools.apps.probemaker.seq.Variant;
import org.moltools.apps.probemaker.seq.impl.SNP;
import org.moltools.design.data.impl.SimpleSubSequenceTemplate;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.SequenceElement;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.seq.utils.SequenceBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinisequencingTarget
extends GapFillPadlockTarget
implements PlugIn {
    static SequenceBuilder<MinisequencingTarget> miniSeqBuilder = SequenceBuilderFactory.getDefaultBuilder(MinisequencingTarget.class);

    public static SequenceBuilder<MinisequencingTarget> getSequenceBuilder() {
        return miniSeqBuilder;
    }

    public static String getBriefDescription() {
        return Messages.getString("MinisequencingTarget.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return Messages.getString("MinisequencingTarget.LONG_DESCRIPTION");
    }

    public MinisequencingTarget() {
        this("", "", "");
    }

    public MinisequencingTarget(String id, String seq, String desc) {
        super(id, seq, desc);
    }

    public MinisequencingTarget(MinisequencingTarget vt) {
        super(vt);
    }

    @Override
    public void setVariant(Variant var) {
        this.variant = var;
        this.setSequenceRepr(MinisequencingTarget.sequenceOf((List)this.sequence));
        if (this.variant instanceof MinisequencingTargetVariant) {
            boolean switchPol;
            MinisequencingTargetVariant mtv = (MinisequencingTargetVariant)this.variant;
            boolean bl = this.variantIndex < 0 ? false : (switchPol = mtv.polarity != this.variantIndex);
            if (switchPol) {
                try {
                    this.setSequence(NucleotideSequenceHandler.getRevComp((NucleotideSequence)this));
                }
                catch (SequenceFormatException sfx) {
                    throw new RuntimeException("Incorrect sequence format", sfx);
                }
                this.targetPoly = this.countPolys() - mtv.polyNumber - 1;
            } else {
                this.targetPoly = mtv.polyNumber;
            }
            this.variantIndex = mtv.polarity;
        } else if (this.variant == null) {
            this.targetPoly = -1;
            this.variantIndex = -1;
        } else {
            throw new IllegalArgumentException("Invalid variant type");
        }
        this.setProbeArmTemplates();
    }

    @Override
    public Variant getVariant() {
        return this.variant;
    }

    @Override
    protected void createVariants() {
        Polymorphism[] polys = this.getPolys();
        ArrayList<Variant> v = new ArrayList<Variant>();
        for (int polyno = 0; polyno < polys.length; ++polyno) {
            Polymorphism poly = polys[polyno];
            if (!(poly instanceof SNP)) continue;
            Variant[] group = MinisequencingTargetVariant.getGroup(polyno);
            v.add(group[0]);
            v.add(group[1]);
        }
        this.variants = v.toArray(new Variant[v.size()]);
    }

    @Override
    public Variant[] getVariants() {
        return this.variants;
    }

    @Override
    public List<AlleleSpecificPadlockTarget> expand() {
        ArrayList<AlleleSpecificPadlockTarget> l = new ArrayList<AlleleSpecificPadlockTarget>();
        Polymorphism[] polys = this.getPolys();
        int polyIndex = -1;
        if (this.targetPoly < polys.length) {
            polyIndex = this.targetPoly;
        } else {
            l.add(this);
        }
        if (polyIndex >= 0) {
            for (int i = 0; i < 2; ++i) {
                MinisequencingTarget vt = new MinisequencingTarget(this);
                vt.setVariant(this.variant.getVariantGroup()[i]);
                String appendage = i == 0 ? " +" : " -";
                vt.setID(this.getID() + "|" + appendage);
                vt.setName((this.getName() == null ? this.getID() : this.getName()) + appendage);
                l.add(vt);
            }
        }
        return l;
    }

    @Override
    protected int getPolyPosition(int poly) {
        int pos = 1;
        int polyno = -1;
        for (SequenceElement e : this.sequence) {
            if (e instanceof Polymorphism) {
                ++polyno;
            }
            if (polyno == poly) {
                return pos;
            }
            pos += e.length();
        }
        throw new UnsupportedOperationException("No such polymorphism found");
    }

    @Override
    public int getTargetPosition() {
        Polymorphism[] polys = this.getPolys();
        if (this.targetPoly == -1) {
            throw new UnsupportedOperationException("Target position not set");
        }
        if (this.targetPoly < polys.length) {
            int polyPos = this.getPolyPosition(this.targetPoly);
            return polyPos;
        }
        throw new UnsupportedOperationException("No such polymorphism found");
    }

    @Override
    public byte isValidTarget() {
        Polymorphism[] polys = this.getPolys();
        if (!this.isValidPoly()) {
            return 1;
        }
        if (this.targetPoly < 0 || this.targetPoly > polys.length) {
            return 2;
        }
        if (this.variantIndex < 0) {
            return 2;
        }
        return 0;
    }

    @Override
    protected void setTemplateForThreePrimeArm() {
        SimpleSubSequenceTemplate temp = null;
        Polymorphism[] polys = this.getPolys();
        if (this.targetPoly >= 0 && this.targetPoly < polys.length) {
            Polymorphism poly = polys[this.targetPoly];
            if (poly instanceof SNP) {
                temp = this.variantIndex == 1 ? new SimpleSubSequenceTemplate((NucleotideSequence)this, "Template for primer +", this.getType(), this.getTargetPosition() + 1, this.length(), this.getID()) : new SimpleSubSequenceTemplate((NucleotideSequence)this, "Template for primer -", this.getType(), this.getTargetPosition() + 1, this.length(), this.getID());
            } else {
                throw new UnsupportedOperationException("Unsupported Polymorphism type: " + poly.getClass());
            }
        }
        this.pat3 = temp;
    }

    @Override
    protected void setTemplateForFivePrimeArm() {
        this.pat5 = null;
    }

    protected SimpleSubSequenceTemplate getTemplateForFivePrime() {
        return null;
    }

    @Override
    public String getViewSequence() {
        return this.seqString();
    }

    public static class MinisequencingTargetVariant
    implements Variant {
        public final int polarity;
        public final int polyNumber;
        public final String description;
        public final Variant[] group;

        public static Variant[] getGroup(int polyno) {
            Variant[] group;
            group = new MinisequencingTargetVariant[]{new MinisequencingTargetVariant(polyno, 0, group), new MinisequencingTargetVariant(polyno, 1, group)};
            return group;
        }

        public MinisequencingTargetVariant(int polyno, int polarity, Variant[] group) {
            this.description = "SNP " + (polyno + 1);
            this.polarity = polarity;
            this.group = group;
            this.polyNumber = polyno;
        }

        public String getName() {
            return this.description + " " + (this.polarity == 0 ? "+" : "-");
        }

        public String toString() {
            return this.getName();
        }

        public Variant[] getVariantGroup() {
            return this.group;
        }
    }
}

