/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.target;

import java.util.Map;
import net.sf.apptools.plugin.PlugIn;
import org.moltools.apps.probemaker.ext.Messages;
import org.moltools.apps.probemaker.seq.impl.AbstractProbeMakerPositionTarget;
import org.moltools.design.data.TargettedSequence;
import org.moltools.design.data.impl.SimpleSubSequenceTemplate;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.PolarSubSequenceDescriptor;
import org.moltools.lib.seq.SequenceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorTarget
extends AbstractProbeMakerPositionTarget
implements PolarSubSequenceDescriptor,
PlugIn {
    static final SequenceBuilder<SelectorTarget> builder = new SequenceBuilder<SelectorTarget>(){

        public SelectorTarget buildObject(Map<String, String> sequenceData) {
            String seqData = sequenceData.get("sequence.seqstring");
            String seq = seqData.toUpperCase();
            String name = sequenceData.get("sequence.name");
            String id = sequenceData.get("ID");
            String parent = sequenceData.get("subsequence.parentID");
            String startStr = sequenceData.get("subsequence.start");
            String endStr = sequenceData.get("subsequence.end");
            if (id == null) {
                id = "";
            }
            if (parent == null) {
                parent = "";
            }
            Integer start = startStr == null ? new Integer(-1) : Integer.parseInt(startStr);
            Integer end = endStr == null ? new Integer(-1) : Integer.parseInt(endStr);
            SelectorTarget t = new SelectorTarget(seq, name, id, parent, start, end);
            return t;
        }
    };
    protected int start;
    protected int end;
    protected String parentID;

    public static SequenceBuilder<SelectorTarget> getSequenceBuilder() {
        return builder;
    }

    public static String getBriefDescription() {
        return Messages.getString("SelectorTarget.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return Messages.getString("SelectorTarget.LONG_DESCRIPTION");
    }

    public SelectorTarget() {
        this("", "", "", "", 0, 0);
    }

    public SelectorTarget(String seq, String name, String id, String parent, int start, int end) {
        super(id, seq, (byte)0, name);
        this.parentID = parent;
        this.start = start;
        this.end = end;
    }

    protected TargettedSequence getTemplateForFivePrime() {
        return new SimpleSubSequenceTemplate((NucleotideSequence)this, "Template for 5' arm", this.getType(), this.targetPos + 1, this.length(), this.getID());
    }

    protected TargettedSequence getTemplateForThreePrime() {
        return new SimpleSubSequenceTemplate((NucleotideSequence)this, "Template for 3' arm", this.getType(), this.targetPos + 1, this.length(), this.getID());
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public byte getPolarity() {
        return 1;
    }

    public String getParentID() {
        return this.parentID;
    }

    public byte getFivePrimeFixedEnd() {
        return 2;
    }

    public byte getThreePrimeFixedEnd() {
        return 1;
    }
}

