/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.ext.conv;

import net.sf.apptools.plugin.PlugIn;
import org.moltools.workbench.ext.Messages;
import org.moltools.workbench.ext.SequenceConverter;

public class ParanthesesConverter
implements SequenceConverter,
PlugIn {
    public static final char openSymbol = '(';
    public static final char closeSymbol = ')';
    public static final char separatorSymbol = '/';
    public static final char inDelBeginSymbol = '[';
    public static final char inDelEndSymbol = ']';

    public Object transform(Object obj) {
        String seqstr = (String)obj;
        String str = "";
        boolean foundOpen = false;
        boolean removeNextClose = false;
        int openSymbolAt = -1;
        for (int pos = 0; pos < seqstr.length(); ++pos) {
            char c = seqstr.charAt(pos);
            if (c == '(') {
                foundOpen = true;
                openSymbolAt = pos;
                str = str + '[';
                continue;
            }
            if (c == '/') {
                if (foundOpen && openSymbolAt == pos - 2) {
                    removeNextClose = true;
                    str = str.substring(0, openSymbolAt) + seqstr.charAt(pos - 1);
                }
                foundOpen = false;
                str = str + c;
                continue;
            }
            if (c == ')') {
                if (removeNextClose) {
                    removeNextClose = false;
                } else {
                    str = str + ']';
                }
                foundOpen = false;
                continue;
            }
            str = str + c;
        }
        return str;
    }

    public static String getBriefDescription() {
        return Messages.getString("ParanthesesConverter.BRIEF_DESCRIPTION");
    }

    public static String getLongDescription() {
        return Messages.getString("ParanthesesConverter.LONG_DESCRIPTION");
    }
}

