/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.ext.ops;

import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import net.sf.apptools.plugin.AbstractParameterPlugIn;
import org.moltools.lib.Renameable;
import org.moltools.lib.seq.ChangeableSequence;
import org.moltools.lib.seq.SequenceEdit;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.impl.SimpleSequenceEdit;
import org.moltools.workbench.ext.SequenceOperation;

public class Subsequence
extends AbstractParameterPlugIn
implements SequenceOperation {
    public static final String KEY_BEGIN = "BEGIN";
    public static final String KEY_END = "END";
    static final DataDescriptor[] descriptors = new DataDescriptor[]{new IntegerDescriptor("Start position", "Start position (inclusive)", "BEGIN", 1, Integer.MAX_VALUE), new IntegerDescriptor("End position", "End position (inclusive)", "END", 1, Integer.MAX_VALUE)};
    boolean changename = true;

    public static String getBriefDescription() {
        return "Subsequence";
    }

    public static String getLongDescription() {
        return "Change to a subsequence";
    }

    public Subsequence() {
        super(descriptors);
    }

    public void operate(ChangeableSequence s) throws SequenceFormatException {
        int endpos;
        int beginpos = (Integer)this.getData(KEY_BEGIN);
        if (beginpos > (endpos = ((Integer)this.getData(KEY_END)).intValue())) {
            throw new IllegalArgumentException("Begin position greater than end position");
        }
        SimpleSequenceEdit edit1 = new SimpleSequenceEdit(1, beginpos - 1, "");
        SimpleSequenceEdit edit2 = new SimpleSequenceEdit(endpos + 1, s.length() - endpos, "");
        s.edit((SequenceEdit)edit1);
        s.edit((SequenceEdit)edit2);
        String add = "|SubSeq " + beginpos + ":" + endpos;
        if (this.changename) {
            s.setID(s.getID() + add);
            if (s instanceof Renameable) {
                Renameable n = (Renameable)s;
                n.setName(n.getName() + add);
            }
        }
    }
}

