/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.gui;

import java.awt.Font;
import javax.swing.JTextArea;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.utils.SequenceHandler;
import org.moltools.lib.struct.NAHybridStructure;
import org.moltools.lib.struct.NASecStructure;

public class StructureViewer
extends JTextArea {
    private static final long serialVersionUID = 1L;
    protected NAHybridStructure struct;
    protected NucleotideSequence sequence;
    protected NucleotideSequence sequence2;

    public StructureViewer() {
        super("");
        this.setFont(new Font("monospaced", 0, 12));
        this.setEditable(false);
    }

    public StructureViewer(NucleotideSequence seq, NASecStructure struct) {
        this();
        this.setStructure(seq, struct);
    }

    public StructureViewer(NucleotideSequence seq1, NucleotideSequence seq2, NAHybridStructure struct) {
        this();
        this.setStructure(seq1, seq2, struct);
    }

    protected void setStructure(NucleotideSequence seq, NASecStructure s) {
        this.sequence = seq;
        this.sequence2 = seq;
        this.struct = s;
    }

    public void setStructure(NucleotideSequence seq1, NucleotideSequence seq2, NAHybridStructure s) {
        this.sequence = seq1;
        this.sequence2 = seq2;
        this.struct = s;
    }

    public String getText() {
        if (this.struct == null) {
            return "No structure";
        }
        String structString = "";
        String nl = System.getProperty("line.separator", "\n");
        int fs = Math.min(this.struct.getFirstStart(), this.struct.getFirstEnd());
        int fe = Math.max(this.struct.getFirstStart(), this.struct.getFirstEnd());
        int ss = Math.min(this.sequence2.length() - this.struct.getSecondStart() + 1, this.sequence2.length() - this.struct.getSecondEnd() + 1);
        int se = Math.max(this.sequence2.length() - this.struct.getSecondStart() + 1, this.sequence2.length() - this.struct.getSecondEnd() + 1);
        if (this.struct instanceof NASecStructure) {
            int i;
            NASecStructure structure = (NASecStructure)this.struct;
            ss = this.struct.getSecondStart();
            se = this.struct.getSecondEnd();
            int len = this.sequence.length();
            String seqRev = SequenceHandler.getRev((Sequence)this.sequence);
            String strRev = SequenceHandler.getRev((String)structure.getSecondString());
            int firstdistance = fs - 1;
            int seconddistance = len - se;
            int distance = Math.max(firstdistance, seconddistance);
            for (i = 0; i < distance - firstdistance; ++i) {
                structString = structString + " ";
            }
            for (i = 1; i < fs; ++i) {
                structString = structString + Character.toLowerCase(this.sequence.getNucleotideAt(i).getChar());
            }
            for (i = 0; i < structure.getFirstString().length(); ++i) {
                structString = structString + structure.getFirstString().charAt(i);
            }
            for (i = fe + 1; i <= fe + (ss - fe) / 2; ++i) {
                structString = structString + Character.toLowerCase(this.sequence.getNucleotideAt(i).getChar());
            }
            structString = structString + nl;
            for (i = 0; i < distance - seconddistance; ++i) {
                structString = structString + " ";
            }
            for (i = 1; i < len - se + 1; ++i) {
                structString = structString + Character.toLowerCase(seqRev.charAt(i - 1));
            }
            for (i = 0; i < structure.getSecondString().length(); ++i) {
                structString = structString + strRev.charAt(i);
            }
            for (i = ss - 1; i > fe + (ss - fe) / 2; --i) {
                structString = structString + Character.toLowerCase(this.sequence.getNucleotideAt(i).getChar());
            }
        } else {
            int i;
            NAHybridStructure structure = this.struct;
            String seq2Rev = SequenceHandler.getRev((Sequence)this.sequence2);
            String str2Rev = SequenceHandler.getRev((String)structure.getSecondString());
            int firstdistance = fs - 1;
            int seconddistance = ss - 1;
            int distance = Math.max(firstdistance, seconddistance);
            for (i = 0; i < distance - firstdistance; ++i) {
                structString = structString + " ";
            }
            for (i = 1; i < fs; ++i) {
                structString = structString + Character.toLowerCase(this.sequence.getNucleotideAt(i).getChar());
            }
            for (i = 0; i < structure.getFirstString().length(); ++i) {
                structString = structString + structure.getFirstString().charAt(i);
            }
            for (i = fe + 1; i <= this.sequence.length(); ++i) {
                structString = structString + Character.toLowerCase(this.sequence.getNucleotideAt(i).getChar());
            }
            structString = structString + nl;
            for (i = 0; i < distance - seconddistance; ++i) {
                structString = structString + " ";
            }
            for (i = 1; i < ss; ++i) {
                structString = structString + Character.toLowerCase(seq2Rev.charAt(i - 1));
            }
            for (i = 0; i < structure.getSecondString().length(); ++i) {
                structString = structString + str2Rev.charAt(i);
            }
            for (i = se + 1; i <= this.sequence2.length(); ++i) {
                structString = structString + Character.toLowerCase(seq2Rev.charAt(i - 1));
            }
        }
        return structString;
    }

    public void printStructure() {
        if (this.struct == null) {
            this.setText("No structure");
            return;
        }
        String structString = this.getText();
        this.setText(structString);
    }
}

