/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker;

import java.util.ArrayList;
import java.util.List;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.utils.SymbolContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeSummarizer
extends SymbolContent {
    private ProbeSummarizer() {
    }

    public static int getQualityCount(DefiniteSequenceDB<? extends Probe> probes, byte quality) {
        int count = 0;
        for (Probe p : probes) {
            if (ProbeMakerPropertyUtils.getRank(p) != quality) continue;
            ++count;
        }
        return count;
    }

    public static List<MessageSummaryEntry> getMessageSummary(DefiniteSequenceDB<? extends Probe> probes) {
        ArrayList<MessageSummaryEntry> l = new ArrayList<MessageSummaryEntry>();
        for (Probe p : probes) {
            for (Message m : ProbeMakerPropertyUtils.getAllMessages(p)) {
                MessageType t = m.getType();
                byte s = m.getSeverity();
                boolean found = false;
                for (MessageSummaryEntry mse : l) {
                    if (!mse.isMatch(t, s)) continue;
                    ++mse.count;
                    found = true;
                }
                if (found) continue;
                l.add(new MessageSummaryEntry(t, s));
            }
        }
        return l;
    }

    public static class MessageSummaryEntry {
        public MessageType type;
        public int severity;
        public int count;

        MessageSummaryEntry(MessageType type, int severity) {
            this.type = type;
            this.severity = severity;
            this.count = 1;
        }

        boolean isMatch(MessageType type1, int severity1) {
            return this.type.equals(type1) && this.severity == severity1;
        }
    }
}

