/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.moltools.apps.probemaker.design.CandidateAnalysisModule;
import org.moltools.apps.probemaker.design.ProbeAcceptor;
import org.moltools.apps.probemaker.design.ProbeSelector;
import org.moltools.apps.probemaker.design.SpacerLibrary;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.design.TagLibrary;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.messages.SeverityFilter;
import org.moltools.apps.probemaker.modules.ProbeAnalysisModule;
import org.moltools.apps.probemaker.project.Settings;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.impl.TSSPair;
import org.moltools.design.calc.MeltingPointCalculator;
import org.moltools.design.data.Candidate;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.IndexedSequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.struct.DefaultNAHybridStructure;
import org.moltools.lib.struct.NAHybridStructure;
import org.moltools.lib.struct.UnsupportedHybridStructureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer {
    public static final String PROP_ACCEPT_EACH_TEST = "ACCEPT_EACH_TEST";
    public static final String PROP_ACCEPT_OK_ARMS = "ACCEPT_OK_ARMS";
    public static final String PROP_ACCEPT_OK_CANDIDATES = "ACCEPT_OK_CANDIDATES";
    protected List<CandidateAnalysisModule> armModules;
    protected List<CandidateAnalysisModule> candidateModulesStage1;
    protected List<CandidateAnalysisModule> candidateModulesStage2;
    protected boolean testAfterEachModule;
    protected boolean acceptFairTSSPairs;
    protected boolean acceptFairCandidates;
    protected ProbeAcceptor acceptor;
    protected ProbeSelector selector;
    static MessageType MESSAGE_TYPE_TEMP_CALC = new MessageType("TEMPERATUR_CALCULATION", "Temperature calculation");

    public Analyzer(Settings settings, ProbeAcceptor acc, ProbeSelector sel) {
        this.acceptor = acc;
        this.selector = sel;
        this.armModules = new ArrayList<CandidateAnalysisModule>();
        this.candidateModulesStage1 = new ArrayList<CandidateAnalysisModule>();
        this.candidateModulesStage2 = new ArrayList<CandidateAnalysisModule>();
        this.testAfterEachModule = Boolean.valueOf(settings.getDesignParameters().get(PROP_ACCEPT_EACH_TEST));
        this.acceptFairTSSPairs = Boolean.valueOf(settings.getDesignParameters().get(PROP_ACCEPT_OK_ARMS));
        this.acceptFairCandidates = Boolean.valueOf(settings.getDesignParameters().get(PROP_ACCEPT_OK_CANDIDATES));
        this.addArmModules(settings.getArmModules());
        this.addCandidateModules(settings.getCandidateModulesStage1(), 1);
        this.addCandidateModules(settings.getCandidateModulesStage2(), 2);
        for (CandidateAnalysisModule m : this.armModules) {
            m.reset();
        }
        for (CandidateAnalysisModule m : this.candidateModulesStage1) {
            m.reset();
        }
        for (CandidateAnalysisModule m : this.candidateModulesStage2) {
            m.reset();
        }
    }

    protected void addCandidateModules(List<CandidateAnalysisModule> modules, int stage) {
        switch (stage) {
            case 1: {
                this.candidateModulesStage1.addAll(modules);
                break;
            }
            case 2: {
                this.candidateModulesStage2.addAll(modules);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Stage " + stage + " not supported");
            }
        }
    }

    protected void addArmModules(List<CandidateAnalysisModule> modules) {
        this.armModules.addAll(modules);
    }

    public void confirmUpdate(Probe p, TagAllocator pd, DefiniteSequenceDB<Probe> probeset) {
        for (ProbeAnalysisModule probeAnalysisModule : this.armModules) {
            probeAnalysisModule.doConfirmUpdate(p, pd, probeset);
        }
        for (ProbeAnalysisModule probeAnalysisModule : this.candidateModulesStage1) {
            probeAnalysisModule.doConfirmUpdate(p, pd, probeset);
        }
        for (ProbeAnalysisModule probeAnalysisModule : this.candidateModulesStage2) {
            probeAnalysisModule.doConfirmUpdate(p, pd, probeset);
        }
    }

    public byte analyzeTSSPair(Probe p, TagAllocator pd, DefiniteSequenceDB<Probe> probes) {
        Analyzer.analyzeProbe(p, this.armModules, pd, probes);
        if (this.acceptor.overridesTSSDecision()) {
            return this.acceptor.acceptArms(p);
        }
        switch (ProbeMakerPropertyUtils.getRank(p)) {
            case 1: {
                return 0;
            }
            case 2: {
                return this.acceptFairTSSPairs ? (byte)2 : 0;
            }
            case 3: {
                return 2;
            }
        }
        throw new UnsupportedOperationException("Cannot accept/reject probe arms if quality not set");
    }

    public byte analyzeCandidateStage1(Probe p, TagAllocator pd, DefiniteSequenceDB<Probe> probeset) {
        ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)p);
        if (this.testAfterEachModule) {
            Iterator<CandidateAnalysisModule> i = this.candidateModulesStage1.iterator();
            while (i.hasNext()) {
                byte accept;
                ArrayList<CandidateAnalysisModule> l = new ArrayList<CandidateAnalysisModule>();
                l.add(i.next());
                Analyzer.analyzeProbe(p, l, pd, probeset);
                if (this.acceptor.overridesCandidateDecision()) {
                    accept = this.acceptor.acceptPrimary(p);
                } else {
                    switch (ProbeMakerPropertyUtils.getRank(p)) {
                        case 1: {
                            accept = 0;
                            break;
                        }
                        case 2: {
                            accept = this.acceptFairCandidates ? (byte)2 : 0;
                            break;
                        }
                        case 3: {
                            accept = 2;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Cannot accept/reject a candidate if quality not set");
                        }
                    }
                }
                if (accept != 0) continue;
                return accept;
            }
        } else {
            Analyzer.analyzeProbe(p, this.candidateModulesStage1, pd, probeset);
        }
        if (this.acceptor.overridesCandidateDecision()) {
            return this.acceptor.acceptPrimary(p);
        }
        switch (ProbeMakerPropertyUtils.getRank(p)) {
            case 1: {
                return 0;
            }
            case 2: {
                return this.acceptFairCandidates ? (byte)2 : 0;
            }
            case 3: {
                return 2;
            }
        }
        throw new UnsupportedOperationException("Cannot accept/reject a candidate if quality not set");
    }

    public byte analyzeCandidateStage2(Probe p, TagAllocator pd, DefiniteSequenceDB<Probe> probeset) {
        if (this.testAfterEachModule) {
            Iterator<CandidateAnalysisModule> i = this.candidateModulesStage1.iterator();
            while (i.hasNext()) {
                byte accept;
                ArrayList<CandidateAnalysisModule> l = new ArrayList<CandidateAnalysisModule>();
                l.add(i.next());
                Analyzer.analyzeProbe(p, l, pd, probeset);
                if (this.acceptor.overridesCandidateDecision()) {
                    accept = this.acceptor.acceptPrimary(p);
                } else {
                    switch (ProbeMakerPropertyUtils.getRank(p)) {
                        case 1: {
                            accept = 0;
                            break;
                        }
                        case 2: {
                            accept = this.acceptFairCandidates ? (byte)2 : 0;
                            break;
                        }
                        case 3: {
                            accept = 2;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Cannot accept/reject a candidate if quality not set");
                        }
                    }
                }
                if (accept != 0) continue;
                return accept;
            }
        } else {
            Analyzer.analyzeProbe(p, this.candidateModulesStage2, pd, probeset);
        }
        return this.acceptor.accept(p);
    }

    public Probe selectProbe(DefiniteSequenceDB<Probe> candidates) {
        ListSequenceDB db = new ListSequenceDB(candidates);
        return this.selector.getBest((IndexedSequenceDB<Probe>)db);
    }

    public Collection<Integer>[] screenTags(TagLibrary[] libraries, DefiniteSequenceDB<Probe> probeset) {
        ArrayList<CandidateAnalysisModule> modules = new ArrayList<CandidateAnalysisModule>(this.armModules);
        modules.addAll(this.candidateModulesStage1);
        modules.addAll(this.candidateModulesStage2);
        Collection[] badTags = new Collection[libraries.length];
        for (int i = 0; i < badTags.length; ++i) {
            badTags[i] = new HashSet();
            TagLibrary library = libraries[i];
            if (library instanceof SpacerLibrary) continue;
            for (int tagno = 0; tagno < libraries[i].size(); ++tagno) {
                NucleotideSequence t = (NucleotideSequence)libraries[i].getSequenceAt(tagno);
                for (ProbeAnalysisModule probeAnalysisModule : modules) {
                    if (probeAnalysisModule.acceptTag(t, probeset)) continue;
                    badTags[i].add(new Integer(tagno));
                }
            }
        }
        return badTags;
    }

    public static short calculateAndSetQuality(Candidate c) {
        Collection<Message> allMessages = ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)c);
        int worst = 3;
        Collection messages = CollectionUtils.select(allMessages, (Predicate)new SeverityFilter(1));
        if (!messages.isEmpty()) {
            worst = 2;
        }
        if (!(messages = CollectionUtils.select(allMessages, (Predicate)new SeverityFilter(2))).isEmpty()) {
            worst = 1;
        }
        if (!(messages = CollectionUtils.select(allMessages, (Predicate)new SeverityFilter(3))).isEmpty()) {
            worst = 1;
        }
        ProbeMakerPropertyUtils.setRank((PropertyAcceptor)c, (short)worst);
        return ProbeMakerPropertyUtils.getRank((PropertyHolder)c);
    }

    public static void analyzeCandidate(Candidate c, List<CandidateAnalysisModule> modules) {
        for (CandidateAnalysisModule am : modules) {
            am.doAnalysis(c);
        }
        Analyzer.calculateAndSetQuality(c);
    }

    public static void analyzeProbe(Probe p, List<CandidateAnalysisModule> modules, TagAllocator pd, DefiniteSequenceDB<Probe> probeset) {
        for (ProbeAnalysisModule probeAnalysisModule : modules) {
            probeAnalysisModule.doAnalysis(p, pd, probeset);
        }
        Analyzer.calculateAndSetQuality(p);
    }

    public static void calculateArmTemperatures(TSSPair p, MeltingPointCalculator defaultMpc, MeltingPointCalculator backupMpc) {
        float Tm;
        DefaultNAHybridStructure st;
        int secend;
        int secstart;
        NucleotideSequence temp;
        MessageType mt = new MessageType("TEMPERATUR_CALCULATION", "Temperature calculation");
        ProbeMakerTarget t = null;
        try {
            t = (ProbeMakerTarget)p.getTarget();
            if (p.getTarget() == null) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, new Message("No target found. Calculated hybridization temperature based on full match", mt, 0));
            }
        }
        catch (ClassCastException ccx) {
            ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, new Message("Not a ProbeMakerTarget. Calculated hybridization temperature based on full match", mt, 0));
        }
        try {
            PropertyAcceptorNucleotideSequence five = (PropertyAcceptorNucleotideSequence)p.getSequence("FIVE_PRIME");
            if (five != null) {
                ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)five);
                if (five.length() > 0) {
                    if (t != null) {
                        temp = (NucleotideSequence)p.getTarget().getTemplateCluster().getSequence("FIVE_PRIME");
                        if (temp != null) {
                            secstart = t.getFivePrimeFixedEnd() == 2 ? 1 : temp.length() - five.length() + 1;
                            secend = t.getFivePrimeFixedEnd() == 2 ? five.length() : temp.length();
                            st = new DefaultNAHybridStructure((Sequence)five, 1, five.length(), (Sequence)temp, secstart, secend);
                            Tm = Analyzer.calculateTm(five, temp, (NAHybridStructure)st, defaultMpc, backupMpc);
                            ProbeMakerPropertyUtils.setHybridizationTemp((PropertyAcceptor)five, Tm);
                        }
                    } else {
                        Tm = Analyzer.calculateFullMatchTm(five, defaultMpc, backupMpc);
                        ProbeMakerPropertyUtils.setHybridizationTemp((PropertyAcceptor)five, Tm);
                    }
                }
            }
        }
        catch (ClusterException e) {
            // empty catch block
        }
        try {
            PropertyAcceptorNucleotideSequence three = (PropertyAcceptorNucleotideSequence)p.getSequence("THREE_PRIME");
            if (three != null) {
                ProbeMakerPropertyUtils.clearMessages((PropertyAcceptor)three);
                if (three.length() > 0) {
                    if (t != null) {
                        temp = (NucleotideSequence)p.getTarget().getTemplateCluster().getSequence("THREE_PRIME");
                        if (temp != null) {
                            secstart = t.getThreePrimeFixedEnd() == 2 ? 1 : temp.length() - three.length() + 1;
                            secend = t.getThreePrimeFixedEnd() == 2 ? three.length() : temp.length();
                            st = new DefaultNAHybridStructure((Sequence)three, 1, three.length(), (Sequence)temp, secstart, secend);
                            Tm = Analyzer.calculateTm(three, temp, (NAHybridStructure)st, defaultMpc, backupMpc);
                            ProbeMakerPropertyUtils.setHybridizationTemp((PropertyAcceptor)three, Tm);
                        }
                    } else {
                        Tm = Analyzer.calculateFullMatchTm(three, defaultMpc, backupMpc);
                        ProbeMakerPropertyUtils.setHybridizationTemp((PropertyAcceptor)three, Tm);
                    }
                }
            }
        }
        catch (ClusterException e) {
            // empty catch block
        }
    }

    public static float calculateTm(PropertyAcceptorNucleotideSequence tss, NucleotideSequence temp, NAHybridStructure st, MeltingPointCalculator defaultMpc, MeltingPointCalculator backupMpc) {
        float Tm = 0.0f;
        try {
            Tm = defaultMpc.getMeltingPoint((NucleotideSequence)tss, temp, st);
        }
        catch (UnsupportedHybridStructureException ex1) {
            try {
                Tm = backupMpc.getMeltingPoint((NucleotideSequence)tss, temp, st);
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)tss, new Message("Approximate temp. calculation used", MESSAGE_TYPE_TEMP_CALC, 0));
            }
            catch (UnsupportedHybridStructureException ex2) {
                throw new UnsupportedOperationException("Could not calculate Tm for " + tss.getID() + "-" + temp.getID());
            }
        }
        return Tm;
    }

    public static float calculateFullMatchTm(PropertyAcceptorNucleotideSequence tss, MeltingPointCalculator defaultMpc, MeltingPointCalculator backupMpc) {
        float Tm = 0.0f;
        Tm = defaultMpc.getMeltingPoint((NucleotideSequence)tss);
        return Tm;
    }
}

