/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.project;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.moltools.apps.probemaker.project.ProjectTemplate;
import org.moltools.apps.probemaker.project.TemplateIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainTemplateIO
implements TemplateIO {
    public static final String REM_INDICATOR = "#";

    @Override
    public List<ProjectTemplate> loadProjectTemplates(Reader in) throws IOException {
        ArrayList<ProjectTemplate> l = new ArrayList<ProjectTemplate>();
        BufferedReader r = new BufferedReader(in);
        ProjectTemplate template = null;
        String line = "";
        StringBuffer description = new StringBuffer("");
        int state = 0;
        while ((line = r.readLine()) != null) {
            if (line.startsWith(REM_INDICATOR)) continue;
            if (line.startsWith("[")) {
                if (template == null) {
                    throw new RuntimeException("Template is null");
                }
                template.setDescription(description.toString());
                l.add(template);
                state = 0;
                description = new StringBuffer("");
                continue;
            }
            switch (state) {
                case 0: {
                    template = new ProjectTemplate();
                    template.setName(line);
                    ++state;
                    break;
                }
                case 1: {
                    if (template == null) {
                        throw new RuntimeException("Template is null");
                    }
                    template.setTargetClassName(line);
                    ++state;
                    break;
                }
                case 2: {
                    if (template == null) {
                        throw new RuntimeException("Template is null");
                    }
                    template.setConverterClassName(line);
                    ++state;
                    break;
                }
                case 3: {
                    if (template == null) {
                        throw new RuntimeException("Template is null");
                    }
                    template.setDbBuilderClassName(line);
                    ++state;
                    break;
                }
                case 4: {
                    if (template == null) {
                        throw new RuntimeException("Template is null");
                    }
                    template.setFormatClassName(line);
                    ++state;
                    break;
                }
                case 5: {
                    if (template == null) {
                        throw new RuntimeException("Template is null");
                    }
                    template.setSettingsFileName(line);
                    ++state;
                    break;
                }
                case 6: {
                    description.append(line + "\n");
                }
            }
        }
        return l;
    }

    @Override
    public void saveProjectTemplates(Writer out, List<? extends ProjectTemplate> templates) {
        PrintWriter ps = new PrintWriter(out);
        DateFormat df = DateFormat.getDateTimeInstance();
        ps.println("#ProjectTemplate file stored " + df.format(new Date()));
        for (ProjectTemplate projectTemplate : templates) {
            ps.println(projectTemplate.getName());
            ps.println(projectTemplate.getTargetClassName());
            ps.println(projectTemplate.getConverterClassName());
            ps.println(projectTemplate.getDbBuilderClassName());
            ps.println(projectTemplate.getFormatClassName());
            ps.println(projectTemplate.getSettingsFileName());
            ps.println(projectTemplate.getDescription());
            ps.println("[Template definition ends]");
        }
    }
}

