/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.project;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.data.DataHolderUtils;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.task.AbstractTask;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.design.CandidateAnalysisModule;
import org.moltools.apps.probemaker.design.DefaultTagLibrary;
import org.moltools.apps.probemaker.design.ProbeGroup;
import org.moltools.apps.probemaker.design.TagLibrary;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.project.ProjectHolder;
import org.moltools.apps.probemaker.project.Settings;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerSequenceFactory;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.VariantTarget;
import org.moltools.apps.probemaker.seq.impl.DefaultProbe;
import org.moltools.design.data.Group;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.data.impl.TargetGroup;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.IDNotFoundException;
import org.moltools.lib.Identifiable;
import org.moltools.lib.seq.ChangeableNucleotideSequence;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.SequenceView;
import org.moltools.lib.seq.db.ChangeableIndexedSequenceDB;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;
import org.moltools.lib.utils.TextTableIO;

public class ProjectIOTask
extends AbstractTask {
    protected static final char TITLE_DESCRIPTOR = '#';
    protected static final char VALUE_SEPARATOR = ';';
    protected static final char VALUE_SEPARATOR_REPLACEMENT = ':';
    protected static final String LISTEND = "END_OF_LIST";
    protected static final String NAME = "NAME";
    protected static final String TARGET_GROUPS = "TARGET_GROUPS";
    protected static final String TARGETS = "TARGETS";
    protected static final String TARGET_TYPE = "TARGET_TYPE";
    protected static final String PARAMETERS = "PARAMETERS";
    protected static final String LIBRARIES = "LIBRARIES";
    protected static final String LIBRARY = "LIBRARY";
    protected static final String TAGS = "TAGS";
    protected static final String PROBE_GROUPS = "PROBE_GROUPS";
    protected static final String PROBES = "PROBES";
    protected static final String VERSION = "VERSION";
    protected static final String CONFIG = "CONFIGURATION";
    protected static final String MODULES1 = "MODULES1";
    protected static final String MODULES2 = "MODULES2";
    protected static final String MODULES3 = "MODULES3";
    protected static final String TYPE_PADLOCK = "PADLOCK";
    protected static final String TYPE_GAPFILL = "GAPFILL";
    protected static final String TYPE_INVADER = "INVADER";
    protected static final int version = 2;
    protected static final String START_STATUS = "Ready";
    protected ProjectHolder ph;
    protected byte mode = 0;
    protected Writer writer;
    protected Reader reader;
    static final TextTableIO tio = new TextTableIO();

    private ProjectIOTask(ProjectHolder ph, ErrorHandler ecb, byte mode) {
        super(mode == 0 ? CoreMessages.getString("ProjectIOTask.TITLE_OPENING_PROJECT") : CoreMessages.getString("ProjectIOTask.TITLE_SAVING_PROJECT"), 0, 5, 2, ecb);
        this.mode = mode;
        this.ph = ph;
        this.setStatus(CoreMessages.getString("ProjectIOTask.MESSAGE_READY"), 0);
    }

    public ProjectIOTask(ProjectHolder ph, ErrorHandler ecb, Writer out) {
        this(ph, ecb, 1);
        this.writer = out;
    }

    public ProjectIOTask(ProjectHolder ph, ErrorHandler ecb, Reader in) {
        this(ph, ecb, 0);
        this.reader = in;
    }

    public void run() {
        try {
            switch (this.mode) {
                case 0: {
                    this.ph.setProject(this.importProject(this.reader));
                    this.reader.close();
                    break;
                }
                case 1: {
                    this.exportProject(this.ph.getProject(), this.writer);
                    this.writer.close();
                }
            }
        }
        catch (Exception ex) {
            this.handleError(ex);
        }
        this.setCompleted();
    }

    public void exportProject(Project proj, Writer out) throws IOException {
        this.setStatus("Setting up", 0);
        ArrayList<TargetGroup> groups = new ArrayList<TargetGroup>();
        for (ProbeMakerTarget t : proj.getTargets()) {
            TargetGroup tg = (TargetGroup)DesignUtils.getGroupWithType((PropertyHolder)t, (String)"moltools.targetGroup");
            if (tg == null || groups.contains(tg)) continue;
            groups.add(tg);
        }
        PrintWriter p = new PrintWriter(out);
        this.increaseProgress();
        this.setStatus("Writing header", 0);
        Date d = new Date();
        p.println("Project exported " + DateFormat.getDateTimeInstance().format(d));
        p.println("#VERSION");
        p.println(2);
        p.println("#NAME");
        p.println(proj.getName());
        this.increaseProgress();
        this.setStatus("Writing targets", 0);
        p.println("#TARGET_GROUPS");
        p.println(groups.size());
        p.println("#TARGET_TYPE");
        if (proj.getTargets().size() > 0) {
            Sequence target = proj.getTargets().getSequenceAt(0);
            p.println(target.getClass().getName());
        } else {
            p.println("");
        }
        p.println("#TARGETS");
        for (ProbeMakerTarget t : proj.getTargets()) {
            TargetGroup tg;
            VariantTarget vt;
            this.setStatus(t.getID(), 1);
            String descStr = t.getID();
            String seqStr = t instanceof SequenceView ? ((SequenceView)t).getViewSequence() : t.seqString();
            String typeStr = String.valueOf(t.getType());
            String varStr = "";
            if (t instanceof VariantTarget && (vt = (VariantTarget)t).getVariant() != null) {
                String str = vt.getVariant().toString();
                for (int v = 0; v < vt.getVariants().length; ++v) {
                    if (!vt.getVariants()[v].toString().equals(str)) continue;
                    varStr = String.valueOf(v);
                    break;
                }
            }
            String groupStr = String.valueOf((tg = (TargetGroup)DesignUtils.getGroupWithType((PropertyHolder)t, (String)"moltools.targetGroup")) == null ? -1 : groups.indexOf(tg));
            p.println(tio.getOutString(new String[]{descStr, seqStr, typeStr, varStr, groupStr}));
        }
        p.println("#END_OF_LIST");
        this.increaseProgress();
        this.setStatus("Writing tags", 0);
        p.println("#LIBRARIES");
        TagLibrary[] libraries = proj.getTagLibraries();
        int i = 0;
        int t = 0;
        while (i < libraries.length) {
            TagLibrary l = libraries[t];
            p.println(tio.getOutString(new String[]{l.getName(), String.valueOf(l.getMode()), String.valueOf(true), String.valueOf(true)}));
            ++i;
            ++t;
        }
        p.println("#END_OF_LIST");
        for (i = 0; i < libraries.length; ++i) {
            TagLibrary l = libraries[i];
            p.println("#LIBRARY");
            Iterator ti = l.iterator();
            while (ti.hasNext()) {
                NucleotideSequence t2 = (NucleotideSequence)ti.next();
                p.println(tio.getOutString(new String[]{t2.getID(), t2.seqString(), String.valueOf(t2.getType())}));
            }
            p.println("#END_OF_LIST");
        }
        this.increaseProgress();
        this.setStatus("Writing probes", 0);
        ArrayList<ProbeGroup> p_groups = new ArrayList<ProbeGroup>();
        for (Probe pr : proj.getProbes()) {
            ProbeGroup pg = (ProbeGroup)DesignUtils.getGroupWithType((PropertyHolder)pr, (String)"probeGroup");
            if (pg == null || p_groups.contains((Object)pg)) continue;
            p_groups.add(pg);
        }
        p.println("#PROBE_GROUPS");
        for (ProbeGroup pg : p_groups) {
            TargetGroup tg = pg.getTargetGroup();
            int tg_no = tg == null ? -1 : groups.indexOf(tg);
            int lib_no = -1;
            int tag_no = -1;
            String tagID = proj.getTagAllocationTable().getGroupTagID((Group<?>)pg);
            if (tagID != null) {
                for (int l = 0; l < libraries.length; ++l) {
                    try {
                        NucleotideSequence s = (NucleotideSequence)libraries[l].getSequenceByID(tagID);
                        lib_no = l;
                        tag_no = libraries[l].indexOfSequence((Sequence)s);
                        continue;
                    }
                    catch (IDNotFoundException inx) {
                        // empty catch block
                    }
                }
            }
            p.println(tio.getOutString(new String[]{String.valueOf(tg_no), String.valueOf(lib_no), String.valueOf(tag_no)}));
        }
        p.println("#END_OF_LIST");
        p.println("#PROBES");
        ChangeableIndexedSequenceDB<Probe> probes = proj.getProbes();
        for (Probe pr : probes) {
            PropertyAcceptorNucleotideSequence threePrime;
            PropertyAcceptorNucleotideSequence fivePrime;
            try {
                fivePrime = (PropertyAcceptorNucleotideSequence)pr.getTSSPair().getSequence("FIVE_PRIME");
            }
            catch (ClusterException e) {
                fivePrime = null;
            }
            try {
                threePrime = (PropertyAcceptorNucleotideSequence)pr.getTSSPair().getSequence("THREE_PRIME");
            }
            catch (ClusterException e) {
                threePrime = null;
            }
            int targetNo = -1;
            try {
                targetNo = pr.getTarget() == null ? -1 : proj.getTargets().indexOfSequence(proj.getTargets().getSequenceByID(pr.getTarget().getID()));
            }
            catch (IDNotFoundException ix) {
                // empty catch block
            }
            Group pg = DesignUtils.getGroupWithType((PropertyHolder)pr, (String)"probeGroup");
            String outStr = tio.getOutString(new String[]{pr.getName().replace(';', ':'), pr.getID() != null ? pr.getID().replace(';', ':') : "No ID", String.valueOf(pr.getType()), String.valueOf(pr.getUpstreamBlockCount()), String.valueOf(pr.getDownstreamBlockCount()), String.valueOf(targetNo), String.valueOf(pg == null ? -1 : p_groups.indexOf(pg)), String.valueOf(ProbeMakerPropertyUtils.getRank(pr)), String.valueOf(fivePrime == null ? 0 : ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)fivePrime).size()), String.valueOf(threePrime == null ? 0 : ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)threePrime).size()), String.valueOf(ProbeMakerPropertyUtils.getOwnMessages(pr.getTSSPair()).size()), String.valueOf(ProbeMakerPropertyUtils.getOwnMessages(pr).size()), fivePrime == null ? "" : fivePrime.seqString(), String.valueOf(fivePrime == null ? 0.0f : ProbeMakerPropertyUtils.getHybridizationTemp((PropertyHolder)fivePrime)), threePrime == null ? "" : threePrime.seqString(), String.valueOf(threePrime == null ? 0.0f : ProbeMakerPropertyUtils.getHybridizationTemp((PropertyHolder)threePrime))});
            for (int t3 = 0; t3 < pr.getTags().size(); ++t3) {
                outStr = outStr + ';';
                NucleotideSequence tag = pr.getTagAt(t3);
                if (tag.getID().startsWith("Spacer")) {
                    outStr = outStr + "Spacer";
                    outStr = outStr + ';';
                    outStr = outStr + tag.seqString();
                    continue;
                }
                int lib_no = -1;
                int tag_no = -1;
                for (int l = 0; l < libraries.length; ++l) {
                    try {
                        NucleotideSequence s = (NucleotideSequence)libraries[l].getSequenceByID(tag.getID());
                        if (s == null) continue;
                        lib_no = l;
                        tag_no = libraries[l].indexOfSequence((Sequence)s);
                        continue;
                    }
                    catch (IDNotFoundException inx) {
                        // empty catch block
                    }
                }
                outStr = outStr + String.valueOf(lib_no);
                outStr = outStr + ';';
                outStr = outStr + String.valueOf(tag_no);
            }
            p.println(outStr);
            if (fivePrime != null) {
                for (Message m : ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)fivePrime)) {
                    MessageType mt = m.getType();
                    p.println(tio.getOutString(new String[]{mt.getType(), mt.getDescription(), m.getMessage(), String.valueOf(m.getSeverity())}));
                }
            }
            if (threePrime != null) {
                for (Message m : ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)threePrime)) {
                    MessageType mt = m.getType();
                    p.println(tio.getOutString(new String[]{mt.getType(), mt.getDescription(), m.getMessage(), String.valueOf(m.getSeverity())}));
                }
            }
            for (Message m : ProbeMakerPropertyUtils.getOwnMessages(pr.getTSSPair())) {
                MessageType mt = m.getType();
                p.println(tio.getOutString(new String[]{mt.getType(), mt.getDescription(), m.getMessage(), String.valueOf(m.getSeverity())}));
            }
            for (Message m : ProbeMakerPropertyUtils.getOwnMessages(pr)) {
                MessageType mt = m.getType();
                p.println(tio.getOutString(new String[]{mt.getType(), mt.getDescription(), m.getMessage(), String.valueOf(m.getSeverity())}));
            }
        }
        p.println("#END_OF_LIST");
        this.increaseProgress();
        this.setStatus("Writing settings", 0);
        Settings s = proj.getSettings();
        List<CandidateAnalysisModule> modules1 = s.getArmModules();
        List<CandidateAnalysisModule> modules2 = s.getCandidateModulesStage1();
        List<CandidateAnalysisModule> modules3 = s.getCandidateModulesStage2();
        Properties props = new Properties();
        props.putAll(s.getDesignParameters());
        p.println("#MODULES1");
        Iterator<CandidateAnalysisModule> i2 = modules1.iterator();
        while (i2.hasNext()) {
            p.println(ProjectIOTask.getModuleString(i2.next(), tio));
        }
        p.println("#END_OF_LIST");
        p.println("#MODULES2");
        i2 = modules2.iterator();
        while (i2.hasNext()) {
            p.println(ProjectIOTask.getModuleString(i2.next(), tio));
        }
        p.println("#END_OF_LIST");
        p.println("#MODULES3");
        i2 = modules3.iterator();
        while (i2.hasNext()) {
            p.println(ProjectIOTask.getModuleString(i2.next(), tio));
        }
        p.println("#END_OF_LIST");
        p.println("#CONFIGURATION");
        p.println("#END_OF_LIST");
        p.println("#PARAMETERS");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        props.store(bos, null);
        p.println(bos.toString());
        this.increaseProgress();
        this.setStatus("Done", 0);
        p.close();
    }

    public static String getModuleString(CandidateAnalysisModule am, TextTableIO textIO) {
        int i;
        Object[] values = DataHolderUtils.getOrderedValues((DataHolder)am);
        TestDescriptor[] tests = am.getAllTests();
        String classStr = am.getClass().getName();
        int pc = values == null ? 0 : values.length;
        int tc = tests == null ? 0 : tests.length;
        String apCountStr = String.valueOf(pc);
        String testCountStr = String.valueOf(tc);
        String str = textIO.getOutString(new String[]{classStr, apCountStr, testCountStr});
        if (values != null) {
            for (i = 0; i < pc; ++i) {
                str = str + ';' + values[i].toString();
            }
        }
        if (tests != null) {
            for (i = 0; i < tc; ++i) {
                str = str + ';' + String.valueOf(tests[i].perform());
            }
        }
        return str;
    }

    public static CandidateAnalysisModule getModule(String[] strings) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> c = Class.forName(strings[0]);
        int paramCount = Integer.parseInt(strings[1]);
        int testCount = Integer.parseInt(strings[2]);
        CandidateAnalysisModule am = (CandidateAnalysisModule)c.newInstance();
        int pos = 3;
        Object[] paramValues = new String[paramCount];
        int i = 0;
        while (i < paramCount) {
            paramValues[i] = strings[pos];
            ++i;
            ++pos;
        }
        DataHolderUtils.putOrderedData((Object[])paramValues, (DataHolder)am);
        i = 0;
        while (i < testCount) {
            am.getAllTests()[i].setPerform(Boolean.valueOf(strings[pos]));
            ++i;
            ++pos;
        }
        return am;
    }

    public Project importProject(Reader in) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, DuplicateIDException {
        String line;
        String probeString;
        String groupString;
        int l;
        String libString;
        String targetString;
        SequenceBuilder targetBuilder;
        this.setStatus("Setting up", 0);
        BufferedReader r = new BufferedReader(in);
        this.increaseProgress();
        this.setStatus("Reading header info", 0);
        String verstr = "0";
        if (ProjectIOTask.searchTitle(r, VERSION) < 0) {
            throw new IOException("No version found");
        }
        verstr = r.readLine();
        int ver = Integer.parseInt(verstr);
        int current_version = ver > 0 ? ver : 2;
        String name = "";
        if (ProjectIOTask.searchTitle(r, NAME) < 0) {
            throw new IOException("No project name found");
        }
        name = r.readLine();
        Project proj = new Project(name);
        this.increaseProgress();
        this.setStatus("Reading targets", 0);
        int no_groups = 0;
        if (ProjectIOTask.searchTitle(r, TARGET_GROUPS) < 0) {
            throw new IOException("No target groups found");
        }
        no_groups = Integer.parseInt(r.readLine());
        ArrayList<TargetGroup> groups = new ArrayList<TargetGroup>();
        for (int i = 0; i < no_groups; ++i) {
            groups.add(new TargetGroup(String.valueOf(i + 1)));
        }
        String typeString = "";
        if (current_version > 1) {
            ProjectIOTask.searchTitle(r, TARGET_TYPE);
            typeString = r.readLine();
        }
        if (typeString.equals(TYPE_PADLOCK)) {
            typeString = "org.moltools.apps.probemaker.ext.target.PadlockTarget";
        } else if (typeString.equals(TYPE_GAPFILL)) {
            typeString = "org.moltools.apps.probemaker.ext.target.GapFillPadlockTarget";
        } else if (typeString.equals(TYPE_INVADER)) {
            typeString = "org.moltools.apps.probemaker.ext.target.SelectorTarget";
        }
        if (!typeString.equals("")) {
            Class<?> c = Class.forName(typeString);
            Method getBuilder = c.getMethod("getSequenceBuilder", new Class[0]);
            targetBuilder = (SequenceBuilder)getBuilder.invoke(null, (Object[])null);
        } else {
            targetBuilder = null;
        }
        ProjectIOTask.searchTitle(r, TARGETS);
        while (!(targetString = r.readLine()).startsWith(String.valueOf('#'))) {
            int grpno;
            int varno;
            String[] substrings = targetString.split(";");
            this.setStatus(substrings[0], 1);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("ID", substrings[0]);
            m.put("sequence.seqstring", substrings[1]);
            byte type = Byte.parseByte(substrings[2]);
            if (targetBuilder == null) {
                throw new UnsupportedOperationException("Can't read target data if target builder not set");
            }
            ProbeMakerTarget t = (ProbeMakerTarget)targetBuilder.buildObject(m);
            if (t instanceof ChangeableNucleotideSequence) {
                ((ChangeableNucleotideSequence)t).setType(type);
            }
            if ((varno = substrings[3].length() == 0 ? -1 : Integer.parseInt(substrings[3])) > -1) {
                VariantTarget vt = (VariantTarget)t;
                vt.setVariant(vt.getVariants()[varno]);
            }
            if ((grpno = Integer.parseInt(substrings[4])) > -1) {
                ((TargetGroup)groups.get(Integer.parseInt(substrings[4]))).addMember((Object)t);
            }
            proj.getTargets().addSequence((Sequence)t);
        }
        this.increaseProgress();
        this.setStatus("Reading tags", 0);
        ProjectIOTask.searchTitle(r, LIBRARIES);
        ArrayList<DefaultTagLibrary> libs = new ArrayList<DefaultTagLibrary>();
        while (!(libString = r.readLine()).startsWith(String.valueOf('#'))) {
            String[] substrings = tio.getInStrings(libString);
            if (substrings.length != 4) {
                throw new UnsupportedOperationException("Error parsing tag library line: " + libString);
            }
            DefaultTagLibrary l2 = new DefaultTagLibrary((DefiniteSequenceDB<? extends NucleotideSequence>)new ListSequenceDB(), substrings[0]);
            l2.setMode(Byte.parseByte(substrings[1]));
            libs.add(l2);
        }
        TagLibrary[] libraries = new TagLibrary[libs.size()];
        for (l = 0; l < libraries.length; ++l) {
            libraries[l] = (TagLibrary)libs.get(l);
        }
        for (l = 0; l < libraries.length; ++l) {
            String tagString;
            ProjectIOTask.searchTitle(r, LIBRARY);
            while (!(tagString = r.readLine()).startsWith(String.valueOf('#'))) {
                String[] substrings = tio.getInStrings(tagString);
                if (substrings.length != 3) {
                    throw new UnsupportedOperationException("Error parsing tag line: " + tagString);
                }
                SimpleNucleotideSequence t = new SimpleNucleotideSequence(substrings[0], substrings[1], Byte.parseByte(substrings[2]));
                libraries[l].addSequence((Sequence)t);
            }
        }
        proj.setTagLibraries(libraries);
        this.increaseProgress();
        this.setStatus("Reading probes", 0);
        ProjectIOTask.searchTitle(r, PROBE_GROUPS);
        ArrayList<ProbeGroup> p_groups = new ArrayList<ProbeGroup>();
        int tgIndex = 0;
        while (!(groupString = r.readLine()).startsWith(String.valueOf('#'))) {
            ProbeGroup pg;
            String[] substrings = tio.getInStrings(groupString);
            if (substrings.length != 3) {
                throw new UnsupportedOperationException("Error parsing probe group line: " + groupString);
            }
            ++tgIndex;
            int pgindex = Integer.parseInt(substrings[0]);
            int libindex = Integer.parseInt(substrings[1]);
            int tagindex = Integer.parseInt(substrings[2]);
            if (pgindex >= 0) {
                pg = new ProbeGroup((TargetGroup)groups.get(pgindex), String.valueOf(pgindex + 1));
                if (libindex >= 0) {
                    proj.getTagAllocationTable().setGroupTagID((Group<?>)pg, (Identifiable)libraries[libindex].getSequenceAt(tagindex));
                }
                p_groups.add(pg);
                continue;
            }
            pg = new ProbeGroup(null, "DUMMY");
            p_groups.add(pg);
        }
        ProjectIOTask.searchTitle(r, PROBES);
        while (!(probeString = r.readLine()).startsWith(String.valueOf('#'))) {
            MessageType mt;
            String[] messageLine;
            int mess;
            String[] substrings = tio.getInStrings(probeString);
            byte type = Byte.parseByte(substrings[2]);
            int target_no = Integer.parseInt(substrings[5]);
            ProbeMakerTarget pt = null;
            if (target_no >= 0) {
                pt = (ProbeMakerTarget)proj.getTargets().getSequenceAt(target_no);
            }
            int gr_no = Integer.parseInt(substrings[6]);
            int messageCount5 = Integer.parseInt(substrings[8]);
            int messageCount3 = Integer.parseInt(substrings[9]);
            int messageCountTSS = Integer.parseInt(substrings[10]);
            int messageCountProbe = Integer.parseInt(substrings[11]);
            PropertyAcceptorNucleotideSequence tss5 = ProbeMakerSequenceFactory.createTSS((NucleotideSequence)new SimpleNucleotideSequence("5' TSS", substrings[12], type), pt == null ? "" : pt.getID());
            ProbeMakerPropertyUtils.setHybridizationTemp((PropertyAcceptor)tss5, Float.parseFloat(substrings[13]));
            PropertyAcceptorNucleotideSequence tss3 = ProbeMakerSequenceFactory.createTSS((NucleotideSequence)new SimpleNucleotideSequence("3' TSS", substrings[14], type), pt == null ? "" : pt.getID());
            ProbeMakerPropertyUtils.setHybridizationTemp((PropertyAcceptor)tss3, Float.parseFloat(substrings[15]));
            DefaultProbe p = new DefaultProbe(ProbeMakerSequenceFactory.createTSSPair(tss5, tss3, pt), Integer.parseInt(substrings[3]), Integer.parseInt(substrings[4]), type);
            p.setName(substrings[0]);
            p.setID(substrings[1]);
            if (gr_no >= 0) {
                DesignUtils.addGroup((PropertyAcceptor)p, (Group)((Group)p_groups.get(gr_no)));
            }
            ProbeMakerPropertyUtils.setRank((PropertyAcceptor)p, Byte.parseByte(substrings[7]));
            int t = 0;
            int i = 16;
            while (i < substrings.length) {
                String l_str = substrings[i];
                String t_str = substrings[i + 1];
                if (l_str.startsWith("Spacer")) {
                    SimpleNucleotideSequence tag = new SimpleNucleotideSequence("Spacer " + t_str, t_str, p.getType());
                    p.addTagAt((NucleotideSequence)tag, t);
                } else {
                    int lib_no = Integer.parseInt(l_str);
                    int tag_no = Integer.parseInt(t_str);
                    NucleotideSequence tag = (NucleotideSequence)libraries[lib_no].getSequenceAt(tag_no);
                    p.addTagAt(tag, t);
                    proj.getTagAllocationTable().use(tag, p, t);
                }
                i += 2;
                ++t;
            }
            for (mess = 0; mess < messageCount5; ++mess) {
                messageLine = tio.getInStrings(r.readLine());
                if (messageLine.length != 4) {
                    throw new UnsupportedOperationException("Error parsing message line: " + messageLine);
                }
                mt = new MessageType(messageLine[0], messageLine[1]);
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)tss5, new Message(messageLine[2], mt, Byte.parseByte(messageLine[3])));
            }
            for (mess = 0; mess < messageCount3; ++mess) {
                messageLine = tio.getInStrings(r.readLine());
                if (messageLine.length != 4) {
                    throw new UnsupportedOperationException("Error parsing message line: " + messageLine);
                }
                mt = new MessageType(messageLine[0], messageLine[1]);
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)tss3, new Message(messageLine[2], mt, Byte.parseByte(messageLine[3])));
            }
            for (mess = 0; mess < messageCountTSS; ++mess) {
                messageLine = tio.getInStrings(r.readLine());
                if (messageLine.length != 4) {
                    throw new UnsupportedOperationException("Error parsing message line: " + messageLine);
                }
                mt = new MessageType(messageLine[0], messageLine[1]);
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p.getTSSPair(), new Message(messageLine[2], mt, Byte.parseByte(messageLine[3])));
            }
            for (mess = 0; mess < messageCountProbe; ++mess) {
                messageLine = tio.getInStrings(r.readLine());
                if (messageLine.length != 4) {
                    throw new UnsupportedOperationException("Error parsing message line: " + messageLine);
                }
                mt = new MessageType(messageLine[0], messageLine[1]);
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, new Message(messageLine[2], mt, Byte.parseByte(messageLine[3])));
            }
            proj.getProbes().addSequence((Sequence)p);
        }
        this.increaseProgress();
        this.setStatus("Reading settings", 0);
        String moduleString = "";
        ProjectIOTask.searchTitle(r, MODULES1);
        while (!(moduleString = r.readLine()).startsWith(String.valueOf('#'))) {
            try {
                proj.getSettings().addArmModule(ProjectIOTask.getModule(tio.getInStrings(moduleString)));
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Could not find module class: " + ex.getMessage());
            }
            catch (InstantiationException ex) {
                System.err.println("Could not instantiate module class: " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                System.err.println("Could not access module class: " + ex.getMessage());
            }
        }
        ProjectIOTask.searchTitle(r, MODULES2);
        while (!(moduleString = r.readLine()).startsWith(String.valueOf('#'))) {
            try {
                proj.getSettings().addCandidateModuleStage1(ProjectIOTask.getModule(tio.getInStrings(moduleString)));
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Could not find module class: " + ex.getMessage());
            }
            catch (InstantiationException ex) {
                System.err.println("Could not instantiate module class: " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                System.err.println("Could not access module class: " + ex.getMessage());
            }
        }
        ProjectIOTask.searchTitle(r, MODULES3);
        while (!(moduleString = r.readLine()).startsWith(String.valueOf('#'))) {
            try {
                proj.getSettings().addCandidateModuleStage2(ProjectIOTask.getModule(tio.getInStrings(moduleString)));
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Could not find module class: " + ex.getMessage());
            }
            catch (InstantiationException ex) {
                System.err.println("Could not instantiate module class: " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                System.err.println("Could not access module class: " + ex.getMessage());
            }
        }
        ProjectIOTask.searchTitle(r, CONFIG);
        ProjectIOTask.searchTitle(r, PARAMETERS);
        HashMap<String, String> parameters = new HashMap<String, String>();
        while ((line = r.readLine().trim()) != null) {
            if (line.length() <= 0 || line.startsWith("#")) continue;
            String[] sub = line.split("=");
            parameters.put(sub[0], sub[1]);
        }
        proj.getSettings().addDesignerProperties(parameters);
        this.increaseProgress();
        this.setStatus("Done", 0);
        return proj;
    }

    private static int searchTitle(BufferedReader r, String search) throws IOException {
        while (r.ready()) {
            String line = r.readLine();
            if (!line.startsWith('#' + search)) continue;
            return 0;
        }
        return -1;
    }
}

