/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.project;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.task.AbstractTask;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.design.DefaultTagLibrary;
import org.moltools.apps.probemaker.design.ProbeGroup;
import org.moltools.apps.probemaker.design.TagLibrary;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.project.Project;
import org.moltools.apps.probemaker.project.ProjectHolder;
import org.moltools.apps.probemaker.project.SettingsXMLHandler;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerSequenceFactory;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.VariantTarget;
import org.moltools.apps.probemaker.seq.impl.DefaultProbe;
import org.moltools.apps.probemaker.seq.impl.TSSPair;
import org.moltools.design.data.Group;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.data.impl.TargetGroup;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.DuplicateIDException;
import org.moltools.lib.IDNotFoundException;
import org.moltools.lib.seq.ChangeableNucleotideSequence;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceBuilder;
import org.moltools.lib.seq.SequenceView;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.SequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectXMLIOTask
extends AbstractTask {
    static final int version = 3;
    public static Namespace ns = Namespace.getNamespace((String)"pr", (String)"http://probemaker.sourceforge.net/");
    protected static final String PROJECT = "project";
    protected static final String NAME = "name";
    protected static final String VERSION = "version";
    protected static final String EXPORT_DATE = "exportDate";
    protected static final String TARGET_GROUPS = "targetGroups";
    protected static final String TARGET_GROUP = "targetGroup";
    protected static final String TARGET_LIST = "targetList";
    protected static final String TARGET_TYPE = "class";
    protected static final String TARGET = "target";
    protected static final String LIBRARIES = "tagLibraries";
    protected static final String LIBRARY = "tagLibrary";
    protected static final String TAGS = "tags";
    protected static final String TAG = "tag";
    protected static final String PROBE_GROUPS = "probeGroups";
    protected static final String PROBE_LIST = "probeList";
    protected static final String PROBE = "probe";
    protected static final String PROBE_GROUP = "probeGroup";
    protected static final String TARGET_ID = "targetID";
    protected static final String RANK = "rank";
    protected static final String SUB_SEQUENCES = "sequenceList";
    protected static final String SPACER = "spacer";
    protected static final String TAG_ID = "tagID";
    protected static final String TSS = "tss";
    protected static final String PROBE_MESSAGES = "probeMessages";
    protected static final String TSS_PAIR_MESSAGES = "tssPairMessages";
    protected static final String MESSAGE = "message";
    protected static final String MESSAGE_TYPE = "messageType";
    protected static final String MESSAGE_TYPE_NAME = "messageName";
    protected static final String DESCRIPTION = "description";
    protected static final String SEVERITY = "severity";
    protected static final String TM = "tm";
    protected static final String ID = "id";
    protected static final String TYPE = "type";
    protected static final String SEQUENCE = "sequence";
    protected static final String VARIANT = "variant";
    protected static final String LIB_NAME = "libName";
    protected static final String LIB_MODE = "libMode";
    protected static final String TSS_PAIR = "tssPair";
    protected ProjectHolder ph;
    protected byte mode = 0;
    protected Writer writer;
    protected Reader reader;

    private ProjectXMLIOTask(ProjectHolder ph, ErrorHandler ecb, byte mode) {
        super(mode == 0 ? CoreMessages.getString("ProjectIOTask.TITLE_OPENING_PROJECT") : CoreMessages.getString("ProjectIOTask.TITLE_SAVING_PROJECT"), 0, 6, 2, ecb);
        this.mode = mode;
        this.ph = ph;
        this.setStatus(CoreMessages.getString("ProjectIOTask.MESSAGE_READY"), 0);
    }

    public ProjectXMLIOTask(ProjectHolder ph, ErrorHandler ecb, Writer out) {
        this(ph, ecb, 1);
        this.writer = out;
    }

    public ProjectXMLIOTask(ProjectHolder ph, ErrorHandler ecb, Reader in) {
        this(ph, ecb, 0);
        this.reader = in;
    }

    public void run() {
        try {
            switch (this.mode) {
                case 0: {
                    this.ph.setProject(this.importProject(this.reader));
                    this.reader.close();
                    break;
                }
                case 1: {
                    this.exportProject(this.ph.getProject(), this.writer);
                    this.writer.close();
                }
            }
        }
        catch (Exception ex) {
            this.handleError(ex);
        }
        this.setCompleted();
    }

    protected void addMessagesFromElement(PropertyAcceptor mh, Element messageListElement) {
        for (Element messE : messageListElement.getChildren(MESSAGE, ns)) {
            String type = messE.getAttributeValue(MESSAGE_TYPE_NAME, ns);
            String desc = messE.getAttributeValue(DESCRIPTION, ns);
            MessageType mt = new MessageType(type, desc);
            byte severity = Byte.parseByte(messE.getAttributeValue(SEVERITY, ns));
            String messageStr = messE.getText();
            Message m = new Message(messageStr, mt, severity);
            ProbeMakerPropertyUtils.addMessage(mh, m);
        }
    }

    protected Element getMessageListElement(Collection<? extends Message> messages) {
        Element messageList = new Element("messageList", ns);
        for (Message message : messages) {
            MessageType mt = message.getType();
            Element me = new Element(MESSAGE, ns);
            me.setAttribute(MESSAGE_TYPE_NAME, mt.getType(), ns);
            me.setAttribute(DESCRIPTION, mt.getDescription(), ns);
            me.setAttribute(SEVERITY, String.valueOf(message.getSeverity()), ns);
            me.addContent(message.getMessage());
            messageList.addContent((Content)me);
        }
        return messageList;
    }

    protected KeyValue getLibraryTag(TagLibrary[] libraries, String tagID) {
        NucleotideSequence theTag = null;
        TagLibrary theLib = null;
        for (int lib = 0; lib < libraries.length; ++lib) {
            try {
                NucleotideSequence tag = (NucleotideSequence)libraries[lib].getSequenceByID(tagID);
                if (tag == null) continue;
                theTag = tag;
                theLib = libraries[lib];
                break;
            }
            catch (IDNotFoundException e) {
                // empty catch block
            }
        }
        if (theTag != null) {
            return new DefaultKeyValue(theTag, theLib);
        }
        return null;
    }

    protected Element getTagElement(String name, NucleotideSequence t) {
        Element tagE = new Element(name, ns);
        tagE.setAttribute(ID, t.getID(), ns);
        tagE.addContent((Content)new Element(TYPE, ns).addContent(String.valueOf(t.getType())));
        tagE.addContent((Content)new Element(SEQUENCE, ns).addContent(t.seqString()));
        return tagE;
    }

    protected Element getTagLibraryElement(String name, TagLibrary lib) {
        Element libE = new Element(name, ns);
        libE.addContent((Content)new Element(LIB_NAME, ns).addContent(lib.getName()));
        libE.addContent((Content)new Element(LIB_MODE, ns).addContent(String.valueOf(lib.getMode())));
        Element tags = new Element(TAGS, ns);
        Iterator ti = lib.iterator();
        while (ti.hasNext()) {
            NucleotideSequence t = (NucleotideSequence)ti.next();
            tags.addContent((Content)this.getTagElement(TAG, t));
        }
        libE.addContent((Content)tags);
        return libE;
    }

    protected Element getTagLibrariesElement(String name, TagLibrary[] libraries) {
        Element tagLibsE = new Element(name, ns);
        for (int i = 0; i < libraries.length; ++i) {
            Element libE = this.getTagLibraryElement(LIBRARY, libraries[i]);
            tagLibsE.addContent((Content)libE);
        }
        return tagLibsE;
    }

    protected Element getTargetElement(String name, ProbeMakerTarget t) {
        VariantTarget vt;
        Element targetE = new Element(TARGET, ns);
        String idStr = t.getID();
        this.setStatus(idStr, 1);
        targetE.setAttribute(ID, idStr, ns);
        targetE.setAttribute(TARGET_TYPE, t.getClass().getName(), ns);
        String typeStr = String.valueOf(t.getType());
        targetE.addContent((Content)new Element(TYPE, ns).addContent(typeStr));
        String seqStr = t instanceof SequenceView ? ((SequenceView)t).getViewSequence() : t.seqString();
        targetE.addContent((Content)new Element(SEQUENCE, ns).addContent(seqStr));
        Group group = DesignUtils.getGroupWithType((PropertyHolder)t, (String)"moltools.targetGroup");
        String groupStr = group == null ? null : String.valueOf(group.getID());
        targetE.addContent((Content)new Element(TARGET_GROUP, ns).addContent(groupStr));
        String varStr = "";
        if (t instanceof VariantTarget && (vt = (VariantTarget)t).getVariant() != null) {
            String str = vt.getVariant().toString();
            for (int v = 0; v < vt.getVariants().length; ++v) {
                if (!vt.getVariants()[v].toString().equals(str)) continue;
                varStr = String.valueOf(v);
                break;
            }
        }
        targetE.addContent((Content)new Element(VARIANT, ns).addContent(varStr));
        return targetE;
    }

    protected Element getTargetListElement(String name, DefiniteSequenceDB<ProbeMakerTarget> targets) {
        Element targetList = new Element(TARGET_LIST, ns);
        for (ProbeMakerTarget t : targets) {
            targetList.addContent((Content)this.getTargetElement(TARGET, t));
        }
        return targetList;
    }

    protected Element getProbeElement(String name, Probe pr, TagLibrary[] libraries) {
        Element seqE;
        Element probeE = new Element(name, ns);
        probeE.setAttribute(ID, pr.getID(), ns);
        probeE.addContent((Content)new Element(NAME, ns).addContent(pr.getName()));
        probeE.addContent((Content)new Element(TYPE, ns).addContent(String.valueOf(pr.getType())));
        ProbeGroup group = (ProbeGroup)DesignUtils.getGroupWithType((PropertyHolder)pr, (String)PROBE_GROUP);
        if (group != null) {
            String groupStr = group.getID();
            Element groupE = new Element(PROBE_GROUP, ns).setAttribute(ID, groupStr, ns);
            TargetGroup tGroup = group.getTargetGroup();
            if (tGroup != null) {
                String tGroupStr = tGroup.getID();
                groupE.setAttribute(TARGET_GROUP, tGroupStr, ns);
            }
            probeE.addContent((Content)groupE);
        }
        probeE.addContent((Content)new Element(RANK, ns).addContent(String.valueOf(ProbeMakerPropertyUtils.getRank(pr))));
        TSSPair tssPair = pr.getTSSPair();
        Element tssPairE = new Element(TSS_PAIR, ns);
        String targetID = DesignUtils.getTargetID((PropertyHolder)tssPair);
        tssPairE.setAttribute(TARGET_ID, targetID == null ? "" : targetID, ns);
        HashSet<String> tssIDs = new HashSet<String>();
        for (String key : tssPair.getKeys()) {
            try {
                PropertyAcceptorNucleotideSequence tss = (PropertyAcceptorNucleotideSequence)tssPair.getSequence(key);
                if (tss == null) continue;
                seqE = new Element(TSS, ns);
                seqE.setAttribute("key", key, ns);
                seqE.setAttribute(ID, tss.getID(), ns);
                tssIDs.add(tss.getID());
                seqE.addContent((Content)new Element(TYPE, ns).addContent(String.valueOf(tss.getType())));
                seqE.addContent((Content)new Element(SEQUENCE, ns).addContent(tss.seqString()));
                seqE.addContent((Content)new Element(TM, ns).addContent(String.valueOf(ProbeMakerPropertyUtils.getHybridizationTemp((PropertyHolder)tss))));
                seqE.addContent((Content)this.getMessageListElement(ProbeMakerPropertyUtils.getAllMessages((PropertyHolder)tss)));
                tssPairE.addContent((Content)seqE);
            }
            catch (ClusterException e) {}
        }
        tssPairE.addContent((Content)this.getMessageListElement(ProbeMakerPropertyUtils.getOwnMessages(tssPair)));
        probeE.addContent((Content)tssPairE);
        Element seqList = new Element(SUB_SEQUENCES, ns);
        for (int s = 1; s <= pr.getSequenceCount(); ++s) {
            Sequence seq = pr.getSequence(s);
            seqE = null;
            String seqID = seq.getID();
            if (tssIDs.contains(seqID)) {
                seqE = new Element(TSS, ns);
                seqE.setAttribute(ID, seqID, ns);
            } else if (seqID.startsWith("Spacer")) {
                seqE = new Element(SPACER, ns);
                seqE.setAttribute(ID, seqID, ns);
                seqE.addContent((Content)new Element(TYPE, ns).addContent(String.valueOf(((NucleotideSequence)seq).getType())));
                seqE.addContent((Content)new Element(SEQUENCE, ns).addContent(seq.seqString()));
            } else if (seq instanceof NucleotideSequence) {
                KeyValue kv = this.getLibraryTag(libraries, seqID);
                if (kv == null) {
                    seqE = this.getTagElement(TAG, (NucleotideSequence)seq);
                } else {
                    seqE = new Element(TAG_ID, ns);
                    seqE.setAttribute(ID, seqID, ns);
                }
            } else {
                throw new UnsupportedOperationException("Unsupported subsequence " + seq.getID() + " of " + pr.getID() + ": " + seq.getClass());
            }
            seqList.addContent((Content)seqE);
        }
        probeE.addContent((Content)seqList);
        probeE.addContent((Content)this.getMessageListElement(ProbeMakerPropertyUtils.getOwnMessages(pr)));
        return probeE;
    }

    protected Element getProbeListElement(String name, DefiniteSequenceDB<Probe> probes, TagLibrary[] libraries) {
        Element probeList = new Element(name, ns);
        for (Probe pr : probes) {
            Element probeE = this.getProbeElement(PROBE, pr, libraries);
            probeList.addContent((Content)probeE);
        }
        return probeList;
    }

    protected void exportProject(Project proj, Writer out) throws IOException {
        Date d = new Date();
        this.setStatus("Creating XML document", 0);
        Document doc = new Document();
        Element root = new Element(PROJECT, ns);
        root.setAttribute(NAME, proj.getName(), ns);
        root.setAttribute(VERSION, String.valueOf(3), ns);
        root.setAttribute(EXPORT_DATE, DateFormat.getDateTimeInstance().format(d), ns);
        doc.addContent((Content)root);
        this.increaseProgress();
        this.setStatus("Writing targets", 0);
        root.addContent((Content)this.getTargetListElement(TARGET_LIST, (DefiniteSequenceDB<ProbeMakerTarget>)proj.getTargets()));
        this.increaseProgress();
        this.setStatus("Writing tags", 0);
        root.addContent((Content)this.getTagLibrariesElement(LIBRARIES, proj.getTagLibraries()));
        this.increaseProgress();
        this.setStatus("Writing probes", 0);
        root.addContent((Content)this.getProbeListElement(PROBE_LIST, (DefiniteSequenceDB<Probe>)proj.getProbes(), proj.getTagLibraries()));
        this.increaseProgress();
        this.setStatus("Writing settings", 0);
        root.addContent((Content)SettingsXMLHandler.getSettingsElement("settings", proj.getSettings()));
        this.increaseProgress();
        this.setStatus("Saving", 0);
        new XMLOutputter(Format.getPrettyFormat()).output(doc, out);
        this.increaseProgress();
        this.setStatus("Done", 0);
    }

    protected NucleotideSequence getTag(Element tagE) {
        String id = tagE.getAttributeValue(ID, ns);
        String typeStr = tagE.getChildText(TYPE, ns);
        String seqStr = tagE.getChildText(SEQUENCE, ns);
        SimpleNucleotideSequence seq = new SimpleNucleotideSequence(id, seqStr, Byte.parseByte(typeStr));
        return seq;
    }

    protected TagLibrary getTagLibrary(Element libE) {
        String libName = libE.getChildText(LIB_NAME, ns);
        String libMode = libE.getChildText(LIB_MODE, ns);
        Element tagsE = libE.getChild(TAGS, ns);
        ListSequenceDB tags = new ListSequenceDB();
        for (Element tagE : tagsE.getChildren()) {
            tags.addSequence((Sequence)this.getTag(tagE));
        }
        DefaultTagLibrary tl = new DefaultTagLibrary((DefiniteSequenceDB<? extends NucleotideSequence>)tags, libName);
        tl.setMode(Byte.parseByte(libMode));
        return tl;
    }

    protected TagLibrary[] getTagLibraries(Element e) {
        ArrayList<TagLibrary> libs = new ArrayList<TagLibrary>();
        for (Element libE : e.getChildren(LIBRARY, ns)) {
            TagLibrary tl = this.getTagLibrary(libE);
            libs.add(tl);
        }
        return libs.toArray(new TagLibrary[libs.size()]);
    }

    protected Project importProject(Reader in) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, DuplicateIDException, JDOMException {
        this.setStatus("Setting up", 0);
        InputSource is = new InputSource(in);
        SAXBuilder sb = new SAXBuilder();
        sb.setValidation(false);
        this.increaseProgress();
        this.setStatus("Reading document", 0);
        Document doc = sb.build(is);
        Element projE = doc.getRootElement();
        String name = projE.getAttributeValue(NAME, ns);
        Project project = new Project(name);
        this.increaseProgress();
        this.setStatus("Reading targets", 0);
        Element targetList = projE.getChild(TARGET_LIST, ns);
        HashMap<String, TargetGroup> targetGroups = new HashMap<String, TargetGroup>();
        for (Element targetE : targetList.getChildren()) {
            int varno;
            String id = targetE.getAttributeValue(ID, ns);
            this.setStatus(id, 1);
            String classStr = targetE.getAttributeValue(TARGET_TYPE, ns);
            Class<?> c = Class.forName(classStr);
            Method getBuilder = c.getMethod("getSequenceBuilder", new Class[0]);
            SequenceBuilder targetBuilder = (SequenceBuilder)getBuilder.invoke(null, (Object[])null);
            String seqStr = targetE.getChildText(SEQUENCE, ns);
            String typeStr = targetE.getChildText(TYPE, ns);
            String variantStr = targetE.getChildText(VARIANT, ns);
            String groupStr = targetE.getChildText(TARGET_GROUP, ns);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("ID", id);
            m.put("sequence.seqstring", seqStr);
            ProbeMakerTarget t = (ProbeMakerTarget)targetBuilder.buildObject(m);
            if (t instanceof ChangeableNucleotideSequence) {
                byte type = Byte.parseByte(typeStr);
                ((ChangeableNucleotideSequence)t).setType(type);
            }
            if (t instanceof VariantTarget && (varno = variantStr.length() == 0 ? -1 : Integer.parseInt(variantStr)) > -1) {
                VariantTarget vt = (VariantTarget)t;
                vt.setVariant(vt.getVariants()[varno]);
            }
            if (groupStr.length() > 0) {
                TargetGroup tg;
                if (targetGroups.containsKey(groupStr)) {
                    tg = (TargetGroup)targetGroups.get(groupStr);
                } else {
                    tg = new TargetGroup(groupStr);
                    targetGroups.put(groupStr, tg);
                }
                tg.addMember((Object)t);
            }
            project.getTargets().addSequence((Sequence)t);
        }
        this.increaseProgress();
        this.setStatus("Reading settings", 0);
        project.setSettings(SettingsXMLHandler.getSettings(projE.getChild("settings", ns)));
        this.increaseProgress();
        this.setStatus("Reading tag libraries", 0);
        TagLibrary[] libraries = this.getTagLibraries(projE.getChild(LIBRARIES, ns));
        project.setTagLibraries(libraries);
        project.getTagAllocationTable().setTagLibraries(libraries, project.getSettings().getDesignParameters());
        this.increaseProgress();
        this.setStatus("Reading probes", 0);
        Element probeList = projE.getChild(PROBE_LIST, ns);
        HashMap<String, ProbeGroup> probeGroups = new HashMap<String, ProbeGroup>();
        for (Element probeE : probeList.getChildren()) {
            String id = probeE.getAttributeValue(ID, ns);
            this.setStatus(id, 1);
            String probeName = probeE.getChildText(NAME, ns);
            String typeStr = probeE.getChildText(TYPE, ns);
            String rankStr = probeE.getChildText(RANK, ns);
            byte type = Byte.parseByte(typeStr);
            byte rank = Byte.parseByte(rankStr);
            ProbeGroup pg = null;
            Element groupE = probeE.getChild(PROBE_GROUP, ns);
            if (groupE != null) {
                String groupID = groupE.getAttributeValue(ID, ns);
                Attribute att = groupE.getAttribute(TARGET_GROUP, ns);
                TargetGroup tg = null;
                if (att != null) {
                    String tGroupID = att.getValue();
                    tg = (TargetGroup)targetGroups.get(tGroupID);
                }
                if ((pg = (ProbeGroup)((Object)probeGroups.get(groupID))) != null) {
                    pg = new ProbeGroup(tg, groupID);
                    probeGroups.put(groupID, pg);
                }
            }
            Element tssPairE = probeE.getChild(TSS_PAIR, ns);
            String targetID = tssPairE.getAttributeValue(TARGET_ID, ns);
            ProbeMakerTarget target = null;
            try {
                target = (ProbeMakerTarget)project.getTargets().getSequenceByID(targetID);
            }
            catch (IDNotFoundException e) {
                // empty catch block
            }
            HashMap<String, PropertyAcceptorNucleotideSequence> tssMap = new HashMap<String, PropertyAcceptorNucleotideSequence>();
            for (Element tssE : tssPairE.getChildren(TSS, ns)) {
                String key = tssE.getAttributeValue("key", ns);
                String tssID = tssE.getAttributeValue(ID, ns);
                String tssTypeStr = tssE.getChildText(TYPE, ns);
                String tssSeqStr = tssE.getChildText(SEQUENCE, ns);
                String tmStr = tssE.getChildText(TM, ns);
                PropertyAcceptorNucleotideSequence tss = ProbeMakerSequenceFactory.createTSS((NucleotideSequence)new SimpleNucleotideSequence(tssID, tssSeqStr, Byte.parseByte(tssTypeStr)), targetID);
                ProbeMakerPropertyUtils.setHybridizationTemp((PropertyAcceptor)tss, Float.parseFloat(tmStr));
                this.addMessagesFromElement((PropertyAcceptor)tss, tssE.getChild("messageList", ns));
                tssMap.put(key, tss);
            }
            PropertyAcceptorNucleotideSequence five = null;
            PropertyAcceptorNucleotideSequence three = null;
            five = (PropertyAcceptorNucleotideSequence)tssMap.get("FIVE_PRIME");
            three = (PropertyAcceptorNucleotideSequence)tssMap.get("THREE_PRIME");
            TSSPair tssP = ProbeMakerSequenceFactory.createTSSPair(five, three, target);
            this.addMessagesFromElement((PropertyAcceptor)tssP, tssPairE.getChild("messageList", ns));
            int upstream = -1;
            int downstream = -1;
            LinkedHashMap<NucleotideSequence, SequenceDB> tags = new LinkedHashMap<NucleotideSequence, SequenceDB>();
            List subEList = probeE.getChild(SUB_SEQUENCES, ns).getChildren();
            Element[] subEs = subEList.toArray(new Element[subEList.size()]);
            for (int pos = 0; pos < subEs.length; ++pos) {
                if (subEs[pos].getName().equals(TSS)) {
                    if (upstream == -1) {
                        upstream = pos;
                        continue;
                    }
                    if (downstream == -1) {
                        downstream = subEs.length - pos - 1;
                        continue;
                    }
                    throw new IllegalArgumentException("Only two TSSs per probe allowed");
                }
                if (subEs[pos].getName().equals(TAG_ID)) {
                    String tagID = subEs[pos].getAttributeValue(ID, ns);
                    KeyValue kv = this.getLibraryTag(libraries, tagID);
                    if (kv != null) {
                        NucleotideSequence tag = (NucleotideSequence)kv.getKey();
                        SequenceDB lib = (SequenceDB)kv.getValue();
                        tags.put(tag, lib);
                        continue;
                    }
                    throw new IllegalArgumentException("Could not find a tag named: " + tagID);
                }
                if (!subEs[pos].getName().equals(TAG)) continue;
                NucleotideSequence tag = this.getTag(subEs[pos]);
                tags.put(tag, null);
            }
            DefaultProbe p = new DefaultProbe(tssP, upstream, downstream, type);
            p.setID(id);
            p.setName(probeName);
            ProbeMakerPropertyUtils.setRank((PropertyAcceptor)p, rank);
            if (pg != null) {
                DesignUtils.addGroup((PropertyAcceptor)p, (Group)pg);
            }
            int pos = 0;
            for (NucleotideSequence t : tags.keySet()) {
                p.addTagAt(t, pos);
                project.getTagAllocationTable().use(t, p, pos);
                ++pos;
            }
            tags.clear();
            this.addMessagesFromElement((PropertyAcceptor)p, probeE.getChild("messageList", ns));
            project.getProbes().addSequence((Sequence)p);
        }
        targetGroups.clear();
        probeGroups.clear();
        this.increaseProgress();
        this.setStatus("Done", 0);
        return project;
    }
}

